/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import java.util.Set;
import uchicago.src.sim.analysis.DataCallback;

public class DataServer {
    int port = 4001;
    Selector selector = null;
    ServerSocketChannel selectableChannel = null;
    int keysAdded = 0;
    static final int BUFSIZE = 8;
    public static final String WRITE_FILE = "\u0007";

    public DataServer() {
    }

    public DataServer(int n) {
        this.port = n;
    }

    public void initialize() throws IOException {
        this.selector = SelectorProvider.provider().openSelector();
        this.selectableChannel = ServerSocketChannel.open();
        this.selectableChannel.configureBlocking(false);
        InetAddress inetAddress = InetAddress.getLocalHost();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
        this.selectableChannel.socket().bind(inetSocketAddress);
        System.out.println("server initialized");
    }

    public void finalize() throws IOException {
        this.selectableChannel.close();
        this.selector.close();
    }

    public void acceptConnections() throws IOException, InterruptedException {
        SelectionKey selectionKey = this.selectableChannel.register(this.selector, 16);
        System.out.println("accepting connections");
        while ((this.keysAdded = selectionKey.selector().select()) > 0) {
            Set<SelectionKey> set = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey2 = iterator.next();
                iterator.remove();
                if (selectionKey2.isAcceptable()) {
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey2.channel();
                    SocketChannel socketChannel = serverSocketChannel.accept();
                    socketChannel.configureBlocking(false);
                    SelectionKey selectionKey3 = socketChannel.register(this.selector, 5);
                    selectionKey3.attach(new DataCallback(socketChannel, "ModelName"));
                    continue;
                }
                if (!selectionKey2.isReadable()) continue;
                selectionKey2.channel();
                this.readMessage((DataCallback)selectionKey2.attachment());
            }
        }
    }

    public String decode(ByteBuffer byteBuffer) throws CharacterCodingException {
        Charset charset = Charset.forName("us-ascii");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
        String string = charBuffer.toString();
        return string;
    }

    public void readMessage(DataCallback dataCallback) throws IOException, InterruptedException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        dataCallback.getChannel().read(byteBuffer);
        byteBuffer.flip();
        String string = this.decode(byteBuffer);
        dataCallback.record(string.toString());
        if (string.indexOf(WRITE_FILE) >= 0) {
            dataCallback.execute();
            dataCallback.getChannel().close();
            System.out.println("channel closed");
        }
    }
}

