/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.adaptation.neural;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Synapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.net.NeuralNet;
import uchicago.src.sim.adaptation.neural.NeuralException;
import uchicago.src.sim.adaptation.neural.RepastNeuralWrapper;

public class NeuralUtils {
    private NeuralUtils() {
    }

    public static RepastNeuralWrapper buildNetwork(int[] nArray, Class clazz, Class clazz2) throws NeuralException {
        Class[] classArray = new Class[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            classArray[i] = clazz;
        }
        Class[] classArray2 = new Class[nArray.length - 1];
        for (int i = 0; i < nArray.length - 1; ++i) {
            classArray2[i] = clazz2;
        }
        return NeuralUtils.buildNetwork(nArray, classArray, classArray2);
    }

    public static RepastNeuralWrapper buildNetwork(int[] nArray, Class[] classArray, Class[] classArray2) throws NeuralException, IllegalArgumentException {
        if (nArray.length != classArray.length || classArray.length - 1 != classArray2.length) {
            throw new IllegalArgumentException("In NeuralUtils.buildNetwork, the lengthof the passed in arrays must be nodesPerLayer.length == layerTypes.length andlayerTypes.length - 1 == synapseTypes.length");
        }
        try {
            NeuralNet neuralNet = new NeuralNet();
            RepastNeuralWrapper repastNeuralWrapper = new RepastNeuralWrapper(neuralNet);
            if (nArray.length == 0) {
                return repastNeuralWrapper;
            }
            Layer layer = null;
            for (int i = 0; i < nArray.length; ++i) {
                Layer layer2 = (Layer)classArray[i].newInstance();
                layer2.setRows(nArray[i]);
                if (layer != null) {
                    NeuralUtils.linkLayers(layer, layer2, classArray2[i - 1]);
                }
                if (i == 0) {
                    neuralNet.addLayer(layer2, 0);
                    layer2.setLayerName("Input Layer");
                } else if (i < nArray.length - 1) {
                    neuralNet.addLayer(layer2, 1);
                    layer2.setLayerName("Hidden Layer (" + (i - 1) + ")");
                } else {
                    neuralNet.addLayer(layer2, 2);
                    layer2.setLayerName("Output Layer");
                }
                layer = layer2;
            }
            neuralNet.setTeacher(new TeachingSynapse());
            return repastNeuralWrapper;
        }
        catch (InstantiationException instantiationException) {
            throw new NeuralException("NeuralUtils.linkLayers: Couldn't create an instance of the specified layer/synapse type\nDo both classes supply default constructors?", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NeuralException("NeuralUtils.linkLayers: Couldn't create an instance of the specified layer/synapse type\nDo both classes supply default constructors?", illegalAccessException);
        }
    }

    public static Synapse linkLayers(Layer layer, Layer layer2, Class clazz) throws NeuralException {
        try {
            Synapse synapse = (Synapse)clazz.newInstance();
            layer2.addInputSynapse((InputPatternListener)synapse);
            layer.addOutputSynapse((OutputPatternListener)synapse);
            return synapse;
        }
        catch (InstantiationException instantiationException) {
            throw new NeuralException("NeuralUtils.linkLayers: Couldn't create an instance of the specified synapse type", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NeuralException("NeuralUtils.linkLayers: Couldn't create an instance of the specified synapse type", illegalAccessException);
        }
    }

    public static void saveNetToFile(NeuralNet neuralNet, String string) throws NeuralException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(neuralNet);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            throw new NeuralException("Error saving net to file: " + exception.getMessage(), exception);
        }
    }

    public static RepastNeuralWrapper loadNetFromFile(String string) throws NeuralException {
        NeuralNet neuralNet = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            neuralNet = (NeuralNet)objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new NeuralException("Error loading network from file", exception);
        }
        neuralNet.start();
        neuralNet.getMonitor().Go();
        neuralNet.stop();
        return new RepastNeuralWrapper(neuralNet);
    }
}

