/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.reflector;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import uchicago.src.collection.Pair;

public class MethodFactory {
    private static MethodFactory mf = new MethodFactory();

    private MethodFactory() {
    }

    public static MethodFactory getInstance() {
        return mf;
    }

    public TreeMap getAccessorMethods(Class clazz, String[] stringArray) throws IntrospectionException {
        TreeMap<String, Pair> treeMap = new TreeMap<String, Pair>();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            Pair pair = null;
            pair = stringArray != null ? this.getPropertyPair(propertyDescriptor, stringArray) : new Pair(propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod());
            if (pair == null) continue;
            StringBuffer stringBuffer = new StringBuffer(propertyDescriptor.getName().trim());
            char c = Character.toUpperCase(stringBuffer.charAt(0));
            stringBuffer.setCharAt(0, c);
            treeMap.put(stringBuffer.toString(), pair);
        }
        return treeMap;
    }

    private Pair getPropertyPair(PropertyDescriptor propertyDescriptor, String[] stringArray) {
        String string = propertyDescriptor.getName().toLowerCase();
        Pair pair = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].toLowerCase();
            if (!string2.equals(string)) continue;
            Method method = propertyDescriptor.getReadMethod();
            Method method2 = propertyDescriptor.getWriteMethod();
            pair = new Pair(method, method2);
            break;
        }
        return pair;
    }

    public Hashtable findGetMethods(Class clazz, ArrayList arrayList) throws IntrospectionException {
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        TreeMap treeMap = this.getAccessorMethods(clazz, stringArray);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Pair pair = (Pair)treeMap.get(string);
            if (pair.first == null) continue;
            hashtable.put(string, pair.first);
        }
        return hashtable;
    }
}

