/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.collection.NewMatrix;
import uchicago.src.sim.space.Discrete2DSpace;
import uchicago.src.sim.space.MooreNeighborhooder;
import uchicago.src.sim.space.Neighborhooder;
import uchicago.src.sim.space.VNNeighborhooder;
import uchicago.src.sim.util.SimUtilities;

public class Object2DGrid
implements Discrete2DSpace {
    public static final int PGM_ASCII = 0;
    public static final int RASTER_ASCII = 1;
    protected NewMatrix matrix;
    protected int xSize;
    protected int ySize;
    protected Neighborhooder VNneigh;
    protected Neighborhooder Mneigh;

    public Object2DGrid(int n, int n2) {
        this.xSize = n;
        this.ySize = n2;
        this.matrix = new NewMatrix(n, n2);
        this.VNneigh = new VNNeighborhooder(this);
        this.Mneigh = new MooreNeighborhooder(this);
    }

    public Object2DGrid(InputStream inputStream, int n) {
        if (n != 0) {
            throw new IllegalArgumentException("File type not supported.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.init(bufferedReader);
    }

    public Object2DGrid(String string, int n) {
        if (n != 0) {
            throw new IllegalArgumentException("File type not supported.");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.init(bufferedReader);
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error Reading image file", iOException);
            iOException.printStackTrace();
            System.exit(0);
        }
    }

    private void init(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            if (!string.equals("P2")) {
                throw new UnsupportedEncodingException("File is not in PGM ascii format");
            }
            string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.xSize = Integer.valueOf(stringTokenizer.nextToken());
            this.ySize = Integer.valueOf(stringTokenizer.nextToken());
            bufferedReader.readLine();
            string = "";
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string = string + string2 + " ";
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            stringTokenizer = new StringTokenizer(string);
            this.matrix = new NewMatrix(this.xSize, this.ySize);
            for (int i = 0; i < this.xSize; ++i) {
                for (int j = 0; j < this.ySize; ++j) {
                    this.matrix.put(i, j, Integer.valueOf(stringTokenizer.nextToken()));
                }
            }
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error Reading image file", iOException);
            iOException.printStackTrace();
            System.exit(0);
        }
        this.VNneigh = new VNNeighborhooder(this);
        this.Mneigh = new MooreNeighborhooder(this);
    }

    public Vector getVonNeumannNeighbors(int n, int n2, boolean bl) {
        int[] nArray = new int[]{1, 1};
        return this.VNneigh.getNeighbors(n, n2, nArray, bl);
    }

    public Vector getVonNeumannNeighbors(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return this.VNneigh.getNeighbors(n, n2, nArray, bl);
    }

    public Vector getMooreNeighbors(int n, int n2, boolean bl) {
        int[] nArray = new int[]{1, 1};
        return this.Mneigh.getNeighbors(n, n2, nArray, bl);
    }

    public Vector getMooreNeighbors(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return this.Mneigh.getNeighbors(n, n2, nArray, bl);
    }

    public void setComparator(Comparator comparator) {
        this.VNneigh.setComparator(comparator);
        this.Mneigh.setComparator(comparator);
    }

    public Vector findMaximum(int n, int n2, int n3, boolean bl, int n4) {
        Vector vector = new Vector();
        int[] nArray = new int[]{n3, n3};
        if (n4 == 0) {
            vector = this.VNneigh.findMaximum(n, n2, nArray, bl);
        }
        if (n4 == 1) {
            vector = this.Mneigh.findMaximum(n, n2, nArray, bl);
        }
        return vector;
    }

    public Vector findMinimum(int n, int n2, int n3, boolean bl, int n4) {
        Vector vector = new Vector();
        int[] nArray = new int[]{n3, n3};
        if (n4 == 0) {
            vector = this.VNneigh.findMinimum(n, n2, nArray, bl);
        } else if (n4 == 1) {
            vector = this.Mneigh.findMinimum(n, n2, nArray, bl);
        }
        return vector;
    }

    protected void rangeCheck(int n, int n2) {
        if (n < 0 || n >= this.xSize || n2 < 0 || n2 >= this.ySize) {
            throw new IndexOutOfBoundsException("x or y coordinate is out of bounds");
        }
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public Dimension getSize() {
        return new Dimension(this.xSize, this.ySize);
    }

    public Object getObjectAt(int n, int n2) {
        this.rangeCheck(n, n2);
        return this.matrix.get(n, n2);
    }

    public double getValueAt(int n, int n2) {
        this.rangeCheck(n, n2);
        Object object = this.matrix.get(n, n2);
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue();
        }
        throw new IllegalArgumentException("Object cannot be converted to a long");
    }

    public void putObjectAt(int n, int n2, Object object) {
        this.rangeCheck(n, n2);
        this.matrix.put(n, n2, object);
    }

    public void putValueAt(int n, int n2, double d) {
        this.rangeCheck(n, n2);
        this.matrix.put(n, n2, new Double(d));
    }

    public BaseMatrix getMatrix() {
        return this.matrix;
    }
}

