/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import uchicago.src.sim.network.AdjacencyMatrix;
import uchicago.src.sim.network.AdjacencyMatrixFactory;
import uchicago.src.sim.network.DefaultEdge;
import uchicago.src.sim.network.DefaultNode;
import uchicago.src.sim.network.NetworkFactory;
import uchicago.src.sim.network.NetworkMatrixReader;
import uchicago.src.sim.util.SimUtilities;

public class ExcelMatrixReader
implements NetworkMatrixReader {
    private HSSFWorkbook workbook = null;
    private int type = 2;
    private int curRow = 0;
    private int numRows = 0;

    public ExcelMatrixReader(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)fileInputStream);
            this.workbook = new HSSFWorkbook(pOIFSFileSystem);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            SimUtilities.showError("Error reading network file: " + string, iOException);
            System.exit(0);
        }
    }

    private AdjacencyMatrix getLabeledMatrix(HSSFSheet hSSFSheet) throws IOException {
        AdjacencyMatrix adjacencyMatrix = null;
        HSSFRow hSSFRow = null;
        HSSFCell hSSFCell = null;
        hSSFRow = hSSFSheet.getRow(0);
        Vector vector = new Vector(hSSFRow.getPhysicalNumberOfCells() - 1);
        Iterator iterator = hSSFRow.cellIterator();
        while (iterator.hasNext()) {
            hSSFCell = (HSSFCell)iterator.next();
            if (hSSFCell.getCellNum() != 0 || hSSFCell.getStringCellValue().equals("")) continue;
            throw new IOException("Badly formatted Excel matrix file: labels must start at 1, 2");
        }
        if (vector.size() != 0) {
            adjacencyMatrix = AdjacencyMatrixFactory.createAdjacencyMatrix(vector, this.type);
        }
        return adjacencyMatrix;
    }

    private AdjacencyMatrix getNonLabeledMatrix(HSSFSheet hSSFSheet) {
        AdjacencyMatrix adjacencyMatrix = null;
        int n = hSSFSheet.getPhysicalNumberOfRows() - 1;
        adjacencyMatrix = AdjacencyMatrixFactory.createAdjacencyMatrix(n, n, this.type);
        return adjacencyMatrix;
    }

    private AdjacencyMatrix getMatrix(String string) throws IOException {
        HSSFSheet hSSFSheet = this.workbook.getSheet(string);
        HSSFRow hSSFRow = null;
        HSSFCell hSSFCell = null;
        AdjacencyMatrix adjacencyMatrix = null;
        adjacencyMatrix = this.getLabeledMatrix(hSSFSheet);
        this.numRows = hSSFSheet.getPhysicalNumberOfRows();
        if (adjacencyMatrix == null) {
            adjacencyMatrix = this.getNonLabeledMatrix(hSSFSheet);
        }
        ++this.curRow;
        for (int i = 1; i < this.numRows; ++i) {
            hSSFRow = hSSFSheet.getRow(i);
            Iterator iterator = hSSFRow.cellIterator();
            while (iterator.hasNext()) {
                hSSFCell = (HSSFCell)iterator.next();
                Short s = new Short(hSSFCell.getCellNum());
                adjacencyMatrix.set(s.intValue() - 1, i - 1, hSSFCell.getNumericCellValue());
            }
        }
        if (!string.startsWith("Sheet")) {
            adjacencyMatrix.setMatrixLabel(string);
        }
        return adjacencyMatrix;
    }

    public Vector getMatrices() throws IOException {
        return this.getMatrices(2);
    }

    public Vector getMatrices(int n) throws IOException {
        Vector<AdjacencyMatrix> vector = new Vector<AdjacencyMatrix>();
        this.type = n;
        int n2 = this.workbook.getNumberOfSheets();
        for (int i = 0; i < n2; ++i) {
            vector.add(this.getMatrix(this.workbook.getSheetName(i)));
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        try {
            List list = NetworkFactory.getNetwork("uchicago/src/sim/test/Exported.xls", 1, DefaultNode.class, DefaultEdge.class, 2);
            System.out.println(list.size());
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void close() {
        this.workbook = null;
    }
}

