/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import uchicago.src.sim.gui.NonGridDrawable;
import uchicago.src.sim.gui.SimGraphics;

public abstract class DrawableItem
implements NonGridDrawable {
    protected String label = null;
    protected Font font = new Font("monospace", 1, 9);
    protected Color labelColor = Color.yellow;
    protected Color color = Color.blue;
    protected Color borderColor = Color.white;
    protected int borderWidth = 0;
    protected int width = 8;
    protected int height = 8;
    protected boolean recalc = true;
    protected boolean allowResizing = true;
    protected boolean hollow = false;
    protected BasicStroke stroke = null;

    public void allowResizing(boolean bl) {
        if (bl != this.allowResizing) {
            this.recalc = true;
            this.allowResizing = bl;
        }
    }

    public void setLabel(String string) {
        if (string != null) {
            if (!string.equals(this.label)) {
                this.label = string;
                this.recalc = true;
            }
        } else {
            this.label = null;
        }
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setFont(Font font) {
        if (!font.equals(this.font)) {
            this.font = font;
            this.recalc = true;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        if (this.borderWidth != n) {
            this.borderWidth = n;
            this.stroke = new BasicStroke(this.borderWidth);
            this.recalc = true;
        }
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setWidth(int n) {
        this.width = n;
        this.recalc = true;
    }

    public void setHeight(int n) {
        this.height = n;
        this.recalc = true;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.recalc = true;
    }

    public void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
        this.recalc = true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public void setHollow(boolean bl) {
        this.hollow = bl;
    }

    public void calcSize(SimGraphics simGraphics) {
        if (this.recalc && this.allowResizing) {
            if (this.font == null || this.label == null) {
                this.width = 8 + this.borderWidth;
                this.height = 10 + this.borderWidth;
            } else {
                Rectangle2D rectangle2D = simGraphics.getStringBounds(this.label, this.font);
                this.width = (int)rectangle2D.getWidth() + 6 + this.borderWidth;
                this.height = (int)rectangle2D.getHeight() + 8 + this.borderWidth;
            }
            this.recalc = false;
        }
    }
}

