/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import uchicago.src.collection.Pair;
import uchicago.src.sim.event.CheckBoxListener;
import uchicago.src.sim.event.SliderListener;

public class ModelManipulator {
    private ArrayList sliders = new ArrayList();
    private ArrayList buttons = new ArrayList();
    private ArrayList components = new ArrayList();
    private boolean enabled = false;
    private JPanel panel;

    public void init() {
        this.sliders.clear();
        this.buttons.clear();
        this.components.clear();
        this.panel = null;
    }

    public void addSlider(String string, int n, int n2, int n3, SliderListener sliderListener) {
        JSlider jSlider = new JSlider();
        jSlider.setMaximum(n2);
        jSlider.setMinimum(n);
        jSlider.setMajorTickSpacing(n3);
        jSlider.createStandardLabels(n3);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.addChangeListener(sliderListener);
        jSlider.setEnabled(this.enabled);
        jSlider.setValue(n);
        sliderListener.setFirstVal(n);
        JLabel jLabel = new JLabel(string);
        this.sliders.add(new Pair(jLabel, jSlider));
    }

    public void addButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        jButton.setEnabled(false);
        this.buttons.add(jButton);
    }

    public void addComponent(Component component) {
        this.components.add(component);
    }

    public void addCheckBox(String string, CheckBoxListener checkBoxListener, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox(string, bl);
        jCheckBox.addActionListener(checkBoxListener);
        checkBoxListener.setSelected(bl);
        this.buttons.add(jCheckBox);
    }

    public void setEnabled(boolean bl) {
        Object object;
        int n;
        this.enabled = bl;
        for (n = 0; n < this.sliders.size(); ++n) {
            object = (Pair)this.sliders.get(n);
            JSlider jSlider = (JSlider)((Pair)object).second;
            jSlider.setEnabled(bl);
        }
        for (n = 0; n < this.buttons.size(); ++n) {
            object = (AbstractButton)this.buttons.get(n);
            ((AbstractButton)object).setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            JPanel jPanel;
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel(new BorderLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 11;
            JPanel jPanel4 = new JPanel(new GridBagLayout());
            for (int i = 0; i < this.sliders.size(); ++i) {
                gridBagConstraints.gridy = i;
                jPanel = new JPanel(new GridLayout(3, 1, 0, 0));
                Pair pair = (Pair)this.sliders.get(i);
                jPanel.add((JLabel)pair.first);
                jPanel.add((JSlider)pair.second);
                jPanel4.add((Component)jPanel, gridBagConstraints);
            }
            Border border = BorderFactory.createEtchedBorder();
            jPanel2.setBorder(border);
            jPanel2.add((Component)jPanel4, "North");
            jPanel = new JPanel(new GridBagLayout());
            for (int i = 0; i < this.buttons.size(); ++i) {
                gridBagConstraints.gridy = i;
                jPanel.add((Component)((AbstractButton)this.buttons.get(i)), gridBagConstraints);
            }
            Border border2 = BorderFactory.createEtchedBorder();
            jPanel3.setBorder(border2);
            jPanel3.add((Component)jPanel, "North");
            JPanel jPanel5 = new JPanel(new GridBagLayout());
            jPanel5.setBorder(BorderFactory.createEtchedBorder());
            for (int i = 0; i < this.components.size(); ++i) {
                gridBagConstraints.gridy = i;
                jPanel5.add((Component)this.components.get(i), gridBagConstraints);
            }
            this.panel.add(jPanel2);
            this.panel.add(jPanel3);
            this.panel.add(jPanel5);
        }
        return this.panel;
    }
}

