/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.lang.reflect.Method;
import java.util.List;
import uchicago.src.codegen.GeneratorException;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.util.ByteCodeBuilder;
import uchicago.src.sim.util.SimUtilities;

public class ActionUtilities {
    public static BasicAction createActionFor(Object object, String string) {
        BasicAction basicAction = null;
        try {
            basicAction = ByteCodeBuilder.generateBasicAction(object, string);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating action: " + string + " on " + object.getClass().getName(), generatorException);
            System.exit(0);
        }
        return basicAction;
    }

    public static BasicAction createActionForEach(List list, String string) {
        BasicAction basicAction = null;
        try {
            basicAction = ByteCodeBuilder.generateBasicActionForList(list, string);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating action for list: " + string, generatorException);
            System.exit(0);
        }
        return basicAction;
    }

    public static BasicAction createActionForEachRnd(List list, String string) {
        BasicAction basicAction = null;
        try {
            basicAction = ByteCodeBuilder.generateBasicActionForListRnd(list, string);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating action for list: " + string, generatorException);
            System.exit(0);
        }
        return basicAction;
    }

    public static BasicAction createActionForEach(List list, Class clazz, String string) {
        BasicAction basicAction = null;
        try {
            basicAction = ByteCodeBuilder.generateBasicActionForList(list, string, clazz, false);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating action for list: " + string, generatorException);
            System.exit(0);
        }
        return basicAction;
    }

    public static BasicAction createActionForEachRnd(List list, Class clazz, String string) {
        BasicAction basicAction = null;
        try {
            basicAction = ByteCodeBuilder.generateBasicActionForList(list, string, clazz, true);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating action for list: " + string, generatorException);
            System.exit(0);
        }
        return basicAction;
    }

    public static Method getNoArgMethod(Object object, String string) throws NoSuchMethodException {
        Class[] classArray = new Class[]{};
        Class<?> clazz = object.getClass();
        return clazz.getMethod(string, classArray);
    }

    public static Method getNoArgMethod(Class clazz, String string) throws NoSuchMethodException {
        Class[] classArray = new Class[]{};
        return clazz.getMethod(string, classArray);
    }
}

