/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.codegen;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uchicago.src.codegen.CodeGenerator;
import uchicago.src.codegen.CompUnitGenerator;
import uchicago.src.codegen.GeneratorUtilities;

public class CompUnitParser {
    private Stack stack = new Stack();
    private Document doc;

    public CompUnitParser(String string) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.doc = documentBuilderFactory.newDocumentBuilder().parse(new FileInputStream(string), string);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private void doParse(Node node) {
        CodeGenerator codeGenerator = GeneratorUtilities.createCodeGenerator(node);
        if (codeGenerator != null) {
            this.stack.push(codeGenerator);
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    String string = node2.getNodeName();
                    if (node2.getNodeType() == 1) {
                        this.doParse(node2);
                        Object e = this.stack.pop();
                        codeGenerator.add(string, e);
                        continue;
                    }
                    if (node2.getNodeType() != 4) continue;
                    codeGenerator.add("BODY_TEXT", node2.getNodeValue());
                }
            }
        }
    }

    public CompUnitGenerator parse() {
        this.doParse(this.doc.getDocumentElement());
        return (CompUnitGenerator)this.stack.pop();
    }

    public static void main(String[] stringArray) {
        try {
            CompUnitParser compUnitParser = new CompUnitParser(stringArray[0]);
            CompUnitGenerator compUnitGenerator = compUnitParser.parse();
            System.out.println(compUnitGenerator.generate(0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }
}

