/*
 * Decompiled with CFR 0.152.
 */
package PastaLoverAgent;

import PastaLoverAgent.MyVehicle;
import PastaLoverAgent.NodePD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import logist.agent.Agent;
import logist.plan.Action;
import logist.plan.Plan;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.topology.Topology;

public class SLS {
    private Topology topology;
    private TaskDistribution distribution;
    private Agent agent;
    private double timeout_plan;
    private double time_start;
    private double finalTime = 0.0;
    private List vehiclesList;
    private Task[] tasks;
    private int Nt;
    private int Nv;
    private int Na;
    private double p = 0.5;
    private int numIt = 50000;
    private Random random;
    private int n = 5;
    private int firstV = 0;
    private int lastV = 10;
    private NodePD bestGlobal = null;

    public SLS(Topology topology, TaskDistribution distribution, Agent agent) {
        this.topology = topology;
        this.distribution = distribution;
        this.agent = agent;
        this.random = new Random();
    }

    public NodePD RunSLS(List vehicles, Task[] tasksSet, double timeout_plan, NodePD bestSolution) {
        if (tasksSet.length == 0) {
            return null;
        }
        this.time_start = System.currentTimeMillis();
        this.timeout_plan = timeout_plan;
        this.vehiclesList = vehicles;
        this.tasks = tasksSet;
        this.Nt = this.tasks.length;
        this.Nv = this.vehiclesList.size();
        this.Na = 2 * this.Nt;
        this.bestGlobal = null;
        for (int v = 0; v < this.Nv + 1; ++v) {
            double duration;
            NodePD A = this.selectInitialSolution(v);
            if (A == null) {
                return null;
            }
            if (this.bestGlobal == null) {
                this.bestGlobal = A;
            }
            NodePD localBest = A;
            for (int i = 0; i < this.numIt; ++i) {
                double duration2 = (double)System.currentTimeMillis() - this.time_start;
                if (duration2 > 0.95 * timeout_plan) {
                    return this.bestGlobal;
                }
                NodePD Aold = A;
                ArrayList N = this.chooseNeighbours(A);
                A = this.localChoice4(N, Aold);
                int _tmp = i % 100;
                if (!(A.getOValue(this.tasks, this.vehiclesList) < localBest.getOValue(this.tasks, this.vehiclesList))) continue;
                localBest = A;
            }
            if (!(localBest.getOValue(this.tasks, this.vehiclesList) < this.bestGlobal.getOValue(this.tasks, this.vehiclesList))) continue;
            this.bestGlobal = localBest;
            this.finalTime = duration = (double)System.currentTimeMillis() - this.time_start;
        }
        double duration = (double)System.currentTimeMillis() - this.time_start;
        return this.bestGlobal;
    }

    private NodePD localChoice4(ArrayList N, NodePD Aold) {
        if (N.size() == 0) {
            return Aold;
        }
        N.add(Aold);
        NodePD bestNodePD = (NodePD)N.get(0);
        for (NodePD n : N) {
            if (!(n.getOValue(this.tasks, this.vehiclesList) <= bestNodePD.getOValue(this.tasks, this.vehiclesList))) continue;
            bestNodePD = n;
        }
        if (Math.random() <= 0.7) {
            return bestNodePD;
        }
        return (NodePD)N.get(this.random.nextInt(N.size()));
    }

    private NodePD localChoice3(PriorityQueue N, NodePD Aold) {
        if (N.size() == 0) {
            return Aold;
        }
        NodePD bestNodePD = (NodePD)N.poll();
        for (NodePD n : N) {
            if (!(n.getOValue(this.tasks, this.vehiclesList) <= bestNodePD.getOValue(this.tasks, this.vehiclesList))) continue;
            bestNodePD = n;
        }
        double pp = Math.random();
        if (Aold.getOValue() > bestNodePD.getOValue()) {
            if (pp <= this.p) {
                return bestNodePD;
            }
            return Aold;
        }
        if (pp > this.p) {
            return bestNodePD;
        }
        return Aold;
    }

    private NodePD localChoice2(PriorityQueue N, NodePD Aold) {
        if (N.size() == 0) {
            return Aold;
        }
        NodePD bestNodePD = (NodePD)N.poll();
        int r = this.random.nextInt(N.size());
        for (int k = 0; k < r; ++k) {
            bestNodePD = (NodePD)N.poll();
        }
        double pp = Math.random();
        if (Aold.getOValue() > bestNodePD.getOValue()) {
            if (pp <= this.p) {
                return bestNodePD;
            }
            return Aold;
        }
        if (pp > this.p) {
            return bestNodePD;
        }
        return Aold;
    }

    private NodePD localChoice1(PriorityQueue N, NodePD Aold) {
        if (N.size() == 0) {
            return Aold;
        }
        NodePD bestNodePD = (NodePD)N.poll();
        for (NodePD n : N) {
            if (!(n.getOValue(this.tasks, this.vehiclesList) <= bestNodePD.getOValue(this.tasks, this.vehiclesList))) continue;
            bestNodePD = n;
        }
        if (Math.random() <= this.p) {
            return bestNodePD;
        }
        return Aold;
    }

    private ArrayList chooseNeighbours(NodePD Aold) {
        ArrayList<NodePD> N = new ArrayList<NodePD>();
        PriorityQueue Pr = new PriorityQueue();
        int vi = this.random(Aold);
        int length = 0;
        int t = Aold.nextAction(vi + this.Na);
        while (t != -1) {
            t = Aold.nextAction(t);
            ++length;
        }
        for (int p1 = 0; p1 < length / 2; ++p1) {
            for (int vj = 0; vj < this.Nv; ++vj) {
                if (vj == vi) continue;
                int lv2 = 0;
                int t2 = Aold.nextAction(vj + this.Na);
                while (t2 != -1) {
                    t2 = Aold.nextAction(t2);
                    ++lv2;
                }
                for (int tIdx1 = 0; tIdx1 < lv2 + 1; ++tIdx1) {
                    for (int tIdx2 = tIdx1 + 1; tIdx2 < lv2 + 2; ++tIdx2) {
                        NodePD A;
                        int a = Aold.nextAction(vi + this.Na);
                        if (this.tasks[a].weight > ((MyVehicle)this.vehiclesList.get(vi)).capacity() || (A = this.changingVehicle(Aold, vi, vj, p1, tIdx1, tIdx2)) == null) continue;
                        if (A.getOValue(this.tasks, this.vehiclesList) < this.bestGlobal.getOValue(this.tasks, this.vehiclesList)) {
                            double duration;
                            this.bestGlobal = A;
                            this.finalTime = duration = (double)System.currentTimeMillis() - this.time_start;
                        }
                        N.add(A);
                    }
                }
            }
        }
        if (length >= 2) {
            for (int tIdx1 = 0; tIdx1 < length - 1; ++tIdx1) {
                for (int tIdx2 = tIdx1 + 1; tIdx2 < length; ++tIdx2) {
                    NodePD A = this.changingTaskOrder(Aold, vi, tIdx1, tIdx2);
                    if (A == null) continue;
                    if (A.getOValue(this.tasks, this.vehiclesList) < this.bestGlobal.getOValue(this.tasks, this.vehiclesList)) {
                        double duration;
                        this.bestGlobal = A;
                        this.finalTime = duration = (double)System.currentTimeMillis() - this.time_start;
                    }
                    N.add(A);
                }
            }
        }
        return N;
    }

    private NodePD changingVehicle(NodePD A, int v1, int v2, int aIndex, int pIndex, int dIndex) {
        int a;
        int length;
        NodePD A1 = A.clone();
        int p = A1.nextAction(v1 + this.Na);
        int count = 0;
        while (count < aIndex) {
            if ((p = A1.nextAction(p)) >= this.Nt) continue;
            ++count;
        }
        if (this.tasks[p].weight > ((MyVehicle)this.vehiclesList.get(v2)).capacity()) {
            return null;
        }
        int d = p + this.Nt;
        int dNext = A1.nextAction(d);
        int dPrevious = A1.previousAction(d);
        int v2Next = A1.nextAction(v2 + this.Na);
        int pPrevious = A1.previousAction(p);
        int pNext = A1.nextAction(p);
        Boolean following = A1.nextAction(p) == d;
        if (!following.booleanValue()) {
            A1.nextAction(pPrevious, pNext);
            A1.previousAction(pNext, pPrevious);
            A1.nextAction(dPrevious, dNext);
            if (dNext != -1) {
                A1.previousAction(dNext, dPrevious);
            }
        } else {
            A1.nextAction(pPrevious, dNext);
            if (dNext != -1) {
                A1.previousAction(dNext, pPrevious);
            }
        }
        int last = v2 + this.Na;
        int posP = A1.nextAction(v2 + this.Na);
        for (length = 0; length != pIndex; ++length) {
            last = posP;
            posP = A1.nextAction(posP);
        }
        if (posP != -1) {
            int previousPosP = A1.previousAction(posP);
            A1.nextAction(previousPosP, p);
            A1.nextAction(p, posP);
            A1.previousAction(p, previousPosP);
            A1.previousAction(posP, p);
            int posD = A1.nextAction(v2 + this.Na);
            int last2 = v2 + this.Na;
            for (length = 0; length != dIndex; ++length) {
                last2 = posD;
                posD = A1.nextAction(posD);
            }
            if (posD != -1) {
                int previousPosD = A1.previousAction(posD);
                A1.nextAction(previousPosD, d);
                A1.nextAction(d, posD);
                A1.previousAction(d, previousPosD);
                A1.previousAction(posD, d);
            } else {
                A1.nextAction(last2, d);
                A1.previousAction(d, last2);
                A1.nextAction(d, -1);
            }
        } else {
            A1.nextAction(last, p);
            A1.previousAction(p, last);
            A1.nextAction(p, d);
            A1.previousAction(d, p);
            A1.nextAction(d, -1);
        }
        this.updateTime(A1, v1);
        this.updateTime(A1, v2);
        A1.setVehicle(p, v2);
        A1.setVehicle(d, v2);
        if (!following.booleanValue()) {
            a = pNext;
            while (a != dNext) {
                A1.setLoad(a, A1.getLoad(a) - this.tasks[p].weight);
                a = A1.nextAction(a);
            }
        }
        a = A1.nextAction(v2 + this.Na);
        int b = -1;
        while (a != -1) {
            int loadA;
            int loadB = 0;
            if (b != -1) {
                loadB = A1.getLoad(b);
            }
            if (loadB + (loadA = a < this.Nt ? this.tasks[a].weight : -this.tasks[a - this.Nt].weight) > ((MyVehicle)this.vehiclesList.get(v2)).capacity()) {
                return null;
            }
            A1.setLoad(a, loadB + loadA);
            b = a;
            a = A1.nextAction(a);
        }
        return A1;
    }

    private NodePD changingTaskOrder(NodePD A, int v, int t1, int t2) {
        boolean a2Last;
        int delta;
        int count;
        NodePD A1 = A.clone();
        int a1 = A1.nextAction(v + this.Na);
        for (count = 0; count < t1; ++count) {
            a1 = A1.nextAction(a1);
        }
        int a2 = A1.nextAction(a1);
        ++count;
        while (count < t2) {
            a2 = A1.nextAction(a2);
            ++count;
        }
        int time1 = A1.getTime(a1);
        int capacity = ((MyVehicle)this.vehiclesList.get(A1.getVehicle(a1))).capacity();
        if (a1 >= this.Nt) {
            if (a2 >= this.Nt) {
                if (time1 <= A1.getTime(a2 - this.Nt)) {
                    return null;
                }
                delta = this.tasks[a1 - this.Nt].weight - this.tasks[a2 - this.Nt].weight;
                if (delta > 0) {
                    i = a1;
                    while (i != a2) {
                        if (A1.getLoad(i) + delta > capacity) {
                            return null;
                        }
                        i = A1.nextAction(i);
                    }
                }
                a1Load = A1.getLoad(a1);
                a2Load = A1.getLoad(a2);
                A1.setLoad(a2, a1Load + delta);
                A1.setLoad(a1, a2Load);
            } else {
                delta = this.tasks[a1 - this.Nt].weight + this.tasks[a2].weight;
                i = a1;
                while (i != a2) {
                    if (A1.getLoad(i) + delta > capacity) {
                        return null;
                    }
                    i = A1.nextAction(i);
                }
                a1Load = A1.getLoad(a1);
                a2Load = A1.getLoad(a2);
                A1.setLoad(a2, a1Load + delta);
                A1.setLoad(a1, a2Load);
            }
        } else if (a2 >= this.Nt) {
            if (time1 <= A1.getTime(a2 - this.Nt) || A1.getTime(a2) >= A1.getTime(a1 + this.Nt)) {
                return null;
            }
            delta = -this.tasks[a1].weight - this.tasks[a2 - this.Nt].weight;
            a1Load = A1.getLoad(a1);
            a2Load = A1.getLoad(a2);
            A1.setLoad(a2, a1Load + delta);
            A1.setLoad(a1, a2Load);
        } else {
            if (A1.getTime(a2) >= A1.getTime(a1 + this.Nt)) {
                return null;
            }
            delta = this.tasks[a2].weight - this.tasks[a1].weight;
            if (delta > 0) {
                i = a1;
                while (i != a2) {
                    if (A1.getLoad(i) + delta > capacity) {
                        return null;
                    }
                    i = A1.nextAction(i);
                }
            }
            a1Load = A1.getLoad(a1);
            a2Load = A1.getLoad(a2);
            A1.setLoad(a2, a1Load + delta);
            A1.setLoad(a1, a2Load);
        }
        boolean bl = a2Last = A1.nextAction(a2) == -1;
        if (A1.nextAction(a1) == a2) {
            A1.nextAction(A1.previousAction(a1), a2);
            if (!a2Last) {
                A1.previousAction(A1.nextAction(a2), a1);
            }
            pre = A1.previousAction(a1);
            A1.previousAction(a1, a2);
            A1.nextAction(a1, A1.nextAction(a2));
            A1.previousAction(a2, pre);
            A1.nextAction(a2, a1);
        } else {
            pre = A1.previousAction(a1);
            int post = A1.nextAction(a1);
            A1.nextAction(A1.previousAction(a1), a2);
            A1.previousAction(A1.nextAction(a1), a2);
            A1.nextAction(A1.previousAction(a2), a1);
            if (!a2Last) {
                A1.previousAction(A1.nextAction(a2), a1);
            }
            A1.previousAction(a1, A1.previousAction(a2));
            A1.nextAction(a1, A1.nextAction(a2));
            A1.previousAction(a2, pre);
            A1.nextAction(a2, post);
        }
        this.updateTimeAndLoad(A1, a1, a2, time1, delta);
        return A1;
    }

    private void updateTimeAndLoad(NodePD A1, int a1, int a2, int time1, int delta) {
        A1.setTime(a1, A1.getTime(a2));
        A1.setTime(a2, time1);
        int i = A1.nextAction(a2);
        while (i != a1) {
            A1.setLoad(i, A1.getLoad(i) + delta);
            i = A1.nextAction(i);
        }
    }

    private void updateTime(NodePD A, int v) {
        int ti = A.nextAction(v + this.Na);
        if (ti != -1) {
            A.setTime(ti, 0);
            int tj = A.nextAction(ti);
            while (tj != -1) {
                A.setTime(tj, A.getTime(ti) + 1);
                ti = tj;
                tj = A.nextAction(ti);
            }
        }
    }

    private NodePD selectInitialSolution(int index) {
        int i;
        NodePD initial = new NodePD(this.vehiclesList, this.tasks);
        MyVehicle biggestV = (MyVehicle)this.vehiclesList.get(0);
        for (MyVehicle v : this.vehiclesList) {
            if (biggestV.capacity() >= v.capacity()) continue;
            biggestV = v;
        }
        int[] lastAction = new int[this.Nv];
        Arrays.fill(lastAction, -1);
        int biggestI = biggestV.id();
        for (i = 0; i < this.Nt; ++i) {
            if (this.tasks[i].weight > biggestV.capacity()) {
                System.out.println("ERROR : First task is really heavy for our vehicles");
                return null;
            }
            int v = index;
            if (index >= this.vehiclesList.size()) {
                v = this.random.nextInt(this.vehiclesList.size());
            }
            if (this.tasks[i].weight > ((MyVehicle)this.vehiclesList.get(v)).capacity()) {
                v = biggestI;
            }
            if (lastAction[v] == -1) {
                initial.nextAction(v + this.Na, i);
                initial.previousAction(i, v + this.Na);
                initial.previousAction(v + this.Na, -1);
            } else {
                initial.nextAction(lastAction[v], i);
                initial.previousAction(i, lastAction[v]);
            }
            initial.nextAction(i, this.Nt + i);
            initial.nextAction(this.Nt + i, -1);
            initial.previousAction(this.Nt + i, i);
            lastAction[v] = this.Nt + i;
            initial.setLoad(i, this.tasks[i].weight);
            initial.setLoad(this.Nt + i, 0);
            initial.setVehicle(i, v);
            initial.setVehicle(this.Nt + i, v);
        }
        for (i = 0; i < this.Nv; ++i) {
            this.updateTime(initial, i);
        }
        return initial;
    }

    public List computeFinalPlan(NodePD n) {
        ArrayList<Plan> plans = new ArrayList<Plan>();
        for (int v = 0; v < this.Nv; ++v) {
            Topology.City current = ((MyVehicle)this.vehiclesList.get(v)).getCurrentCity();
            Plan plan = new Plan(current, new Action[0]);
            if (n != null) {
                int t = this.Na + v;
                while (n.nextAction(t) != -1) {
                    Task task = this.tasks[n.nextAction(t) % this.Nt];
                    if (n.nextAction(t) < this.Nt) {
                        for (Topology.City city : current.pathTo(task.pickupCity)) {
                            plan.appendMove(city);
                        }
                        plan.appendPickup(task);
                        current = task.pickupCity;
                    } else {
                        for (Topology.City city : current.pathTo(task.deliveryCity)) {
                            plan.appendMove(city);
                        }
                        plan.appendDelivery(task);
                        current = task.deliveryCity;
                    }
                    t = n.nextAction(t);
                }
            }
            plans.add(plan);
        }
        return plans;
    }

    private void add(PriorityQueue P, NodePD A) {
        if (P.size() <= this.n) {
            P.add(A);
        } else if (A.getOValue() < ((NodePD)P.peek()).getOValue()) {
            P.poll();
            P.add(A);
        }
    }

    private int random(NodePD Aold) {
        int v;
        ArrayList<Integer> vehicles = new ArrayList<Integer>();
        for (v = 0; v < this.Nv; ++v) {
            if (Aold.nextAction(v + this.Na) == -1) continue;
            vehicles.add(v);
        }
        v = this.random.nextInt(vehicles.size());
        return (Integer)vehicles.get(v);
    }

    public void print(String s) {
    }
}

