/*
 * Decompiled with CFR 0.152.
 */
package PastaLoverAgent;

import PastaLoverAgent.Astar;
import PastaLoverAgent.MyTask;
import PastaLoverAgent.MyVehicle;
import PastaLoverAgent.NodePD;
import PastaLoverAgent.SLS;
import PastaLoverAgent.Strategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import logist.LogistSettings;
import logist.agent.Agent;
import logist.behavior.AuctionBehavior;
import logist.config.Parsers;
import logist.plan.Action;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;

public class PastaLoverAgent
implements AuctionBehavior {
    private Topology topology;
    private TaskDistribution distribution;
    private Agent agent;
    private Random random;
    private MyVehicle biggestVehicle;
    private MyVehicle smallestVehicle;
    private long timeout_setup;
    private long timeout_plan;
    private long time_start;
    private long timeout_bid;
    private List vehiclesList;
    private SLS sls;
    private Astar astar;
    private int meanCapa;
    private int nA = 2;
    private int Nv;
    private int id;
    private int proposed = -1;
    private int Nst = 36;
    private int Nconf = 3;
    private int expectedNumberOfTasks = 15;
    private int numberOfTasksToAdd = 0;
    private int carriedSize1 = 0;
    private int carriedSize2 = 0;
    private double MCPT;
    private double bidMin;
    private double bidMax;
    private double bidInterval;
    private double power = 1.5;
    private ArrayList M1 = new ArrayList();
    private ArrayList M2 = new ArrayList();
    private ArrayList MC1Table = new ArrayList();
    private ArrayList MC2Table = new ArrayList();
    private double MMC = 0.0;
    private double ratioLowerBoundSlope = 0.04;
    private double ratioUpperBoundSlope = 0.05;
    private ArrayList ratioLowerBound = new ArrayList();
    private ArrayList ratioUpperBound = new ArrayList();
    private double ratioMeanCost = 1.2;
    private double a = 0.5;
    private double b = 0.5;
    private double bidFactor = 0.9;
    private double minBidFactor = 0.5;
    private double maxBidFactor = 2.0;
    private ArrayList totalReward1 = new ArrayList();
    private ArrayList totalReward2 = new ArrayList();
    private ArrayList bidFactorTable = new ArrayList();
    private ArrayList mc1 = new ArrayList();
    private ArrayList[] mc2 = new ArrayList[this.Nconf];
    private ArrayList last1 = new ArrayList();
    private ArrayList[] last2 = new ArrayList[this.Nconf];
    private ArrayList best1 = new ArrayList();
    private ArrayList[] best2 = new ArrayList[this.Nconf];
    private ArrayList tasks1 = new ArrayList();
    private ArrayList tasks2 = new ArrayList();
    private ArrayList proposedTasks = new ArrayList();
    private ArrayList listWinner = new ArrayList();
    private ArrayList bid1 = new ArrayList();
    private ArrayList bid2 = new ArrayList();
    private ArrayList[] ratio = new ArrayList[this.Nconf];
    private ArrayList[][] allBid1 = new ArrayList[this.Nconf][this.Nst];
    private Strategy[][] strategies = new Strategy[this.Nconf][this.Nst];
    ArrayList allPossibleTasks = new ArrayList();
    List[] configs = new List[this.Nconf];
    private double[][] weights = new double[this.Nconf][this.Nst];
    private double[] weightConf = new double[this.Nconf];
    private ArrayList[] tableWeightConf = new ArrayList[this.Nconf];
    private double bestBid1;
    private double bestMc2;
    private ArrayList tableBestBid = new ArrayList();
    private ArrayList tableBestMc2 = new ArrayList();

    public void setup(Topology topology, TaskDistribution distribution, Agent agent) {
        this.topology = topology;
        this.distribution = distribution;
        this.agent = agent;
        this.id = agent.id();
        this.vehiclesList = MyVehicle.transform(agent.vehicles());
        this.Nv = this.vehiclesList.size();
        this.biggestVehicle = (MyVehicle)this.vehiclesList.get(0);
        this.smallestVehicle = (MyVehicle)this.vehiclesList.get(0);
        for (MyVehicle v : this.vehiclesList) {
            if (v.capacity() > this.biggestVehicle.capacity()) {
                this.biggestVehicle = v;
            }
            if (v.capacity() < this.smallestVehicle.capacity()) {
                this.smallestVehicle = v;
            }
            this.meanCapa += v.capacity() / this.Nv;
        }
        long seed = -9019554669489983951L * (long)this.biggestVehicle.hashCode() * (long)agent.id();
        this.random = new Random(seed);
        this.sls = new SLS(topology, distribution, agent);
        this.astar = new Astar(topology, distribution, agent);
        LogistSettings ls = null;
        try {
            ls = Parsers.parseSettings((String)"config/settings_auction.xml");
        }
        catch (Exception exc) {
            this.print("There was a problem loading the configuration file.");
        }
        this.timeout_setup = ls.get(LogistSettings.TimeoutKey.SETUP);
        this.timeout_plan = ls.get(LogistSettings.TimeoutKey.PLAN);
        this.timeout_bid = ls.get(LogistSettings.TimeoutKey.BID);
        this.print("TIMEOUT_BID =" + this.timeout_bid);
        this.setupStructures();
        this.createMostProbableTasks();
        this.print("");
        this.MCPT = this.computeMCPT(this.vehiclesList, null, this.expectedNumberOfTasks, this.timeout_setup);
        this.totalReward1.add(0.0);
        this.totalReward2.add(0.0);
        this.ratioLowerBound.add(1.0);
        this.ratioUpperBound.add(0.0);
        this.updateIntervalBiding();
        this.bidFactorTable.add(this.bidFactor);
    }

    public void setupStructures() {
        this.best1.add(0.0);
        ArrayList cities = this.generateCities();
        for (int i = 0; i < this.Nconf; ++i) {
            this.weightConf[i] = (double)this.Nconf / 2.0;
            this.ratio[i] = new ArrayList();
            this.tableWeightConf[i] = new ArrayList();
            this.mc2[i] = new ArrayList();
            this.last2[i] = new ArrayList();
            this.best2[i] = new ArrayList();
            this.best2[i].add(0.0);
            ArrayList capacities = this.generateCapacities(i, this.Nconf);
            this.configs[i] = this.generateRandomVehicles(cities, capacities, i);
            for (int j = 0; j < this.Nst; ++j) {
                this.allBid1[i][j] = new ArrayList();
            }
        }
        this.updateTableWeightConf();
    }

    public void setSameConfigAsOurAgent() {
        ArrayList<MyVehicle> vl = new ArrayList<MyVehicle>();
        this.print("SAME CONFIG: ");
        this.agent.vehicles();
        for (int i = 0; i < this.Nv; ++i) {
            Vehicle v = (Vehicle)this.agent.vehicles().get(i);
            MyVehicle randV = new MyVehicle(v.capacity(), v.costPerKm(), v.homeCity(), i);
            vl.add(randV);
            this.print(randV.toString());
        }
        this.print("SAME CONFIG END");
        this.configs[0] = vl;
    }

    public List plan(List vcls, TaskSet tasksSet) {
        int b;
        this.print("");
        this.print("====================== AUCTION AGENT 5 FINAL PLAN ======================================================================");
        this.vehiclesList = MyVehicle.transform(this.agent.vehicles());
        Task[] tasks = (Task[])tasksSet.toArray((Object[])new Task[tasksSet.size()]);
        if (vcls.size() == 0) {
            ArrayList plans = new ArrayList();
            return plans;
        }
        if (tasksSet.size() == 0) {
            this.print("TASKS SIZE == 0");
            ArrayList<Plan> plans = new ArrayList<Plan>();
            for (int v = 0; v < this.Nv; ++v) {
                Topology.City current = ((MyVehicle)this.vehiclesList.get(v)).getCurrentCity();
                Plan plan = new Plan(current, new Action[0]);
                plans.add(plan);
            }
            return plans;
        }
        NodePD bestSolution = this.sls.RunSLS(this.vehiclesList, tasks, this.timeout_plan, null);
        List plans = this.sls.computeFinalPlan(bestSolution);
        int totalCost = 0;
        int totalDist = 0;
        int v = 0;
        for (Plan plan : plans) {
            totalDist = (int)((double)totalDist + plan.totalDistance());
            totalCost = (int)((double)totalCost + plan.totalDistance() * (double)((MyVehicle)this.vehiclesList.get(v)).costPerKm());
            ++v;
        }
        this.print("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        this.print("AUCTION AGENT 5 : number of tasks = " + tasksSet.size());
        this.print("FINAL DISTANCE = " + totalDist);
        this.print("FINAL COST = " + bestSolution.getOValue());
        this.print("FINAL REWARD = " + tasksSet.rewardSum());
        this.print("FINAL PROFIT = " + (tasksSet.rewardSum() - totalCost));
        this.print("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        this.printInfoAgent();
        this.print("");
        this.print("FINAL BIDS AUCTION AGENT 5: ");
        for (b = 0; b < this.bid1.size(); ++b) {
            this.print(" T" + b + ":" + this.bid1.get(b));
        }
        this.print("");
        for (b = 0; b < this.bid2.size(); ++b) {
            this.print(" T" + b + ":" + this.bid2.get(b));
        }
        this.print("");
        this.print("");
        return plans;
    }

    public Long askPrice(Task task) {
        ++this.proposed;
        if (task.weight > this.biggestVehicle.capacity()) {
            return null;
        }
        this.print("----- AUCTION AGENT 5 ASK PRICE: T" + this.proposed + "=" + task + " id = " + this.agent.id() + " -----");
        long actualTime = System.currentTimeMillis();
        double b = 0.0;
        this.computeMarginalCost(task);
        this.updateBestMc2();
        b = this.computeBiding();
        long duration = System.currentTimeMillis() - actualTime;
        this.print("----- AUCTION AGENT 5 : BIDDING TASK " + task.id + ", Bid = " + Math.round(b) + ", in " + duration + " sec");
        this.print("");
        return (long)b;
    }

    private double computeBiding() {
        double MC1 = (Double)this.mc1.get(this.proposed);
        double MC2 = (Double)this.tableBestMc2.get(this.proposed);
        this.MC2Table.add(MC2);
        this.M1.add(this.projectOnBidInterval(MC1));
        this.M2.add(this.projectOnBidInterval(MC2));
        double bid = (this.a * (Double)this.M1.get(this.proposed) + this.b * (Double)this.M2.get(this.proposed)) / (this.a + this.b);
        this.print("MC1=" + MC1 + ", MC2=" + MC2 + ", M1=" + this.M1.get(this.proposed) + ", M2=" + this.M2.get(this.proposed) + ", bid=" + bid + ", bidFactor=" + this.bidFactor);
        this.print("ratioLowerBound=" + this.ratioLowerBound.get(this.proposed) + ", ratioUpperBound=" + this.ratioUpperBound.get(this.proposed));
        return Math.max(this.bidFactor * bid, this.bidMin);
    }

    private double projectOnBidInterval(double MC) {
        double projection = this.bidMin + Math.pow(MC / this.MMC, this.power) * this.bidInterval;
        return projection;
    }

    private void updateParameters(Task previous, int winner, Long[] bids) {
        double b1 = bids[this.agent.id()].doubleValue();
        double b2 = bids[1 - this.agent.id()].doubleValue();
        double factor = this.bidFactor;
        if (this.proposed < 10) {
            this.ratioLowerBound.add(1.0 - (double)(this.proposed + 1) * this.ratioLowerBoundSlope);
            this.ratioUpperBound.add((double)(this.proposed + 1) * this.ratioUpperBoundSlope);
        } else {
            this.ratioLowerBound.add((Double)this.ratioLowerBound.get(this.ratioLowerBound.size() - 1));
            this.ratioUpperBound.add((Double)this.ratioUpperBound.get(this.ratioUpperBound.size() - 1));
        }
        if (winner == this.agent.id()) {
            factor = b1 / b2 < 0.8 ? this.bidFactor + (0.8 - b1 / b2) * this.bidFactor : b1 / b2 * this.bidFactor;
        } else if (b2 / b1 > 0.7) {
            factor = b2 / b1 * this.bidFactor - 0.01;
        } else if (this.bidFactor > 1.0) {
            factor = b2 / b1 * this.bidFactor - 0.01;
        }
        this.bidFactor = factor;
        if (factor < this.minBidFactor) {
            this.bidFactor = this.minBidFactor;
        }
        if (factor > this.maxBidFactor) {
            this.bidFactor = this.maxBidFactor;
        }
        this.bidFactorTable.add(this.bidFactor);
    }

    private void updateIntervalBiding() {
        this.bidMin = (Double)this.ratioLowerBound.get(this.ratioLowerBound.size() - 1) * this.MCPT;
        this.bidMax = this.MCPT + (Double)this.ratioUpperBound.get(this.ratioLowerBound.size() - 1) * (this.MMC - this.MCPT);
        this.bidInterval = this.bidMax - this.bidMin;
        this.print("##### MCPT=" + this.MCPT + ", bidMin=" + this.bidMin + ", bidMax=" + this.bidMax + ", bidInterval=" + this.bidInterval + ", MMC=" + this.MMC);
    }

    public void auctionResult(Task previous, int winner, Long[] bids) {
        this.print("----- AuctionResult: T" + this.proposed + ", agent is " + this.agent.id() + " -----");
        this.updateStuctures(previous, winner, bids);
        this.updateWeightConf();
        this.updateParameters(previous, winner, bids);
        this.updateIntervalBiding();
        this.print("");
    }

    private void computeMarginalCost(Task task) {
        long timeout_agent = this.timeout_bid / (long)this.nA / 2L;
        long timeout_opponent = this.timeout_bid / (long)this.nA / (long)this.Nconf;
        ArrayList supp = this.createSuppTasks(this.numberOfTasksToAdd);
        ArrayList tasks1Clone = (ArrayList)this.tasks1.clone();
        int totalTasks = this.proposed + 1;
        int NtoAdd = (this.numberOfTasksToAdd - totalTasks) / 2;
        if (totalTasks <= this.numberOfTasksToAdd) {
            this.addSuppTasks(tasks1Clone, supp, NtoAdd);
            NodePD bestSolution1 = this.sls.RunSLS(this.vehiclesList, tasks1Clone.toArray(new Task[tasks1Clone.size()]), timeout_agent /= 2L, null);
            double bestValue = 0.0;
            if (bestSolution1 != null) {
                bestValue = bestSolution1.getOValue();
            }
            this.best1.set(this.proposed, bestValue);
        }
        tasks1Clone.add(task);
        NodePD lastSolution1 = this.sls.RunSLS(this.vehiclesList, tasks1Clone.toArray(new Task[tasks1Clone.size()]), timeout_agent, null);
        double lastValue1 = 0.0;
        if (lastSolution1 != null) {
            lastValue1 = lastSolution1.getOValue();
        }
        this.last1.add(lastValue1);
        double margCost1 = Math.max((Double)this.last1.get(this.proposed) - (Double)this.best1.get(this.proposed), 0.0);
        this.mc1.add(margCost1);
        this.MCPT = this.computeMCPT(this.vehiclesList, tasks1Clone, this.expectedNumberOfTasks - tasks1Clone.size(), timeout_agent);
        this.updateIntervalBiding();
        for (int j = 0; j < this.Nconf; ++j) {
            List vl = this.configs[j];
            ArrayList tasks2Clone = (ArrayList)this.tasks2.clone();
            if (totalTasks <= this.numberOfTasksToAdd) {
                this.addSuppTasks(tasks2Clone, supp, NtoAdd);
                NodePD bestSolution2 = this.sls.RunSLS(vl, tasks2Clone.toArray(new Task[tasks2Clone.size()]), timeout_opponent / 2L, null);
                tasks2Clone.add(task);
                NodePD lastSolution2 = this.sls.RunSLS(vl, tasks2Clone.toArray(new Task[tasks2Clone.size()]), timeout_opponent / 2L, null);
                double bestValue = 0.0;
                if (bestSolution2 != null) {
                    bestValue = bestSolution2.getOValue();
                }
                this.best2[j].set(this.proposed, bestValue);
                double lastValue2 = 0.0;
                if (lastSolution2 != null) {
                    lastValue2 = lastSolution2.getOValue();
                }
                this.last2[j].add(lastValue2);
                double margCost2 = Math.max((Double)this.last2[j].get(this.proposed) - (Double)this.best2[j].get(this.proposed), 0.0);
                this.mc2[j].add(margCost2);
                continue;
            }
            tasks2Clone.add(task);
            NodePD lastSolution2 = this.sls.RunSLS(vl, tasks2Clone.toArray(new Task[tasks2Clone.size()]), timeout_opponent, null);
            double lastValue2 = 0.0;
            if (lastSolution2 != null) {
                lastValue2 = lastSolution2.getOValue();
            }
            this.last2[j].add(lastValue2);
            double margCost2 = Math.max((Double)this.last2[j].get(this.proposed) - (Double)this.best2[j].get(this.proposed), 0.0);
            this.mc2[j].add(margCost2);
        }
    }

    private ArrayList generateCities() {
        int i;
        ArrayList<Topology.City> cities = new ArrayList<Topology.City>();
        ArrayList<Integer> list = new ArrayList<Integer>();
        List cl = this.topology.cities();
        for (i = 0; i < cl.size(); ++i) {
            list.add(i);
        }
        Collections.shuffle(list);
        for (i = 0; i < cl.size(); ++i) {
            Topology.City c = (Topology.City)cl.get((Integer)list.get(i));
            cities.add(c);
        }
        return cities;
    }

    private ArrayList generateCapacities(int j, int num) {
        ArrayList<Integer> capacities = new ArrayList<Integer>();
        double maxDiff = 0.6;
        double delta = num > 1 ? maxDiff * (double)j / (double)(num - 1) : 0.0;
        for (int i = 0; i < this.Nv; ++i) {
            double capa = (double)this.meanCapa + (double)this.meanCapa * (delta * (double)(2 * i / (this.Nv - 1) - 1));
            capacities.add((int)capa);
        }
        return capacities;
    }

    private List generateRandomVehicles(ArrayList cities, ArrayList capacities, int n) {
        ArrayList<MyVehicle> vl = new ArrayList<MyVehicle>();
        this.print("CONFIG " + n);
        for (int i = 0; i < this.Nv; ++i) {
            MyVehicle randV = new MyVehicle((Integer)capacities.get(i), this.biggestVehicle.costPerKm(), (Topology.City)cities.get(this.Nv * n + i), i);
            vl.add(randV);
            this.print(randV.toString());
        }
        return vl;
    }

    private void createMostProbableTasks() {
        int i = 0;
        for (Topology.City c1 : this.topology.cities()) {
            for (Topology.City c2 : this.topology.cities()) {
                if (c1.equals((Object)c2)) continue;
                double distance = c1.distanceTo(c2);
                if (2.0 * distance > this.MMC) {
                    this.print("Maximal Marginal Cost = " + c1 + " to " + c2 + " with distance = " + distance);
                    this.MMC = 2.0 * distance * (double)this.smallestVehicle.costPerKm();
                }
                double proba = this.distribution.probability(c1, c2);
                MyTask t = new MyTask(i, c1, c2, this.distribution.reward(c1, c2), this.distribution.weight(c1, c2), proba);
                this.allPossibleTasks.add(t);
                ++i;
            }
        }
        Collections.sort(this.allPossibleTasks);
    }

    private ArrayList createSuppTasks(int n) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        int i = 0;
        if (n < 1) {
            return tasks;
        }
        int count = 0;
        while (count != n) {
            MyTask t = (MyTask)this.allPossibleTasks.get(i);
            if (t.notIn(this.proposedTasks)) {
                Task tk = t.generateTask(this.proposed + 1 + count);
                tasks.add(tk);
                ++count;
            }
            ++i;
        }
        return tasks;
    }

    private void addSuppTasks(ArrayList tasks, ArrayList supp, int n) {
        for (int i = 0; i < n; ++i) {
            tasks.add((Task)supp.get(i));
        }
    }

    public double computeMCPT(List vehicles, ArrayList tasks, int expectedRemainingTasks, long timeout) {
        double costPerTasks = 0.0;
        ArrayList randTasks = this.createSuppTasks(expectedRemainingTasks);
        if (tasks == null) {
            NodePD estimate = this.sls.RunSLS(vehicles, randTasks.toArray(new Task[randTasks.size()]), timeout, null);
            costPerTasks = estimate.getOValue() / (double)randTasks.size();
        } else {
            tasks.addAll(randTasks);
            NodePD estimate = this.sls.RunSLS(vehicles, tasks.toArray(new Task[randTasks.size()]), timeout, null);
            costPerTasks = estimate.getOValue() / (double)tasks.size();
        }
        return this.ratioMeanCost * costPerTasks;
    }

    private void updateBestMc2() {
        this.bestMc2 = 0.0;
        double sumWeights = 0.0;
        for (int conf = 0; conf < this.Nconf; ++conf) {
            this.bestMc2 += this.weightConf[conf] * (Double)this.mc2[conf].get(this.proposed);
            sumWeights += this.weightConf[conf];
        }
        this.bestMc2 /= sumWeights;
        this.tableBestMc2.add(this.bestMc2);
    }

    private void updateBestBid1() {
        double m1 = (Double)this.mc1.get(this.proposed);
        double m2 = this.bestMc2;
        double factor1 = 0.5;
        double factor2 = 0.3;
        this.bestBid1 = m1 <= m2 ? m1 + factor1 * (m2 - m1) : m1 + factor2 * (m2 - m1);
        this.tableBestBid.add(this.bestBid1);
    }

    private void updateStuctures(Task previous, int winner, Long[] bids) {
        int i;
        this.proposedTasks.add(previous);
        int ennemy = 0;
        for (i = 0; i < bids.length; ++i) {
            if (i == this.agent.id()) {
                this.bid1.add(Double.valueOf(bids[this.agent.id()].longValue()));
                continue;
            }
            ennemy = i;
            this.bid2.add(Double.valueOf(bids[i].longValue()));
        }
        if (winner == this.agent.id()) {
            this.totalReward1.add((Double)this.totalReward1.get(this.proposed) + (double)bids[winner].longValue());
            this.totalReward2.add((Double)this.totalReward2.get(this.proposed));
            ++this.carriedSize1;
            this.best1.add((Double)this.last1.get(this.proposed));
            for (i = 0; i < this.Nconf; ++i) {
                this.best2[i].add((Double)this.best2[i].get(this.proposed));
            }
            this.tasks1.add(previous);
            this.listWinner.add(this.agent.id());
        } else {
            this.totalReward1.add((Double)this.totalReward1.get(this.proposed));
            this.totalReward2.add((Double)this.totalReward2.get(this.proposed) + (double)bids[winner].longValue());
            ++this.carriedSize2;
            this.best1.add((Double)this.best1.get(this.proposed));
            for (i = 0; i < this.Nconf; ++i) {
                this.best2[i].add((Double)this.last2[i].get(this.proposed));
            }
            this.tasks2.add(previous);
            this.listWinner.add(ennemy);
        }
        for (int conf = 0; conf < this.Nconf; ++conf) {
            double div = (Double)this.mc2[conf].get(this.proposed);
            if (div < 1.0) {
                div = 1.0;
                this.ratio[conf].add((Double)this.bid2.get(this.proposed) / div);
                continue;
            }
            this.ratio[conf].add((Double)this.bid2.get(this.proposed) / div);
        }
    }

    private void updateWeightConf() {
        if (this.proposed != 0) {
            int conf;
            int conf2;
            int bestConf = 0;
            double bestVar = Double.MAX_VALUE;
            double[] mean = new double[this.Nconf];
            for (conf2 = 0; conf2 < this.Nconf; ++conf2) {
                mean[conf2] = 0.0;
            }
            for (conf2 = 0; conf2 < this.Nconf; ++conf2) {
                for (int prop = 0; prop < this.ratio[conf2].size(); ++prop) {
                    int n = conf2;
                    mean[n] = mean[n] + (Double)this.ratio[conf2].get(prop);
                }
            }
            for (conf2 = 0; conf2 < this.Nconf; ++conf2) {
                mean[conf2] = mean[conf2] / (double)this.ratio[conf2].size();
            }
            double[] var = new double[this.Nconf];
            for (conf = 0; conf < this.Nconf; ++conf) {
                var[conf] = 0.0;
            }
            for (conf = 0; conf < this.Nconf; ++conf) {
                for (int prop = 0; prop < this.ratio[conf].size(); ++prop) {
                    double square = Math.pow((Double)this.ratio[conf].get(prop) - mean[conf], 2.0);
                    int n = conf;
                    var[n] = var[n] + square;
                }
            }
            for (conf = 0; conf < this.Nconf; ++conf) {
                var[conf] = var[conf] / ((double)this.ratio[conf].size() - 1.0);
                if (!(var[conf] <= bestVar)) continue;
                bestVar = var[conf];
                bestConf = conf;
            }
            for (conf = 0; conf < this.Nconf; ++conf) {
                if (conf == bestConf) {
                    int n = conf;
                    this.weightConf[n] = this.weightConf[n] + ((double)this.Nconf / 2.0 + 1.0);
                } else {
                    int n = conf;
                    this.weightConf[n] = this.weightConf[n] - (double)this.Nconf / 2.0 / ((double)this.Nconf - 1.0);
                }
                if (!(this.weightConf[conf] <= 0.0)) continue;
                this.weightConf[conf] = 0.0;
            }
            this.updateTableWeightConf();
        }
    }

    public void updateTableWeightConf() {
        for (int conf = 0; conf < this.Nconf; ++conf) {
            this.tableWeightConf[conf].add(this.weightConf[conf]);
        }
    }

    public void print(String s) {
    }

    public void print(double s) {
    }

    public void print(int s) {
    }

    public void print(long d) {
    }

    public void printMc2() {
        this.print("");
        this.print("TABLE MC2:");
        for (int conf = 0; conf < this.Nconf; ++conf) {
            Integer x = conf;
            this.print("configuration " + x.toString());
            this.print(this.mc2[conf].toString());
        }
    }

    public void printMc1() {
        this.print("");
    }

    public void printRatio() {
        this.print("");
        this.print("TABLE RATIO");
        for (int conf = 0; conf < this.Nconf; ++conf) {
            Integer x = conf;
            this.print("configuration " + x.toString());
            this.print(this.ratio[conf].toString());
        }
    }

    public void printWeightConf() {
        this.print("");
    }

    public void printTableBestBid() {
        this.print("");
        this.print("TABLE TableBestBid:");
        this.print(this.tableBestBid.toString());
    }

    public void printbid1() {
        this.print("");
        this.print("TABLE BID1:");
        this.print(this.bid1.toString());
    }

    public void printbid2() {
        this.print("");
        this.print("TABLE BID2:");
        this.print(this.bid2.toString());
    }

    public void printTableBestMc2() {
        this.print("");
        this.print("TABLE TableBestBid:");
        this.print(this.tableBestMc2.toString());
    }

    public void printTableWeightConf() {
        this.print("");
        this.print("TABLE WeightConf:");
        for (int conf = 0; conf < this.Nconf; ++conf) {
            Integer x = conf;
            this.print("configuration " + x.toString());
            this.print(this.tableWeightConf[conf].toString());
        }
    }

    public void printInfoAgent() {
        int a;
        int i;
        int a2;
        this.print("------------------------------------------------------------------------------");
        this.print("AUCTION AGENT 5 " + this.agent.id() + " INFORMATIONS :");
        this.print("Tasks");
        for (a2 = 0; a2 < this.listWinner.size(); ++a2) {
            this.print(", T" + a2 + ":" + (Integer)this.listWinner.get(a2));
        }
        this.print("");
        this.print("last1");
        for (a2 = 0; a2 < this.last1.size(); ++a2) {
            this.print(", T" + a2 + ":" + ((Double)this.last1.get(a2)).intValue());
        }
        this.print("");
        this.print("best1");
        for (a2 = 0; a2 < this.best1.size(); ++a2) {
            this.print(", T" + a2 + ":" + ((Double)this.best1.get(a2)).intValue());
        }
        this.print("");
        this.print("mc1");
        for (a2 = 0; a2 < this.mc1.size(); ++a2) {
            this.print(", T" + a2 + ":" + ((Double)this.mc1.get(a2)).intValue());
        }
        this.print("");
        this.print("bid1");
        for (a2 = 0; a2 < this.bid1.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.bid1.get(a2));
        }
        this.print("");
        this.print("totalReward1");
        for (a2 = 0; a2 < this.totalReward1.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.totalReward1.get(a2));
        }
        this.print("");
        this.print("##################################################################################");
        this.print("mc1");
        for (a2 = 0; a2 < this.mc1.size(); ++a2) {
            this.print(", T" + a2 + ":" + ((Double)this.mc1.get(a2)).intValue());
        }
        this.print("");
        this.print("mc2");
        for (a2 = 0; a2 < this.tableBestMc2.size(); ++a2) {
            this.print(", T" + a2 + ":" + ((Double)this.tableBestMc2.get(a2)).intValue());
        }
        this.print("");
        this.print("m1");
        for (a2 = 0; a2 < this.mc1.size(); ++a2) {
            this.print(", T" + a2 + ":" + ((Double)this.M1.get(a2)).intValue());
        }
        this.print("");
        this.print("m2");
        for (a2 = 0; a2 < this.tableBestMc2.size(); ++a2) {
            this.print(", T" + a2 + ":" + ((Double)this.M2.get(a2)).intValue());
        }
        this.print("");
        this.print("bid1");
        for (a2 = 0; a2 < this.bid1.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.bid1.get(a2));
        }
        this.print("");
        this.print("bid2:");
        for (a2 = 0; a2 < this.bid1.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.bid2.get(a2));
        }
        this.print("");
        this.print("ratioLowerBound:");
        for (a2 = 0; a2 < this.ratioLowerBound.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.ratioLowerBound.get(a2));
        }
        this.print("");
        this.print("ratioUpperBound:");
        for (a2 = 0; a2 < this.ratioUpperBound.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.ratioUpperBound.get(a2));
        }
        this.print("");
        this.print("MC1:");
        for (a2 = 0; a2 < this.mc1.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.mc1.get(a2));
        }
        this.print("");
        this.print("MC2:");
        for (a2 = 0; a2 < this.MC2Table.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.MC2Table.get(a2));
        }
        this.print("");
        this.print("M1:");
        for (a2 = 0; a2 < this.M1.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.M1.get(a2));
        }
        this.print("");
        this.print("M2:");
        for (a2 = 0; a2 < this.M2.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.M2.get(a2));
        }
        this.print("");
        this.print("bidFactorTable:");
        for (a2 = 0; a2 < this.bidFactorTable.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.bidFactorTable.get(a2));
        }
        this.print("");
        this.print("##################################################################################");
        this.print("------------------------------------------------------------------------------");
        this.print("------------------------------------------------------------------------------");
        this.print("OTHER AGENT " + (this.agent.id() * -1 + 1) + " INFORMATIONS :");
        for (a2 = 0; a2 < this.listWinner.size(); ++a2) {
            this.print("");
        }
        for (i = 0; i < this.Nconf; ++i) {
            this.print(String.valueOf(i) + ": ");
            for (a = 0; a < this.last1.size(); ++a) {
                this.print(", T" + a + ":" + ((Double)this.last2[i].get(a)).intValue());
            }
            this.print("");
        }
        this.print("");
        this.print("best2:");
        for (i = 0; i < this.Nconf; ++i) {
            this.print(String.valueOf(i) + ": ");
            for (a = 0; a < this.best1.size(); ++a) {
                this.print(", T" + a + ":" + ((Double)this.best2[i].get(a)).intValue());
            }
            this.print("");
        }
        this.print("");
        this.print("mc2:");
        for (i = 0; i < this.Nconf; ++i) {
            this.print(String.valueOf(i) + ": ");
            for (a = 0; a < this.mc1.size(); ++a) {
                this.print(", T" + a + ":" + ((Double)this.mc2[i].get(a)).intValue());
            }
            this.print("");
        }
        this.print("");
        this.print("bid2:");
        for (a2 = 0; a2 < this.bid1.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.bid2.get(a2));
        }
        this.print("totalReward2");
        for (a2 = 0; a2 < this.totalReward2.size(); ++a2) {
            this.print(", T" + a2 + ":" + this.totalReward2.get(a2));
        }
        this.print("");
        this.print("");
        this.print("------------------------------------------------------------------------------");
    }
}

