/*
 * Decompiled with CFR 0.152.
 */
package PastaLoverAgent;

import PastaLoverAgent.MyVehicle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import logist.task.Task;
import logist.topology.Topology;

public class NodePD
implements Comparator,
Comparable {
    private int[] nextAction;
    private int[] previousAction;
    private int[] times;
    private int[] vehicles;
    private int[] load;
    private double OValue;
    private List vehiclesList;
    private Task[] tasks;
    private int Nt;
    private int Nv;
    private int Na;

    public NodePD(List vehiclesList, Task[] tasks) {
        this.tasks = tasks;
        this.vehiclesList = vehiclesList;
        this.Nt = tasks.length;
        this.Nv = vehiclesList.size();
        this.Na = 2 * this.Nt;
        this.nextAction = new int[this.Nv + this.Na];
        this.previousAction = new int[this.Nv + this.Na];
        this.times = new int[this.Na];
        this.vehicles = new int[this.Na];
        this.load = new int[this.Na];
        Arrays.fill(this.nextAction, -1);
        Arrays.fill(this.previousAction, -1);
    }

    public NodePD(int[] nextTask, int[] previousTask, int[] times, int[] vehicles, int[] load, int Nt, int Nv, List vehiclesList, Task[] tasks) {
        this.tasks = tasks;
        this.vehiclesList = vehiclesList;
        this.nextAction = nextTask;
        this.previousAction = previousTask;
        this.times = times;
        this.vehicles = vehicles;
        this.load = load;
        this.Nt = Nt;
        this.Nv = Nv;
        this.Na = 2 * Nt;
        this.OValue = -1.0;
    }

    private NodePD(int[] nextTask, int[] previousTask, int[] times, int[] vehicles, int[] load, int Nt, int Nv, List vehiclesList, Task[] tasks, double v) {
        this.tasks = tasks;
        this.vehiclesList = vehiclesList;
        this.nextAction = nextTask;
        this.previousAction = previousTask;
        this.times = times;
        this.vehicles = vehicles;
        this.load = load;
        this.Nt = Nt;
        this.Nv = Nv;
        this.Na = 2 * Nt;
        this.OValue = v;
    }

    public boolean equals(NodePD n) {
        return this.getOValue() == n.getOValue();
    }

    public int compareTo(Object o) {
        return this.compare(this, (NodePD)o);
    }

    public int compare(NodePD n1, NodePD n2) {
        return (int)(-(n1.getOValue() - n2.getOValue()));
    }

    public NodePD clone() {
        return new NodePD((int[])this.nextAction.clone(), (int[])this.previousAction.clone(), (int[])this.times.clone(), (int[])this.vehicles.clone(), (int[])this.load.clone(), this.Nt, this.Nv, this.vehiclesList, this.tasks, this.OValue);
    }

    public double getOValue(Task[] tasks, List vehicles) {
        if (this.OValue == -1.0) {
            return this.computeOValue(tasks, vehicles);
        }
        return this.OValue;
    }

    public double getOValue() {
        if (this.OValue == -1.0) {
            return this.computeOValue(this.tasks, this.vehiclesList);
        }
        return this.OValue;
    }

    private double computeOValue(Task[] tasks, List vehicles) {
        double C = 0.0;
        for (int t = 0; t < this.Na; ++t) {
            if (this.nextAction(t) == -1) continue;
            Task t1 = tasks[t % this.Nt];
            Task t2 = tasks[this.nextAction(t) % this.Nt];
            MyVehicle vehicle = (MyVehicle)vehicles.get(this.getVehicle(t));
            Topology.City c1 = t1.pickupCity;
            if (t >= this.Nt) {
                c1 = t1.deliveryCity;
            }
            Topology.City c2 = t2.pickupCity;
            if (this.nextAction(t) >= this.Nt) {
                c2 = t2.deliveryCity;
            }
            C += c1.distanceTo(c2) * (double)vehicle.costPerKm();
        }
        for (int v = 0; v < this.Nv; ++v) {
            if (this.nextAction(v + this.Na) == -1) continue;
            Task firstTask = tasks[this.nextAction(v + this.Na)];
            MyVehicle vehicle = (MyVehicle)vehicles.get(v);
            Topology.City vCity = vehicle.getCurrentCity();
            Topology.City pickUp = firstTask.pickupCity;
            C += vCity.distanceTo(pickUp) * (double)vehicle.costPerKm();
        }
        this.OValue = C;
        return C;
    }

    public void nextAction(int index, int value) {
        this.nextAction[index] = value;
        this.OValue = -1.0;
    }

    public int nextAction(int index) {
        return this.nextAction[index];
    }

    public void previousAction(int index, int value) {
        this.previousAction[index] = value;
        this.OValue = -1.0;
    }

    public int previousAction(int index) {
        return this.previousAction[index];
    }

    public void setTime(int index, int value) {
        this.times[index] = value;
        this.OValue = -1.0;
    }

    public int getTime(int index) {
        return this.times[index];
    }

    public void setVehicle(int index, int value) {
        this.vehicles[index] = value;
        this.OValue = -1.0;
    }

    public int getVehicle(int index) {
        return this.vehicles[index];
    }

    public void setLoad(int index, int value) {
        this.load[index] = value;
        this.OValue = -1.0;
    }

    public int getLoad(int index) {
        return this.load[index];
    }

    public void print() {
    }

    public int[] getNextAction() {
        return this.nextAction;
    }

    public void setNextAction(int[] nextAction) {
        this.OValue = -1.0;
        this.nextAction = nextAction;
    }

    public int[] getTimes() {
        return this.times;
    }

    public void setTimes(int[] times) {
        this.OValue = -1.0;
        this.times = times;
    }

    public int[] getVehicles() {
        return this.vehicles;
    }

    public void setVehicles(int[] vehicles) {
        this.OValue = -1.0;
        this.vehicles = vehicles;
    }

    public int getNt() {
        return this.Nt;
    }

    public void setNt(int nt) {
        this.OValue = -1.0;
        this.Nt = nt;
    }

    public int getNv() {
        return this.Nv;
    }

    public void setNv(int nv) {
        this.OValue = -1.0;
        this.Nv = nv;
    }

    public int[] getPreviousAction() {
        return this.previousAction;
    }

    public void setPreviousAction(int[] previousAction) {
        this.previousAction = previousAction;
    }

    public int[] getLoad() {
        return this.load;
    }

    public void setLoad(int[] load) {
        this.load = load;
    }

    public int compare(Object obj, Object obj1) {
        return this.compare((NodePD)obj, (NodePD)obj1);
    }
}

