/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import logist.LogistPlatform;
import logist.LogistSettings;
import logist.agent.Agent;
import logist.behavior.AuctionBehavior;
import logist.config.Parsers;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.DefaultTaskDistribution;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;
import template.New_Plan;

public class AuctionTemplate
implements AuctionBehavior {
    private Topology topology;
    private DefaultTaskDistribution distribution;
    private Agent agent;
    private int number_of_bids;
    private int weight;
    private int taken_tasks;
    private New_Plan plan;
    private New_Plan opp_plan;
    private long timeout_setup;
    private long timeout_bid;
    private long timeout_plan;
    private Random random;
    private int opp_task_taken;
    private long opp_last_estimate;
    private long opp_bids_delta;

    public void setup(Topology topology, TaskDistribution distribution, Agent agent) {
        this.opp_task_taken = 0;
        this.opp_bids_delta = 0L;
        this.opp_last_estimate = 0L;
        this.topology = topology;
        this.distribution = (DefaultTaskDistribution)distribution;
        this.agent = agent;
        long seed = -9019554669489983951L * (long)agent.id();
        this.random = new Random(seed);
        this.number_of_bids = 0;
        this.weight = 1;
        this.taken_tasks = 0;
        this.plan = new New_Plan(agent.vehicles());
        this.opp_plan = new New_Plan(agent.vehicles());
        LogistSettings ls = null;
        try {
            ls = Parsers.parseSettings((String)("config" + File.separator + "settings_auction.xml"));
        }
        catch (Exception exc) {
            System.out.println("There was a problem loading the configuration file.");
        }
        long timeout_margin = 200L;
        this.timeout_setup = LogistPlatform.getSettings().get(LogistSettings.TimeoutKey.SETUP) - timeout_margin;
        this.timeout_bid = LogistPlatform.getSettings().get(LogistSettings.TimeoutKey.BID) - timeout_margin;
        this.timeout_plan = LogistPlatform.getSettings().get(LogistSettings.TimeoutKey.PLAN) - timeout_margin;
        System.out.println("Agent " + agent.id() + ": timeout_setup: " + this.timeout_setup + ", timeout_bid: " + this.timeout_bid + ", timeout_plan: " + this.timeout_plan);
    }

    public void auctionResult(Task previous, int winner, Long[] bids) {
        if (winner == this.agent.id()) {
            this.plan.assignTask(previous);
            System.out.println("You won task: " + previous.id);
            ++this.taken_tasks;
        } else {
            this.opp_plan.assignTask(previous);
            ++this.opp_task_taken;
            this.opp_bids_delta += this.opp_last_estimate - bids[bids.length - 1];
            System.out.println("Opponent won task: " + previous.id);
        }
        this.weight += previous.weight;
        ++this.number_of_bids;
    }

    public Long askPrice(Task task) {
        double discount = 0.1;
        System.out.println("Auctioning task: " + task);
        int cost = (int)(this.plan.lowestMarginalCost(task) * (1.0 - Math.pow(Math.E, (double)(-this.number_of_bids) * 0.1)) + this.plan.averageLowestMarginalCost(this.randomTasks()) * Math.pow(Math.E, (double)(-this.number_of_bids) * 0.1));
        int opp_cost = (int)(this.opp_plan.lowestMarginalCost(task) * (1.0 - Math.pow(Math.E, (double)(-this.number_of_bids) * 0.1)) + this.opp_plan.averageLowestMarginalCost(this.randomTasks()) * Math.pow(Math.E, (double)(-this.number_of_bids) * 0.1));
        this.opp_last_estimate = opp_cost;
        if (this.opp_bids_delta != 0L && this.opp_task_taken != 0) {
            opp_cost = (int)((long)opp_cost + this.opp_bids_delta / (long)this.opp_task_taken);
        }
        return Math.max(Math.max(opp_cost, cost + 50), 10);
    }

    private List<Task> randomTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (int i = 0; i < 10; ++i) {
            int pickups = this.random.nextInt(this.topology.cities().size());
            int deliveries = this.random.nextInt(this.topology.cities().size());
            int average_weight = this.weight / (this.number_of_bids + 1);
            int id = this.taken_tasks + i + 1;
            tasks.add(new Task(id, (Topology.City)this.topology.cities().get(pickups), (Topology.City)this.topology.cities().get(deliveries), 1L, average_weight));
        }
        return tasks;
    }

    public List<Plan> plan(List<Vehicle> vehicles, TaskSet tasks) {
        return this.plan.getPlans();
    }
}

