/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import logist.Measures;
import logist.agent.Agent;
import logist.behavior.AuctionBehavior;
import logist.plan.Action;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;

public class AuctionTemplate
implements AuctionBehavior {
    private Topology topology;
    private TaskDistribution distribution;
    private Agent agent;
    private Random random;
    private Vehicle vehicle;
    private Topology.City currentCity;

    public void setup(Topology topology, TaskDistribution distribution, Agent agent) {
        this.topology = topology;
        this.distribution = distribution;
        this.agent = agent;
        this.vehicle = (Vehicle)agent.vehicles().get(0);
        this.currentCity = this.vehicle.homeCity();
        long seed = -9019554669489983951L * (long)this.currentCity.hashCode() * (long)agent.id();
        this.random = new Random(seed);
    }

    public void auctionResult(Task previous, int winner, Long[] bids) {
        if (winner == this.agent.id()) {
            this.currentCity = previous.deliveryCity;
        }
    }

    public Long askPrice(Task task) {
        if (this.vehicle.capacity() < task.weight) {
            return null;
        }
        long distanceTask = task.pickupCity.distanceUnitsTo(task.deliveryCity);
        long distanceSum = distanceTask + this.currentCity.distanceUnitsTo(task.pickupCity);
        double marginalCost = Measures.unitsToKM((long)(distanceSum * (long)this.vehicle.costPerKm()));
        double ratio = 1.0 + this.random.nextDouble() * 0.05 * (double)task.id;
        double bid = ratio * marginalCost;
        return Math.round(bid);
    }

    public List<Plan> plan(List<Vehicle> vehicles, TaskSet tasks) {
        Plan planVehicle1 = this.naivePlan(this.vehicle, tasks);
        ArrayList<Plan> plans = new ArrayList<Plan>();
        plans.add(planVehicle1);
        while (plans.size() < vehicles.size()) {
            plans.add(Plan.EMPTY);
        }
        return plans;
    }

    private Plan naivePlan(Vehicle vehicle, TaskSet tasks) {
        Topology.City current = vehicle.getCurrentCity();
        Plan plan = new Plan(current, new Action[0]);
        for (Task task : tasks) {
            for (Topology.City city : current.pathTo(task.pickupCity)) {
                plan.appendMove(city);
            }
            plan.appendPickup(task);
            for (Topology.City city : task.path()) {
                plan.appendMove(city);
            }
            plan.appendDelivery(task);
            current = task.deliveryCity;
        }
        return plan;
    }
}

