/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcFloat;
import ilog.solver.IlcSolver;
import ilog.solver.hg;
import ilog.solver.hy;
import ilog.solver.nm;

class dc
extends hy {
    final nm ie;
    final nm je;

    public dc(nm nm2, nm nm3) {
        this.ie = nm2;
        this.je = nm3;
        nm2.isUsed(this);
        nm3.isUsed(this);
    }

    public final IlcSolver getSolver() {
        return this.ie.getSolver();
    }

    protected hg[] getArgs() {
        return new hg[]{this.ie, this.je};
    }

    protected void computeRange() {
        double d2 = this.ie.getDomainLB();
        double d3 = this.ie.getDomainUB();
        double d4 = this.je.getDomainLB();
        double d5 = this.je.getDomainUB();
        if (this.ie.in() || this.je.in()) {
            this.setNaN();
        } else if (0.0 < d4) {
            this.computeRangeWhenVar2IsPositive(d2, d3, d4, d5);
        } else if (d5 < 0.0) {
            this.computeRangeWhenVar2IsPositive(-d3, -d2, -d5, -d4);
        } else {
            this.computeRangeWhenVar2ContainsZero(d2, d3, d4, d5);
        }
    }

    protected void computeRangeWhenVar2IsPositive(double d2, double d3, double d4, double d5) {
        this.bzb = d2 <= 0.0 ? IlcFloat.roundDown(d2 / d4) : IlcFloat.roundDown(d2 / d5);
        this.czb = 0.0 <= d3 ? IlcFloat.roundUp(d3 / d4) : IlcFloat.roundUp(d3 / d5);
    }

    protected void computeRangeWhenVar2ContainsZero(double d2, double d3, double d4, double d5) {
        this.bzb = Double.NEGATIVE_INFINITY;
        this.czb = Double.POSITIVE_INFINITY;
        if (d4 == 0.0 && d5 == 0.0) {
            if (0.0 < d2 || d3 < 0.0) {
                this.setNaN();
            }
        } else if (d4 == 0.0) {
            if (0.0 < d2) {
                this.bzb = IlcFloat.roundDown(d2 / d5);
            } else if (d3 < 0.0) {
                this.czb = IlcFloat.roundUp(d3 / d5);
            }
        } else if (d5 == 0.0) {
            if (0.0 < d2) {
                this.czb = IlcFloat.roundUp(d2 / d4);
            } else if (d3 < 0.0) {
                this.bzb = IlcFloat.roundDown(d3 / d4);
            }
        }
    }

    protected void setRangeInternal(double d2, double d3) {
        double d4 = this.ie.getDomainLB();
        double d5 = this.ie.getDomainUB();
        double d6 = this.je.getDomainLB();
        double d7 = this.je.getDomainUB();
        if (d6 == 0.0 && d7 == 0.0) {
            this.ie.setDomainRange(0.0, 0.0);
        } else {
            this.setRangeInternalVar1(d6, d7, d2, d3);
            this.setRangeInternalVar2(d4, d5, d6, d7, d2, d3);
        }
    }

    protected void setRangeInternalVar1(double d2, double d3, double d4, double d5) {
        if (d4 >= 0.0) {
            this.setRangeInternalVar1MinPos(d2, d3, d4, d5);
        } else if (d5 <= 0.0) {
            this.setRangeInternalVar1MinPos(-d3, -d2, -d5, -d4);
        } else {
            double d6;
            double d7;
            if (d2 >= 0.0) {
                d7 = IlcFloat.roundDown(d4 * d3);
                d6 = IlcFloat.roundUp(d5 * d3);
            } else if (d3 <= 0.0) {
                d7 = IlcFloat.roundDown(d5 * d2);
                d6 = IlcFloat.roundUp(d4 * d2);
            } else {
                d7 = Math.min(IlcFloat.roundDown(d4 * d3), IlcFloat.roundDown(d5 * d2));
                d6 = Math.max(IlcFloat.roundUp(d4 * d2), IlcFloat.roundUp(d5 * d3));
            }
            this.ie.setDomainRange(d7, d6);
        }
    }

    protected void setRangeInternalVar1MinPos(double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        if (d2 >= 0.0) {
            d7 = IlcFloat.roundDown(d4 * d2);
            d6 = IlcFloat.roundUp(d5 * d3);
        } else if (d3 <= 0.0) {
            d7 = IlcFloat.roundDown(d5 * d2);
            d6 = IlcFloat.roundUp(d4 * d3);
        } else {
            d7 = IlcFloat.roundDown(d5 * d2);
            d6 = IlcFloat.roundUp(d5 * d3);
        }
        this.ie.setDomainRange(d7, d6);
    }

    protected void setRangeInternalVar2(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d6 > 0.0) {
            this.setRangeInternalVar2MinPos(d2, d3, d6, d7);
        } else if (d7 < 0.0) {
            this.setRangeInternalVar2MinPos(-d3, -d2, -d7, -d6);
        } else {
            this.setRangeInternalVar2MinNegMaxPos(d2, d3, d4, d5, d6, d7);
        }
    }

    protected void setRangeInternalVar2MinPos(double d2, double d3, double d4, double d5) {
        double d6 = d2 <= 0.0 ? IlcFloat.roundDown(d2 / d4) : IlcFloat.roundDown(d2 / d5);
        double d7 = d3 >= 0.0 ? IlcFloat.roundUp(d3 / d4) : IlcFloat.roundUp(d3 / d5);
        this.je.setDomainRange(d6, d7);
    }

    protected void setRangeInternalVar2MinNegMaxPos(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Double.NEGATIVE_INFINITY;
        double d9 = Double.POSITIVE_INFINITY;
        if (d6 == 0.0 && d7 == 0.0) {
            if (0.0 < d2 || d3 < 0.0) {
                this.fail();
            }
        } else if (d6 == 0.0) {
            if (d2 > 0.0) {
                d8 = IlcFloat.roundDown(d2 / d7);
            } else if (d3 < 0.0) {
                d9 = IlcFloat.roundUp(d3 / d7);
            }
        } else if (d7 == 0.0) {
            if (d2 > 0.0) {
                d9 = IlcFloat.roundUp(d2 / d6);
            } else if (d3 < 0.0) {
                d8 = IlcFloat.roundDown(d3 / d6);
            }
        } else if (d2 > 0.0) {
            double d10 = IlcFloat.roundUp(d2 / d6);
            double d11 = IlcFloat.roundDown(d2 / d7);
            if (d10 < d4) {
                d8 = d11;
            }
            if (d5 < d11) {
                d9 = d10;
            }
        } else if (d3 < 0.0) {
            double d12 = IlcFloat.roundUp(d3 / d7);
            double d13 = IlcFloat.roundDown(d3 / d6);
            if (d12 < d4) {
                d8 = d13;
            }
            if (d5 < d13) {
                d9 = d12;
            }
        }
        this.je.setDomainRange(d8, d9);
    }

    public final synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.ie);
        stringBuffer.append(" / ");
        stringBuffer.append(this.je);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

