/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import uchicago.src.sim.network.DefaultDrawableEdge;
import uchicago.src.sim.network.DefaultEdge;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.util.SimUtilities;

public class EdgeFactory {
    public static Edge linkNodes(Node node, Node node2, Edge edge) {
        edge.setFrom(node);
        edge.setTo(node2);
        node.addOutEdge(edge);
        node2.addInEdge(edge);
        return edge;
    }

    public static DefaultEdge createEdge(Node node, Node node2, String string) {
        DefaultEdge defaultEdge = new DefaultEdge(node, node2, string);
        node.addOutEdge(defaultEdge);
        node2.addInEdge(defaultEdge);
        return defaultEdge;
    }

    public static DefaultEdge createEdge(Node node, Node node2, String string, float f) {
        DefaultEdge defaultEdge = new DefaultEdge(node, node2, string, f);
        node.addOutEdge(defaultEdge);
        node2.addInEdge(defaultEdge);
        return defaultEdge;
    }

    public static DefaultEdge createEdge(Node node, Node node2) {
        DefaultEdge defaultEdge = new DefaultEdge(node, node2);
        node.addOutEdge(defaultEdge);
        node2.addInEdge(defaultEdge);
        return defaultEdge;
    }

    public static DefaultDrawableEdge createDrawableEdge(Node node, Node node2, String string) {
        DefaultDrawableEdge defaultDrawableEdge = new DefaultDrawableEdge(node, node2, string);
        node.addOutEdge(defaultDrawableEdge);
        node2.addInEdge(defaultDrawableEdge);
        return defaultDrawableEdge;
    }

    public static DefaultDrawableEdge createDrawableEdge(Node node, Node node2, String string, float f) {
        DefaultDrawableEdge defaultDrawableEdge = new DefaultDrawableEdge(node, node2, string, f);
        node.addOutEdge(defaultDrawableEdge);
        node2.addInEdge(defaultDrawableEdge);
        return defaultDrawableEdge;
    }

    public static DefaultDrawableEdge createDrawableEdge(Node node, Node node2) {
        DefaultDrawableEdge defaultDrawableEdge = new DefaultDrawableEdge(node, node2);
        node.addOutEdge(defaultDrawableEdge);
        node2.addInEdge(defaultDrawableEdge);
        return defaultDrawableEdge;
    }

    public static Edge createCustomEdge(Node node, Node node2, String string, Class clazz) {
        Edge edge = EdgeFactory.createCustomEdge(node, node2, clazz);
        edge.setLabel(string);
        return edge;
    }

    public static Edge createCustomEdge(Node node, Node node2, String string, float f, Class clazz) {
        Edge edge = EdgeFactory.createCustomEdge(node, node2, clazz);
        edge.setLabel(string);
        edge.setStrength(f);
        return edge;
    }

    public static Edge createCustomEdge(Node node, Node node2, Class clazz) {
        if (Edge.class.isAssignableFrom(clazz)) {
            try {
                Edge edge = (Edge)clazz.newInstance();
                node.addOutEdge(edge);
                node2.addInEdge(edge);
                return edge;
            }
            catch (InstantiationException instantiationException) {
                SimUtilities.showError("Error creating custom edge", instantiationException);
                System.exit(0);
            }
            catch (IllegalAccessException illegalAccessException) {
                SimUtilities.showError("Error creating custom edge", illegalAccessException);
                System.exit(0);
            }
        }
        String string = "Edge class argument to createCustomEdge does not implement Edge interface";
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
        SimUtilities.showError(string, illegalArgumentException);
        System.exit(0);
        return null;
    }
}

