/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import uchicago.src.sim.gui.DrawableItem;
import uchicago.src.sim.gui.SimGraphics;

public abstract class RectItem
extends DrawableItem {
    protected boolean recalcBorder = true;

    public void calcSize(SimGraphics simGraphics) {
        super.calcSize(simGraphics);
        if (this.borderWidth != 0 && this.recalc && this.recalcBorder) {
            Rectangle2D.Float float_ = new Rectangle2D.Float((int)this.getX(), (int)this.getY(), this.width, this.height);
            Shape shape = this.stroke.createStrokedShape(float_);
            Rectangle rectangle = shape.getBounds();
            this.width = (int)rectangle.getWidth();
            this.height = (int)rectangle.getHeight();
            this.recalcBorder = false;
        }
    }

    public void draw(SimGraphics simGraphics) {
        this.calcSize(simGraphics);
        if (this.hollow) {
            if (this.label != null) {
                simGraphics.setFont(this.font);
                simGraphics.drawStringInHollowRect(this.color, this.labelColor, this.label);
            } else {
                simGraphics.drawHollowFastRect(this.color);
            }
        } else if (this.label != null) {
            simGraphics.setFont(this.font);
            simGraphics.drawStringInRect(this.color, this.labelColor, this.label);
        } else {
            simGraphics.drawFastRect(this.color);
        }
        if (this.borderWidth != 0 && !this.borderColor.equals(this.color)) {
            simGraphics.drawRectBorder(this.stroke, this.borderColor);
        }
    }

    public boolean contains(Point point) {
        Rectangle rectangle = new Rectangle((int)this.getX(), (int)this.getY(), this.width, this.height);
        return rectangle.contains((Point2D)point);
    }
}

