/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import uchicago.src.sim.engine.ParameterFileListener;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.engine.SimpleModel;
import uchicago.src.sim.engine.gui.ParameterWizard;
import uchicago.src.sim.engine.gui.components.ParameterData;

public class RepastParamPanel
extends JPanel
implements ParameterFileListener {
    private final String BROWSE_ITEM = "<Browse...>";
    private final String CREATE_ITEM = "<Create>";
    private JComboBox paramFileBox;
    private JLabel fileLabel;
    private HashMap paramFiles = new HashMap();
    private String fileSeparator;
    private String newlyCreatedParamFileName = null;
    private SimModel model;

    public RepastParamPanel(SimModel simModel) {
        this.model = simModel;
        this.fileSeparator = System.getProperty("file.separator");
        if (this.fileSeparator.equals("")) {
            this.fileSeparator = "/";
        }
        this.setupPanel();
    }

    private void setupPanel() {
        this.fileLabel = new JLabel("Parameter file: ");
        this.add(this.fileLabel);
        this.paramFileBox = new JComboBox();
        this.paramFileBox.addItem("<Browse...>");
        this.paramFileBox.addItem("<Create>");
        this.paramFileBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RepastParamPanel.this.selectedItemChanged();
            }
        });
        this.add(this.paramFileBox);
    }

    private void selectedItemChanged() {
        String string = null;
        Object object = this.paramFileBox.getSelectedItem();
        if (object == "<Browse...>") {
            string = this.browseForFile();
            if (string != null) {
                this.addToComboBox(string);
            }
        } else if (object == "<Create>") {
            string = this.createNewFile();
            if (string != null) {
                this.addToComboBox(string);
            }
        } else {
            string = (String)this.paramFileBox.getSelectedItem();
        }
    }

    private String browseForFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return file.isDirectory() || string.endsWith(".pf") || string.endsWith(".xml") || string.endsWith(".txt");
            }

            public String getDescription() {
                return "Parameter files (*.pf, *.xml, *.txt)";
            }
        });
        jFileChooser.setDialogType(0);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            return file.getAbsolutePath();
        }
        return null;
    }

    private String createNewFile() {
        ParameterWizard parameterWizard = new ParameterWizard(this);
        ParameterData parameterData = new ParameterData(this.model);
        parameterData.reloadInputOutput();
        parameterWizard.setAParameterData(parameterData);
        parameterWizard.display();
        String string = this.newlyCreatedParamFileName;
        this.newlyCreatedParamFileName = null;
        return string;
    }

    private void addToComboBox(String string) {
        int n = string.lastIndexOf(this.fileSeparator);
        String string2 = string.substring(++n);
        int n2 = 1;
        String string3 = string2;
        while (this.paramFiles.containsKey(string3)) {
            string3 = string2 + "-" + n2;
        }
        string2 = string3;
        this.paramFiles.put(string2, string);
        this.paramFileBox.addItem(string2);
        this.paramFileBox.setSelectedItem(string2);
    }

    public void setParameterFile(String string) {
        this.newlyCreatedParamFileName = string;
    }

    public String getParameterFileName() {
        String string = (String)this.paramFileBox.getSelectedItem();
        if (string == "<Browse...>" || string == "<Create>") {
            this.selectedItemChanged();
            string = (String)this.paramFileBox.getSelectedItem();
        }
        if (!this.paramFiles.containsKey(string)) {
            return null;
        }
        return (String)this.paramFiles.get(string);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        RepastParamPanel repastParamPanel = new RepastParamPanel(new SimpleModel());
        repastParamPanel.setBorder(BorderFactory.createBevelBorder(0));
        jFrame.getContentPane().add(repastParamPanel);
        jFrame.show();
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }
}

