/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.guiUtils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uchicago.src.guiUtils.ColorChooserPopup;

class ColorSwatchPanel
extends JPanel {
    private Color selectedColor = Color.black;
    private Color[] colors;
    private Dimension swatchSize = new Dimension(12, 12);
    private Dimension swatchesDim = new Dimension(6, 6);
    private Dimension gap = new Dimension(1, 1);
    private ColorChooserPopup popup;
    private ArrayList listeners = new ArrayList();

    public ColorSwatchPanel(ColorChooserPopup colorChooserPopup) {
        this.initColors();
        this.setBackground(Color.gray);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.popup = colorChooserPopup;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ColorSwatchPanel.this.selectedColor = ColorSwatchPanel.this.getColor(mouseEvent.getX(), mouseEvent.getY());
                ColorSwatchPanel.this.fireColorChange();
            }
        });
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Dimension getPreferredSize() {
        int n = this.swatchesDim.width * (this.swatchSize.width + this.gap.width);
        int n2 = this.swatchesDim.height * (this.swatchSize.height + this.gap.height);
        return new Dimension(n, n2);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireColorChange() {
        ArrayList arrayList;
        ArrayList arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)arrayList.get(i);
            changeListener.stateChanged(new ChangeEvent(this.popup));
        }
    }

    private Color getColor(int n, int n2) {
        int n3 = n2 / (this.swatchSize.height + this.gap.height);
        int n4 = n / (this.swatchSize.width + this.gap.width);
        return this.getColorForCell(n3, n4);
    }

    public void addColorChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.swatchesDim.height; ++i) {
            for (int j = 0; j < this.swatchesDim.width; ++j) {
                graphics.setColor(this.getColorForCell(i, j));
                int n = j * (this.swatchSize.width + this.gap.width);
                int n2 = i * (this.swatchSize.height + this.gap.height);
                graphics.fill3DRect(n, n2, this.swatchSize.width, this.swatchSize.height, true);
            }
        }
    }

    private Color getColorForCell(int n, int n2) {
        return this.colors[n * this.swatchesDim.width + n2];
    }

    private void initColors() {
        int[] nArray = this.getRawValues();
        int n = nArray.length / 3;
        this.colors = new Color[n];
        for (int i = 0; i < n; ++i) {
            this.colors[i] = new Color(nArray[i * 3], nArray[i * 3 + 1], nArray[i * 3 + 2]);
        }
    }

    private int[] getRawValues() {
        int[] nArray = new int[]{255, 255, 255, 192, 192, 192, 128, 128, 128, 64, 64, 64, 0, 0, 0, 255, 0, 0, 100, 100, 100, 255, 175, 175, 255, 200, 0, 255, 255, 0, 0, 255, 0, 255, 0, 255, 0, 255, 255, 0, 0, 255, 47, 79, 79, 105, 105, 105, 245, 255, 250, 240, 248, 255, 175, 238, 238, 64, 224, 208, 0, 100, 0, 173, 255, 47, 255, 215, 0, 188, 143, 143, 255, 255, 224, 210, 105, 30, 255, 165, 0, 148, 12, 211, 160, 100, 240, 255, 239, 219, 139, 121, 94, 131, 111, 255, 238, 106, 80, 255, 69, 0, 139, 10, 80, 205, 181, 205};
        return nArray;
    }
}

