/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.tools;

import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogistClassLoader {
    public static Object instantiateClass(String name, String classpath) throws Exception {
        URL[] urls = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (classpath == null) {
            urls = new URL[1];
        } else {
            StringTokenizer st = new StringTokenizer(classpath, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                URL url = new URL("file", null, token);
                urlList.add(url);
            }
            urls = new URL[urlList.size()];
            urlList.toArray(urls);
        }
        URLClassLoader cl = URLClassLoader.newInstance(urls);
        Class<?> clMainClass = cl.loadClass(name);
        return clMainClass.newInstance();
    }

    public static Object instantiateClass(String name, String classpath, Class<?>[] aclParams, Object[] aobjArgs) throws Exception {
        URL[] urls = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (classpath == null) {
            urls = new URL[1];
        } else {
            StringTokenizer st = new StringTokenizer(classpath, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                URL url = new URL("file", null, token);
                urlList.add(url);
            }
            urls = new URL[urlList.size()];
            urlList.toArray(urls);
        }
        URLClassLoader cl = URLClassLoader.newInstance(urls);
        Class<?> clMainClass = cl.loadClass(name);
        if (clMainClass == null) {
            throw new ClassNotFoundException(name);
        }
        Constructor<?>[] aclConstructors = clMainClass.getDeclaredConstructors();
        int i = 0;
        while (i < aclConstructors.length) {
            Constructor<?> clConstructor = aclConstructors[i];
            boolean bParamsMatch = true;
            Class<?>[] atParams = clConstructor.getParameterTypes();
            if (atParams.length == aclParams.length) {
                int k = 0;
                while (k < atParams.length) {
                    if (atParams[k].getClass() != aclParams[k].getClass()) {
                        bParamsMatch = false;
                    }
                    ++k;
                }
            } else {
                bParamsMatch = false;
            }
            if (bParamsMatch) {
                LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Loaded class " + name + "!");
                return clConstructor.newInstance(aobjArgs);
            }
            ++i;
        }
        throw new NoSuchMethodException("constructor");
    }
}

