/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.testing.messaging;

import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.messaging.Message;
import epfl.lia.logist.messaging.MessageDispatcher;
import epfl.lia.logist.messaging.MessageHandler;
import epfl.lia.logist.messaging.MessageTypeEnum;
import epfl.lia.logist.messaging.action.Action;
import epfl.lia.logist.messaging.action.ActionTypeEnum;
import epfl.lia.logist.messaging.signal.KillSignal;
import epfl.lia.logist.messaging.signal.TextMessage;
import epfl.lia.logist.tools.AID;

public class MessagingTestSender
extends MessageHandler {
    private AID mChildID1 = null;
    private AID mChildID2 = null;
    private InternalStateEnum meState = InternalStateEnum.CREATED;
    private int mbActiveCount = 2;
    private int mbInitCount = 2;

    public void setAgent1(AID c) {
        this.mChildID1 = c;
    }

    public void setAgent2(AID c) {
        this.mChildID2 = c;
    }

    public void step() {
        Message<?> msg = MessageDispatcher.getInstance().retrieve(this);
        if (msg == null || msg.getMsgType() != MessageTypeEnum.MGT_ACTION) {
            LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_WARNING, "Received an illegal message typ");
            return;
        }
        Action action = (Action)msg;
        switch (this.meState) {
            case CREATED: {
                LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "state == CREATED");
                if (action.getType() != ActionTypeEnum.AMT_READY) break;
                --this.mbInitCount;
                if (this.mbInitCount != 0) break;
                this.sendMessage1();
                this.sendMessage2();
                this.mbInitCount = 2;
                this.meState = InternalStateEnum.IDLE;
                break;
            }
            case IDLE: {
                LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "state == IDLE");
                if (action.getType() != ActionTypeEnum.AMT_READY) break;
                this.meState = InternalStateEnum.KILL;
                break;
            }
            case KILL: {
                LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "state == KILL");
                if (action.getType() != ActionTypeEnum.AMT_READY) break;
                this.killThem();
                this.meState = InternalStateEnum.WAIT_KILLING;
                break;
            }
            case WAIT_KILLING: {
                LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "state == WAIT_KILLING");
                if (action.getType() != ActionTypeEnum.AMT_READY) break;
                --this.mbActiveCount;
                if (this.mbActiveCount != 0) break;
                this.meState = InternalStateEnum.EXIT;
                break;
            }
        }
    }

    public void initAgents() {
    }

    public boolean hasSmthToDo() {
        return MessageDispatcher.getInstance().check(this);
    }

    public boolean isFinished() {
        return this.mbActiveCount == 0;
    }

    public void sendMessage1() {
        LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "Sending first message...");
        TextMessage msg = new TextMessage(this.getObjectID(), this.mChildID1, "Hello from Test sender !!!");
        MessageDispatcher.getInstance().post(msg);
    }

    public void sendMessage2() {
        LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "Sending second message...");
        TextMessage msg = new TextMessage(this.getObjectID(), this.mChildID2, "Hello from Test sender !!!");
        MessageDispatcher.getInstance().post(msg);
    }

    public void killThem() {
        MessageDispatcher.getInstance().post(new KillSignal(this.getObjectID(), this.mChildID1, null));
        MessageDispatcher.getInstance().post(new KillSignal(this.getObjectID(), this.mChildID2, null));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InternalStateEnum {
        CREATED,
        INITIALIZED,
        IDLE,
        SENT,
        KILL,
        WAIT_KILLING,
        EXIT;

    }
}

