/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.task.distribution.function;

import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.task.distribution.function.IFunction;
import epfl.lia.logist.tools.Convert;
import java.util.Properties;
import org.apache.commons.math.random.RandomDataImpl;

public class BinaryDensityFunction
implements IFunction {
    private double[] mValues;
    private RandomDataImpl mRandom = null;
    private long mSeed = 0L;
    private double mBias = 0.0;

    public BinaryDensityFunction() {
        this.mValues = new double[]{0.0, 1.0};
        this.mSeed = System.currentTimeMillis();
        this.mRandom = new RandomDataImpl();
        this.mRandom.reSeed(this.mSeed);
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "Binary density function seed value is " + this.mSeed + " !");
    }

    public BinaryDensityFunction(Properties props) {
        this.mValues = new double[]{Convert.toDouble(props.getProperty("min"), 0.0), Convert.toDouble(props.getProperty("max"), 1.0)};
        this.mBias = Convert.toDouble(props.getProperty("bias"), 0.0);
        this.mSeed = Convert.toLong(props.getProperty("seed"), System.currentTimeMillis());
        this.mRandom = new RandomDataImpl();
        this.mRandom.reSeed(this.mSeed);
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "Binary density function seed value is " + this.mSeed + " !");
    }

    public double nextValue() {
        return this.mValues[this.mRandom.nextUniform(-1.0, 1.0) > this.mBias ? 1 : 0];
    }
}

