/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.logging.format;

import epfl.lia.logist.logging.LogDescriptor;
import epfl.lia.logist.logging.LogEntry;
import epfl.lia.logist.logging.LogOutputFormat;
import java.io.PrintStream;
import java.util.Date;
import java.util.GregorianCalendar;

public class RtfLogOutputFormat
implements LogOutputFormat {
    private PrintStream moFileStream = null;
    private LogDescriptor moDescriptor = null;

    public RtfLogOutputFormat(LogDescriptor d) throws Exception {
        this.moDescriptor = d;
        this.moFileStream = new PrintStream(d.File);
    }

    public void outputEntry(LogEntry e) {
        this.moFileStream.println("\\par \\tx2500 ");
        switch (e.getSeverity()) {
            case LSV_WARNING: {
                this.moFileStream.println("\\cf2 ");
                break;
            }
            case LSV_ERROR: 
            case LSV_FATAL: {
                this.moFileStream.println("\\cf1 ");
            }
        }
        String lsDate = String.format("%1$tH:%1$tM:%1$tS", new Date());
        this.moFileStream.printf("[%s] %-8s \\tab %s \\cf0\n", new Object[]{lsDate, e.getSeverity(), e.getText()});
    }

    public void init() {
        this.outputFileHeader();
    }

    public void close() {
        this.outputFileFooter();
    }

    private void outputFileHeader() {
        String lsJVMVendor = "\\f0 \\b java-vendor     : \\b0 " + System.getProperty("java.vendor");
        String lsJVMVendorURL = "\\f0 \\b java-vendor-url : \\b0 " + System.getProperty("java.vendor.url");
        String lsJVMVersion = "\\f0 \\b java-version    : \\b0 " + System.getProperty("java.version");
        String lsOsArch = "\\f0 \\b os-arch         : \\b0 " + System.getProperty("os.arch");
        String lsOsName = "\\f0 \\b os-name         : \\b0 " + System.getProperty("os.name");
        String lsUsername = "\\f0 \\b user-name       : \\b0 " + System.getProperty("user.name");
        String lsCacheSize = "\\f0 \\b cache-size      : \\b0 " + this.moDescriptor.CacheSize;
        String lsMaxEntries = "\\f0 \\b max-entries     : \\b0 " + this.moDescriptor.MaxEntries;
        String lsDebugLevel = "\\f0 \\b debug-level     : \\b0 " + this.moDescriptor.DebugLevel;
        this.moFileStream.println("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1036");
        this.moFileStream.println("{\\colortbl ;\\red255\\green0\\blue0;\\red255\\green128\\blue0;}");
        this.moFileStream.println("{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}{\\f1\\fmodern\\fprq1\\fcharset0 Courier New;}}");
        this.moFileStream.println("\\f0 \\fs38 \\b Logist Platform RTF Log output \\b0 \\par");
        this.moFileStream.println("\\par \\b \\fs24 Starting date : \\b0 " + String.format("%1$ta %1$tb %1$td %1$tT %1$tZ %1$tY", new GregorianCalendar()));
        this.moFileStream.println("\\par \\b Starting time : \\b0 " + String.format("%1$tH:%1$tM:%1$tS", new GregorianCalendar()));
        this.moFileStream.println("\\par \\par \\fs28 \\b General environnement info: \\b0 \\par");
        this.moFileStream.println("\\par \\fs24 \\tx750 \\tab " + lsJVMVendor);
        this.moFileStream.println("\\par \\tab " + lsJVMVendorURL);
        this.moFileStream.println("\\par \\tab " + lsJVMVersion);
        this.moFileStream.println("\\par \\tab " + lsOsArch);
        this.moFileStream.println("\\par \\tab " + lsOsName);
        this.moFileStream.println("\\par \\tab " + lsUsername);
        this.moFileStream.println("\\par \\tab " + lsCacheSize);
        this.moFileStream.println("\\par \\tab " + lsMaxEntries);
        this.moFileStream.println("\\par \\tab " + lsDebugLevel);
        this.moFileStream.println("\\par \\par \\fs28 \\b Log file entries: \\b0 \\fs24 \\par");
    }

    private void outputFileFooter() {
        this.moFileStream.println("\\par \\par --------------------------------------------------------------------------- \\par");
        this.moFileStream.println("}");
    }
}

