/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent;

import epfl.lia.logist.agent.AgentBehaviorEnum;
import epfl.lia.logist.agent.AgentDescriptor;
import epfl.lia.logist.agent.AgentDisplayable;
import epfl.lia.logist.agent.AgentHistory;
import epfl.lia.logist.agent.AgentManager;
import epfl.lia.logist.agent.AgentProperties;
import epfl.lia.logist.agent.AgentStateEnum;
import epfl.lia.logist.agent.AgentTypeEnum;
import epfl.lia.logist.agent.behavior.Behavior;
import epfl.lia.logist.agent.behavior.BehaviorDescriptor;
import epfl.lia.logist.agent.behavior.DefaultBehavior;
import epfl.lia.logist.agent.entity.Agent;
import epfl.lia.logist.agent.plan.GDeliverAction;
import epfl.lia.logist.agent.plan.GMoveAction;
import epfl.lia.logist.agent.plan.GPickupAction;
import epfl.lia.logist.agent.plan.IGenericAction;
import epfl.lia.logist.agent.plan.Plan;
import epfl.lia.logist.agent.state.AgentState;
import epfl.lia.logist.agent.state.auction.AuctionCompanyState;
import epfl.lia.logist.agent.state.auction.BidderCompanyState;
import epfl.lia.logist.agent.state.auction.BidderVehicleState;
import epfl.lia.logist.agent.state.centralized.CentralizedCompanyState;
import epfl.lia.logist.agent.state.centralized.CentralizedVehicleState;
import epfl.lia.logist.agent.state.deliberative.DeliberativeCompanyState;
import epfl.lia.logist.agent.state.deliberative.DeliberativeVehicleState;
import epfl.lia.logist.agent.state.reactive.ReactiveCompanyState;
import epfl.lia.logist.agent.state.reactive.ReactiveVehicleState;
import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.exception.AgentCreationException;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.messaging.signal.SignalTypeEnum;
import epfl.lia.logist.task.Task;
import epfl.lia.logist.task.TaskManager;
import epfl.lia.logist.tools.AID;
import epfl.lia.logist.tools.LogistClassLoader;
import epfl.lia.logist.tools.LogistGlobals;
import epfl.lia.logist.tools.interpolators.PointInterpolator;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentProfile {
    private Agent mAgent = null;
    private AID mAgentID = null;
    private AgentBehaviorEnum mBehavior = null;
    protected double mCapacity = 0.0;
    protected double mCostPerKm = 0.0;
    private AgentDisplayable mDisplayable = null;
    private AgentHistory mHistory = null;
    protected City mHome = null;
    protected double mLoad = 0.0;
    private LogManager mLog = null;
    public String mName = null;
    private AgentProfile mParent;
    protected double mSpeed = 0.0;
    private AgentState mState;
    private double mTotalCost;
    private double mTotalDistance;
    private double mTotalReward;
    private AgentTypeEnum mType;
    private City mCurrentCity;
    private PointInterpolator mInterpolator;
    private Topology mTopology = null;
    private TaskManager mTaskMgr = null;
    private int mCurrentRound = 0;
    private Plan mCurrentPlan = null;
    private LogistGlobals mGlobals = null;
    private ArrayList<AgentProfile> mChildren = null;
    private long mStartTime;
    private double mRouteDistance;
    private City mTargetCity;
    private City mDeliveryCity = null;
    private ProfileStateEnum mCurrentState = ProfileStateEnum.SERVICING;
    private ProfileStateEnum mLastState = ProfileStateEnum.SERVICING;

    public AgentProfile(LogistGlobals lg) {
        this.mLog = LogManager.getInstance();
        this.mInterpolator = new PointInterpolator();
        this.mChildren = new ArrayList();
        this.mTopology = Topology.getInstance();
        this.mTaskMgr = TaskManager.getInstance();
        this.mGlobals = lg;
    }

    public void init() {
        this.mAgent.start(this.mName);
        this.mState.setState(AgentStateEnum.AS_INIT);
    }

    public void kill() {
        this.mState.setState(AgentStateEnum.AS_KILL);
        if (this.mParent != null) {
            this.mParent.notifyParentForKilling(this);
        }
        this.mHistory.flushRound(this.mCurrentRound);
        this.mHistory.shutdown();
    }

    public void reset(int round) {
        this.mState.setState(AgentStateEnum.AS_RESET);
        this.mState.setRound(round);
        this.mHistory.flushRound(round - 1);
        if (this.mDisplayable != null) {
            City oldCity = this.mHome;
            while (this.mHome.match(oldCity)) {
                this.mHome = this.mTopology.getRandomCity();
            }
            this.mCurrentCity = this.mHome;
            this.mDisplayable.move(new Point(this.mHome.getX(), this.mHome.getY()));
        }
        this.mCurrentState = ProfileStateEnum.SERVICING;
    }

    public boolean isAlive() {
        return this.mState.isAlive() && this.mAgent.isActive();
    }

    public AgentTypeEnum getType() {
        return this.mType;
    }

    public AID getID() {
        return this.mAgentID;
    }

    public LogistGlobals getGlobals() {
        return this.mGlobals;
    }

    public long getSetupTimeout() {
        return this.mGlobals.SetupTimeout;
    }

    public AgentProperties getProperties() {
        AgentProperties ap = new AgentProperties();
        ap.Capacity = this.mCapacity;
        ap.CostPerKm = this.mCostPerKm;
        ap.Load = this.mLoad;
        ap.Speed = this.mSpeed;
        ap.Name = this.mName;
        ap.Home = this.mCurrentCity.getNodeLabel();
        return ap;
    }

    public Agent getAgent() {
        return this.mAgent;
    }

    public City getCurrentCity() {
        return this.mCurrentCity;
    }

    public AgentDisplayable getDisplayable() {
        return this.mDisplayable;
    }

    public String getName() {
        return this.mName;
    }

    public AgentProfile getParent() {
        return this.mParent;
    }

    public AgentState getState() {
        return this.mState;
    }

    public void setPlan(Plan plan) {
        this.mCurrentPlan = plan;
        this.mCurrentState = ProfileStateEnum.PLANNING;
    }

    public void step() {
        block0 : switch (this.mCurrentState) {
            case SERVICING: {
                this.mLastState = ProfileStateEnum.SERVICING;
                this.mState.step();
                break;
            }
            case MOVING: {
                this.stepMove();
                break;
            }
            case PLANNING: {
                if (this.mCurrentPlan != null && this.mCurrentPlan.hasMoreElements()) {
                    IGenericAction nextAction = this.mCurrentPlan.nextElement();
                    if (nextAction == null) {
                        this.mLog.info("[" + this.mName + "] Plan was completely " + "carried over...");
                        break;
                    }
                    switch (nextAction.getType()) {
                        case MOVE: {
                            this.moveAction((GMoveAction)nextAction);
                            break block0;
                        }
                        case PICKUP: {
                            this.pickupAction((GPickupAction)nextAction);
                            break block0;
                        }
                        case DELIVER: {
                            this.deliverAction((GDeliverAction)nextAction);
                            break block0;
                        }
                    }
                    this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, "A bad action was found in current plan !");
                    break;
                }
                this.mCurrentState = ProfileStateEnum.SERVICING;
            }
        }
    }

    public void moveAction(GMoveAction gma) {
        this.moveToCity(this.mCurrentCity, gma.getTarget());
        this.mCurrentState = ProfileStateEnum.MOVING;
        this.mLastState = ProfileStateEnum.PLANNING;
        double incurredCost = this.mRouteDistance * this.mCostPerKm;
        this.mTotalCost += incurredCost;
        this.mTotalDistance += this.mRouteDistance;
        if (this.mParent != null) {
            this.mParent.notityParentForMove(incurredCost, this.mRouteDistance);
        }
        this.mHistory.move(gma.getTarget().getNodeLabel(), incurredCost, this.mRouteDistance);
    }

    public void pickupAction(GPickupAction gpa) {
        Task allocatedTask = gpa.getTask();
        Task t = this.mTaskMgr.allocate(allocatedTask.getID(), this.mCurrentCity, this.mAgentID);
        if (t == null || this.mCapacity < this.mLoad + t.getWeight()) {
            this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, "Task " + allocatedTask + " was already picked up !");
            this.mState.postTaskRefusedSignal(allocatedTask.getID());
            this.setPlan(null);
            return;
        }
        this.mDeliveryCity = this.mTopology.getCity(allocatedTask.getDeliveryCity());
        if (this.mParent != null) {
            this.mParent.notifyParentForPickup(allocatedTask);
        }
        this.mHistory.pickup(this.mDeliveryCity.getNodeLabel());
    }

    public void deliverAction(GDeliverAction action) {
        if (action == null || action.getTask() == null) {
            return;
        }
        Task task = action.getTask();
        if (task == null) {
            return;
        }
        this.mState.postTaskDeliveredSignal(task.getID());
        double rewardPerKm = this.mTaskMgr.deliverTask(this.mAgentID, this.mName, task.getID());
        double absoluteReward = rewardPerKm * this.mCurrentPlan.getDistanceDriven();
        this.mTotalReward += absoluteReward;
        if (this.mParent != null) {
            this.mParent.notifyParentForDelivery(task, absoluteReward);
        }
        this.mHistory.deliver(this.mCurrentCity.getNodeLabel(), absoluteReward);
    }

    public void stepMove() {
        double lElapsedTime = (double)(System.currentTimeMillis() - this.mStartTime) * 0.001;
        double lDistance = lElapsedTime * this.mSpeed;
        if (lDistance < this.mRouteDistance) {
            this.mDisplayable.move(this.mInterpolator.interpolate(lDistance / this.mRouteDistance));
        } else {
            lDistance = this.mRouteDistance;
            this.mCurrentCity = this.mTargetCity;
            this.mCurrentState = this.mLastState;
        }
    }

    public void moveToCity(City city1, City city2) {
        int x1 = city1.getX();
        int y1 = city1.getY();
        int x2 = city2.getX();
        int y2 = city2.getY();
        System.out.println("city1 - " + (Object)((Object)city1));
        System.out.println("city2 - " + (Object)((Object)city2));
        double distance = 0.0;
        try {
            distance = this.mTopology.getDistance(city1, city2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mInterpolator.setFrom(new Point(x1, y1));
        this.mInterpolator.setTo(new Point(x2, y2));
        this.mRouteDistance = distance;
        double mx = x2 - x1;
        double my = y2 - y1;
        double L = Math.sqrt(mx * mx + my * my);
        double invL = L < 1.0E-6 ? 1.0 : 1.0 / L;
        this.mDisplayable.setDirection(mx * invL, my * invL);
        this.mStartTime = System.currentTimeMillis();
        this.mTargetCity = city2;
    }

    public void addChild(AgentProfile child) throws Exception {
        if (this.mType == AgentTypeEnum.VEHICLE) {
            throw new Exception("Vehicles cannot have any children !");
        }
        this.mChildren.add(child);
        this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + this.mName + "] Adding child agent '" + child.getName() + "'...");
    }

    public AgentProfile getChild(int i) {
        return this.mChildren.get(i);
    }

    public ArrayList<AgentProfile> getChildren() {
        return this.mChildren;
    }

    public int getChildrenCount() {
        return this.mChildren.size();
    }

    private void notifyParentForDelivery(Task t, double reward) {
        this.mTotalReward += reward;
        this.mHistory.addReward(reward);
    }

    private void notifyParentForPickup(Task t) {
    }

    private void notityParentForMove(double cost, double dist) {
        this.mTotalCost += cost;
        this.mTotalDistance += dist;
        this.mHistory.addCost(cost);
        this.mHistory.addDistance(dist);
    }

    private void notifyParentForKilling(AgentProfile ap) {
        if (this.mChildren.contains(ap)) {
            this.mChildren.remove(ap);
            this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Child agent '" + ap.getName() + "' was removed from parent '" + this.mName + "'");
            if (this.mChildren.size() == 0) {
                this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Company agent '" + this.mName + "' has no more children ! " + "Agent will kill himself !");
                AgentManager.getInstance().removeAgent(this);
            }
        }
    }

    public void create(AgentDescriptor ad, AgentProfile parent) throws Exception {
        this.mParent = parent;
        this.parseProperties(ad);
        this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + ad.Name + "] Creating agent state...");
        this.createAgentState(ad);
        this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + ad.Name + "] Agent ID is " + this.mState.getObjectID() + "...");
        this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + ad.Name + "] Creating agent entity...");
        this.createAgentEntity(ad);
        this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + ad.Name + "] Entity ID is " + this.mAgent.getObjectID() + "...");
        this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + ad.Name + "] Creating agent representation...");
        if (this.mType == AgentTypeEnum.VEHICLE) {
            this.createAgentRepresentation(ad);
        }
        this.mState.setRecipient(this.mAgent.getObjectID());
        if (this.mParent != null) {
            this.mParent.addChild(this);
        }
    }

    private void createAgentEntity(AgentDescriptor ad) throws Exception {
        this.mAgent = new Agent(this.mState.getObjectID());
        this.registerBehaviors(ad.Behaviors);
    }

    private void createAgentRepresentation(AgentDescriptor ad) throws AgentCreationException {
        this.mDisplayable = new AgentDisplayable();
        this.mDisplayable.setColor(ad.AgentColor);
        this.mDisplayable.move(this.mHome.getX(), this.mHome.getY());
        this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + ad.Name + "] Agent home location is " + (Object)((Object)this.mHome) + "...");
        City mTarget = (City)((Object)this.mTopology.getDestinations(this.mCurrentCity).get(0));
        double mx = mTarget.getX() - this.mHome.getX();
        double my = mTarget.getY() - this.mHome.getY();
        double L = Math.sqrt(mx * mx + my * my);
        double invL = L < 1.0E-6 ? 1.0 : 1.0 / L;
        this.mDisplayable.setDirection(mx * invL, my * invL);
    }

    private void createAgentState(AgentDescriptor ad) throws AgentCreationException {
        switch (this.mType) {
            case VEHICLE: {
                this.createVehicleAgentState(ad, this.mState);
                break;
            }
            case COMPANY: {
                this.createCompanyAgentState(ad);
                break;
            }
            default: {
                throw new AgentCreationException("Found an invalid agent type: '" + ad.Type + "'");
            }
        }
        this.mAgentID = this.mState.getObjectID();
    }

    private void createCompanyAgentState(AgentDescriptor ad) throws AgentCreationException {
        AgentState ps = this.mParent == null ? null : this.mParent.mState;
        switch (this.mBehavior) {
            case REACTIVE: {
                this.mState = new ReactiveCompanyState(this, ps);
                break;
            }
            case DELIBERATIVE: {
                this.mState = new DeliberativeCompanyState(this, ps);
                break;
            }
            case CENTRALIZED: {
                this.mState = new CentralizedCompanyState(this, ps);
                break;
            }
            case AUCTION: {
                this.mState = new AuctionCompanyState(this, ps);
                break;
            }
            case AUCTIONEER: {
                this.mState = new BidderCompanyState(this, ps);
                break;
            }
            case CUSTOM: {
                this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + ad.Name + "] Creating custom company agent " + "from class " + ad.ClassName + "...");
                Class[] args = new Class[]{AgentProfile.class, AgentState.class};
                Object[] objs = new Object[]{this, ps};
                try {
                    Object objState = LogistClassLoader.instantiateClass(ad.ClassName, this.mGlobals.ClassPath, args, objs);
                    if (!(objState instanceof AgentState)) {
                        throw new AgentCreationException("The custom company agent class has a bad type : " + objState + "!");
                    }
                    this.mState = (AgentState)objState;
                    break;
                }
                catch (Exception e) {
                    this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, "Could not create a vehicle agent instance for agent '" + ad.Name + "' from class " + ad.ClassName + ". Please " + "verify that the global classpath variable is " + "correctly set !\n\nCurrent classpath is set to:\n" + this.mGlobals.ClassPath);
                    throw new AgentCreationException("Could not create a company agent instance for agent '" + ad.Name + "' from class " + ad.ClassName + ". Please " + "verify that the global classpath variable is " + "correctly set !");
                }
            }
        }
    }

    private void createVehicleAgentState(AgentDescriptor ad, AgentState parent) throws AgentCreationException {
        AgentState ps = this.mParent == null ? null : this.mParent.mState;
        switch (this.mBehavior) {
            case REACTIVE: {
                this.mState = new ReactiveVehicleState(this, ps);
                break;
            }
            case DELIBERATIVE: {
                this.mState = new DeliberativeVehicleState(this, ps);
                break;
            }
            case CENTRALIZED: {
                this.mState = new CentralizedVehicleState(this, ps);
                break;
            }
            case AUCTIONEER: {
                this.mState = new BidderVehicleState(this, ps);
                break;
            }
            case CUSTOM: {
                this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + ad.Name + "] Creating custom vehicle agent " + "from class " + ad.ClassName + "...");
                Class[] args = new Class[]{AgentProfile.class, AgentState.class};
                Object[] objs = new Object[]{this, ps};
                try {
                    Object objState = LogistClassLoader.instantiateClass(ad.ClassName, this.mGlobals.ClassPath, args, objs);
                    if (!(objState instanceof AgentState)) {
                        throw new AgentCreationException("The custom vehicle agent class has a bad type : " + objState + "!");
                    }
                    this.mState = (AgentState)objState;
                    break;
                }
                catch (Exception e) {
                    this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, "Could not create a company agent instance for agent '" + ad.Name + "' from class " + ad.ClassName + ". Please " + "verify that the global classpath variable is " + "correctly set !\n\nCurrent classpath is set to:\n" + this.mGlobals.ClassPath);
                    throw new AgentCreationException("Could not create a vehicle agent instance for agent '" + ad.Name + "' from class " + ad.ClassName + ". Please " + "verify that the global classpath variable is " + "correctly set !");
                }
            }
        }
    }

    public void parseProperties(AgentDescriptor ad) throws AgentCreationException {
        String lStrType = ad.Type.toLowerCase();
        if (lStrType.equals("vehicle")) {
            this.mType = AgentTypeEnum.VEHICLE;
        } else if (lStrType.equals("company")) {
            this.mType = AgentTypeEnum.COMPANY;
        } else {
            throw new AgentCreationException("Agent '" + ad.Name + "' has" + "an unknown type '" + ad.Type + "'");
        }
        String lStrBehavior = ad.Behavior.toLowerCase();
        if (lStrBehavior.equals("reactive")) {
            this.mBehavior = AgentBehaviorEnum.REACTIVE;
        } else if (lStrBehavior.equals("deliberative")) {
            this.mBehavior = AgentBehaviorEnum.DELIBERATIVE;
        } else if (lStrBehavior.equals("centralized")) {
            this.mBehavior = AgentBehaviorEnum.CENTRALIZED;
        } else if (lStrBehavior.equals("auction")) {
            this.mBehavior = AgentBehaviorEnum.AUCTION;
        } else if (lStrBehavior.equals("bidder")) {
            this.mBehavior = AgentBehaviorEnum.AUCTIONEER;
        } else if (lStrBehavior.equals("custom")) {
            this.mBehavior = AgentBehaviorEnum.CUSTOM;
        } else {
            throw new AgentCreationException("Agent '" + ad.Name + "' has " + "an unknown behavior '" + ad.Behavior + "'");
        }
        if (ad.Home.equals("random")) {
            this.mHome = Topology.getInstance().getRandomCity();
        } else {
            this.mHome = Topology.getInstance().getCity(ad.Home);
            if (this.mHome == null) {
                throw new AgentCreationException("City '" + ad.Home + "' " + "does not exist in current topology ! Invalid home " + "location for agent '" + ad.Name + "'");
            }
        }
        this.mCurrentCity = this.mHome;
        this.mName = ad.Name;
        this.mSpeed = ad.Speed;
        this.mCapacity = ad.Capacity;
        this.mCostPerKm = ad.CostPerKM;
        this.mHistory = new AgentHistory(String.valueOf(this.mGlobals.HistoryPath) + File.separator + this.mName);
        try {
            this.mHistory.init();
        }
        catch (Exception e) {
            throw new AgentCreationException("The history object for agent '" + this.mName + "' could not " + "be initialized !\nHere is a description of the problem: " + e.getMessage());
        }
    }

    private void registerBehaviors(ArrayList<BehaviorDescriptor> behaviors) throws Exception {
        if (behaviors == null || behaviors.isEmpty()) {
            this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "[" + this.mName + "] No behavior was found. Resetting to" + " defaults !");
            DefaultBehavior rDefBehavior = new DefaultBehavior();
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_INIT, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_RESET, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_SETUP, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_KILL, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_INCITY, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_INSTATE, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_TASKDELIVERED, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_TASKREFUSED, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_AUCTION_START, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_AUCTION_END, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_AUCTION_WON, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_AUCTION_LOST, rDefBehavior);
            this.mAgent.registerBehavior(SignalTypeEnum.SMT_ASKBID, rDefBehavior);
            return;
        }
        HashMap<String, SignalTypeEnum> lSignals = new HashMap<String, SignalTypeEnum>();
        lSignals.put("init", SignalTypeEnum.SMT_INIT);
        lSignals.put("reset", SignalTypeEnum.SMT_RESET);
        lSignals.put("kill", SignalTypeEnum.SMT_KILL);
        lSignals.put("setup", SignalTypeEnum.SMT_SETUP);
        lSignals.put("incity", SignalTypeEnum.SMT_INCITY);
        lSignals.put("instate", SignalTypeEnum.SMT_INSTATE);
        lSignals.put("taskdelivered", SignalTypeEnum.SMT_TASKDELIVERED);
        lSignals.put("taskrefused", SignalTypeEnum.SMT_TASKREFUSED);
        lSignals.put("auction-start", SignalTypeEnum.SMT_AUCTION_START);
        lSignals.put("auction-end", SignalTypeEnum.SMT_AUCTION_END);
        lSignals.put("askbid", SignalTypeEnum.SMT_ASKBID);
        lSignals.put("auction-won", SignalTypeEnum.SMT_AUCTION_WON);
        lSignals.put("auction-lost", SignalTypeEnum.SMT_AUCTION_LOST);
        HashMap<String, Behavior> lLoadedClasses = new HashMap<String, Behavior>();
        for (BehaviorDescriptor bd : behaviors) {
            Behavior bh;
            block12: {
                bh = null;
                if (lLoadedClasses.get(bd.Handler) != null) {
                    bh = (Behavior)lLoadedClasses.get(bd.Handler);
                } else {
                    try {
                        Object objBehavior = LogistClassLoader.instantiateClass(bd.Handler, this.mGlobals.ClassPath);
                        if (objBehavior instanceof Behavior) {
                            bh = (Behavior)objBehavior;
                            break block12;
                        }
                        throw new AgentCreationException("The behavior for signal '" + bd.Signal + "' has an incorrect " + "class type: " + objBehavior + "!");
                    }
                    catch (Exception e) {
                        this.mLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, "Class loader could not create a custom instance of the behavior corresponding to class '" + bd.Handler + " for agent '" + this.mName + "' ! " + "Please verify that the global classpath variable " + "is correctly set !\n\nCurrent classpath " + "is set to:\n" + this.mGlobals.ClassPath);
                        throw new AgentCreationException("Could not create an instance of custom behavior for agent '" + this.mName + "' from class " + bd.Handler + ". Please " + "verify that the global classpath variable is " + "correctly set !");
                    }
                }
            }
            if (bh == null) {
                throw new Exception("Behavior class " + bd.Handler + " could " + "not be found !");
            }
            if (bd.Signal.equals("*")) {
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_INIT, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_RESET, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_SETUP, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_KILL, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_INCITY, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_INSTATE, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_TASKDELIVERED, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_TASKREFUSED, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_AUCTION_START, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_AUCTION_END, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_ASKBID, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_AUCTION_WON, bh);
                this.mAgent.registerBehavior(SignalTypeEnum.SMT_AUCTION_LOST, bh);
                lSignals.clear();
                if (lLoadedClasses.containsKey(bd.Handler)) continue;
                lLoadedClasses.put(bd.Handler, bh);
                continue;
            }
            if (bd.Signal.equals("$")) {
                for (SignalTypeEnum d : lSignals.values()) {
                    this.mAgent.registerBehavior(d, bh);
                }
                lSignals.clear();
                continue;
            }
            SignalTypeEnum st = (SignalTypeEnum)((Object)lSignals.get(bd.Signal));
            if (st != null) {
                this.mAgent.registerBehavior(st, bh);
                lSignals.remove((Object)st);
                if (lLoadedClasses.containsKey(bd.Handler)) continue;
                lLoadedClasses.put(bd.Handler, bh);
                continue;
            }
            throw new AgentCreationException("Cannot assign a signal twice ! Please suppress one of the duplicated " + bd.Signal + " signals !");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProfileStateEnum {
        MOVING,
        SERVICING,
        DELIVERING,
        PLANNING;

    }
}

