/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import uchicago.src.sim.gui.Drawable;
import uchicago.src.sim.gui.SimGraphics;

public class AgentDisplayable
implements Drawable {
    private Color mColor;
    private double mX;
    private double mY;
    private Point[] mArrow = new Point[3];

    public AgentDisplayable() {
        this.mArrow[0] = new Point(0, 0);
        this.mArrow[1] = new Point(0, 0);
        this.mArrow[2] = new Point(0, 0);
    }

    public void setDirection(double mx, double my) {
        double a = 2.0943951023931953;
        double angleA = Math.atan2(my, mx);
        double angleB = angleA + a;
        double angleC = angleB + a;
        this.mArrow[0].x = (int)(15.0 * mx);
        this.mArrow[0].y = (int)(15.0 * my);
        this.mArrow[1].x = (int)(15.0 * Math.cos(angleB));
        this.mArrow[1].y = (int)(15.0 * Math.sin(angleB));
        this.mArrow[2].x = (int)(15.0 * Math.cos(angleC));
        this.mArrow[2].y = (int)(15.0 * Math.sin(angleC));
    }

    public void draw(SimGraphics g) {
        double X = this.mX;
        double Y = this.mY;
        if (X < 0.0 && X > 500.0) {
            X = 100.0;
        }
        if (Y < 0.0 && Y > 500.0) {
            Y = 100.0;
        }
        Graphics2D g2 = g.getGraphics();
        g2.setPaint(this.mColor);
        int rX = 5;
        int rY = 5;
        g2.fillRoundRect((int)X - rX, (int)Y - rY, rX * 2, rY * 2, 3, 3);
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = (int)X + this.mArrow[0].x;
        py[0] = (int)Y + this.mArrow[0].y;
        px[1] = (int)(X + (double)this.mArrow[1].x);
        py[1] = (int)(Y + (double)this.mArrow[1].y);
        px[2] = (int)(X + (double)this.mArrow[2].x);
        py[2] = (int)(Y + (double)this.mArrow[2].y);
        g2.fillPolygon(px, py, 3);
    }

    public void move(double X, double Y) {
        this.mX = X;
        this.mY = Y;
    }

    public void move(Point pt) {
        this.mX = pt.x;
        this.mY = pt.y;
    }

    public Color getColor() {
        return this.mColor;
    }

    public int getX() {
        return (int)this.mX;
    }

    public int getY() {
        return (int)this.mY;
    }

    public void setColor(Color c) {
        this.mColor = c;
    }

    public void setX(int X) {
        this.mX = X;
    }

    public void setY(int Y) {
        this.mY = Y;
    }
}

