/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcSolver;
import ilog.solver.bp;
import ilog.solver.ce;
import ilog.solver.in;
import ilog.solver.nm;
import ilog.solver.ot;
import ilog.solver.ys;

public abstract class IlcPIntAbstractVar
extends ys {
    final IlcSolver rvb;
    String svb;
    private ot tvb;

    public final IlcSolver getSolver() {
        return this.rvb;
    }

    IlcPIntAbstractVar(IlcSolver ilcSolver, String string) {
        this.rvb = ilcSolver;
        this.tvb = null;
        this.svb = string;
        ilcSolver.rd();
    }

    public static ys intConst(IlcSolver ilcSolver, int n2) {
        return IlcPIntAbstractVar.intConst(ilcSolver, n2, null);
    }

    public static ys intConst(IlcSolver ilcSolver, int n2, String string) {
        ce ce2 = new ce(ilcSolver, n2, string);
        ilcSolver.xd();
        return ce2;
    }

    public static IlcPIntAbstractVar intVar(IlcSolver ilcSolver, int n2, int n3) {
        return IlcPIntAbstractVar.intVar(ilcSolver, n2, n3, null);
    }

    public static IlcPIntAbstractVar intVar(IlcSolver ilcSolver, int n2, int n3, String string) {
        if (n2 == n3) {
            return new ce(ilcSolver, n2, string);
        }
        if (n2 == 0 && n3 == 1) {
            return new bp(ilcSolver, string);
        }
        return new in(ilcSolver, n2, n3, string);
    }

    public static IlcPIntAbstractVar intVar(IlcSolver ilcSolver, int[] nArray) {
        return IlcPIntAbstractVar.intVar(ilcSolver, nArray, null);
    }

    public static IlcPIntAbstractVar intVar(IlcSolver ilcSolver, int[] nArray, String string) {
        return new in(ilcSolver, nArray, string);
    }

    public final void setName(String string) {
        this.svb = string;
    }

    public final String getName() {
        return this.svb;
    }

    public abstract int getOldMin();

    public abstract int getOldMax();

    public abstract boolean isRange();

    final boolean jn() {
        return true;
    }

    final void kn() {
    }

    final boolean gr() {
        return false;
    }

    private ot nv() {
        if (this.tvb == null) {
            this.tvb = new ot(this.rvb);
        }
        return this.tvb;
    }

    protected void isUsed(nm nm2) {
        this.nv().fs(nm2);
    }

    public void reCompute() {
        this.nv().gs();
    }

    protected final void traceFail() {
        if (this.rvb.mj) {
            System.out.println("fail on " + this);
        }
        this.rvb.fail();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getDomainMin();
        int n3 = this.getDomainMax();
        if (this.svb != null) {
            stringBuffer.append(this.svb);
        }
        stringBuffer.append("[");
        stringBuffer.append(n2);
        if (n2 < n3) {
            if (!this.isRange()) {
                int n4 = n2;
                while (n4 < n3) {
                    int n5 = this.getNextHigher(n4);
                    if (n5 == n4 + 1) {
                        while (n5 == n4 + 1) {
                            n4 = n5;
                            n5 = this.getNextHigher(n4);
                        }
                        stringBuffer.append("..");
                        stringBuffer.append(n4);
                    }
                    if (n4 != n5) {
                        stringBuffer.append(" ");
                        stringBuffer.append(n5);
                    }
                    n4 = n5;
                }
            } else {
                stringBuffer.append("..");
                stringBuffer.append(n3);
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

