/*
 * Decompiled with CFR 0.152.
 */
package TrialAgent;

import TrialAgent.Action;
import TrialAgent.CentralizedPlan;
import TrialAgent.MyVehicle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import logist.task.Task;
import logist.task.TaskSet;

public class PDP {
    private List<MyVehicle> vehicles;
    private TaskSet tasks;
    private static double prop = 0.35;
    private CentralizedPlan bestPlan;
    private double minCost = 2.147483647E9;

    public PDP(List<MyVehicle> vehicles, TaskSet tasks) {
        this.vehicles = vehicles;
        this.tasks = tasks;
    }

    public void SLSAlgorithmWithInitPlan(long allowedTime, CentralizedPlan plan, long startTime) {
        allowedTime = allowedTime * 3L / 4L;
        this.bestPlan = plan;
        int iterationNum = 500;
        for (int i = 0; i < iterationNum; ++i) {
            if (System.currentTimeMillis() - startTime > allowedTime) {
                System.out.println("timed out");
                break;
            }
            CentralizedPlan oldPlan = plan;
            ArrayList<CentralizedPlan> planSet = this.ChooseNeighbours(oldPlan);
            plan = this.localChoice(oldPlan, planSet);
        }
    }

    public CentralizedPlan SLSAlgorithm(long allowedTime) {
        CentralizedPlan plan;
        allowedTime = allowedTime * 2L / 3L;
        long startTime = System.currentTimeMillis();
        this.bestPlan = plan = this.SelectInitialSolution();
        int iterationNum = 30000;
        for (int i = 0; i < iterationNum; ++i) {
            if (System.currentTimeMillis() - startTime > allowedTime) {
                return plan;
            }
            CentralizedPlan oldPlan = plan;
            ArrayList<CentralizedPlan> planSet = this.ChooseNeighbours(oldPlan);
            plan = this.localChoice(oldPlan, planSet);
        }
        return plan;
    }

    public ArrayList<CentralizedPlan> ChooseNeighbours(CentralizedPlan oldPlan) {
        ArrayList<CentralizedPlan> planSet = new ArrayList<CentralizedPlan>();
        Random random = new Random();
        int selectVehicleNum = random.nextInt(this.vehicles.size());
        MyVehicle selectVehicle = this.vehicles.get(selectVehicleNum);
        for (MyVehicle exchangeVehicle : this.vehicles) {
            for (MyVehicle currentVehicle : this.vehicles) {
                LinkedList<Action> vehicleActions = oldPlan.getVehicleActions().get(exchangeVehicle);
                if (currentVehicle == exchangeVehicle || vehicleActions.size() <= 0) continue;
                for (int i = 0; i < oldPlan.getVehicleActions().get(exchangeVehicle).size(); ++i) {
                    Action exchangeAction = oldPlan.getVehicleActions().get(exchangeVehicle).get(0);
                    if (exchangeAction.currentTask.weight > currentVehicle.getCapacity()) continue;
                    List<CentralizedPlan> planList = this.changingVehicle(oldPlan, exchangeVehicle, currentVehicle);
                    for (CentralizedPlan plan : planList) {
                        if (plan.violateConstraint()) continue;
                        planSet.add(plan);
                    }
                }
            }
        }
        LinkedList<Action> vehicleAction = oldPlan.getVehicleActions().get(selectVehicle);
        int length = vehicleAction.size();
        if (length > 2) {
            for (int tIdx = 0; tIdx < length; ++tIdx) {
                if (vehicleAction.get((int)tIdx).type != Action.Type.PICKUP) continue;
                List<CentralizedPlan> planList = this.changingTaskOrder(oldPlan, selectVehicle, tIdx);
                for (CentralizedPlan plan : planList) {
                    if (plan.violateConstraint()) continue;
                    planSet.add(plan);
                }
            }
        }
        return planSet;
    }

    public List<CentralizedPlan> changingVehicle(CentralizedPlan oldPlan, MyVehicle v1, MyVehicle v2) {
        CentralizedPlan newPlan = null;
        try {
            newPlan = (CentralizedPlan)oldPlan.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        Task startTask = newPlan.getVehicleActions().get((Object)v1).get((int)0).currentTask;
        newPlan.removeTask(startTask);
        Action pickupAction = new Action(Action.Type.PICKUP, startTask);
        Action deliverAction = new Action(Action.Type.DELIVERY, startTask);
        LinkedList<Action> stateListV2 = newPlan.getVehicleActions().get(v2);
        stateListV2.addFirst(pickupAction);
        ArrayList<CentralizedPlan> planSet = new ArrayList<CentralizedPlan>();
        for (int i = 1; i <= stateListV2.size(); ++i) {
            LinkedList stateListCopy = (LinkedList)stateListV2.clone();
            stateListCopy.add(i, deliverAction);
            try {
                CentralizedPlan copyPlan = (CentralizedPlan)newPlan.clone();
                copyPlan.getVehicleActions().put(v2, stateListCopy);
                planSet.add(copyPlan);
                continue;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return planSet;
    }

    private List<CentralizedPlan> changingTaskOrder(CentralizedPlan oldPlan, MyVehicle v1, int tIdx) {
        ArrayList<CentralizedPlan> planSet = new ArrayList<CentralizedPlan>();
        CentralizedPlan newPlan = null;
        try {
            newPlan = (CentralizedPlan)oldPlan.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        LinkedList<Action> actionList = newPlan.getVehicleActions().get(v1);
        Task task = actionList.get((int)tIdx).currentTask;
        newPlan.removeTask(task);
        Action pickupAction = new Action(Action.Type.PICKUP, task);
        Action deliveryAction = new Action(Action.Type.DELIVERY, task);
        for (int insert1 = 0; insert1 <= actionList.size(); ++insert1) {
            for (int insert2 = insert1 + 1; insert2 <= actionList.size() + 1; ++insert2) {
                try {
                    CentralizedPlan copyPlan = (CentralizedPlan)newPlan.clone();
                    LinkedList copyList = (LinkedList)actionList.clone();
                    copyList.add(insert1, pickupAction);
                    copyList.add(insert2, deliveryAction);
                    copyPlan.getVehicleActions().put(v1, copyList);
                    planSet.add(copyPlan);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
        }
        return planSet;
    }

    private CentralizedPlan localChoice(CentralizedPlan oldPlan, ArrayList<CentralizedPlan> planSet) {
        Random random;
        int num;
        CentralizedPlan returnPlan = oldPlan;
        CentralizedPlan minCostPlan = null;
        double minCost = 2.147483647E9;
        for (CentralizedPlan plan : planSet) {
            double tmpCost = plan.cost();
            if (!(tmpCost < minCost)) continue;
            minCostPlan = plan;
            minCost = tmpCost;
        }
        if (minCost < this.minCost) {
            this.bestPlan = minCostPlan;
            this.minCost = minCost;
        }
        returnPlan = (double)(num = (random = new Random()).nextInt(100)) < prop * 100.0 ? minCostPlan : ((double)num < 2.0 * prop * 100.0 ? oldPlan : planSet.get(random.nextInt(planSet.size())));
        return returnPlan;
    }

    public CentralizedPlan SelectInitialSolution() {
        int minCapacity = Integer.MIN_VALUE;
        MyVehicle selectedVehicle = null;
        for (MyVehicle vehicle : this.vehicles) {
            if (vehicle.getCapacity() <= minCapacity) continue;
            minCapacity = vehicle.getCapacity();
            selectedVehicle = vehicle;
        }
        HashMap<MyVehicle, LinkedList<Action>> stateMap = new HashMap<MyVehicle, LinkedList<Action>>();
        LinkedList<Action> actionList = new LinkedList<Action>();
        for (Task task : this.tasks) {
            Action pickupState = new Action(Action.Type.PICKUP, task);
            Action deliverState = new Action(Action.Type.DELIVERY, task);
            actionList.addLast(pickupState);
            actionList.addLast(deliverState);
        }
        System.out.println(this.vehicles.size());
        for (MyVehicle vehicle : this.vehicles) {
            stateMap.put(vehicle, new LinkedList());
        }
        stateMap.put(selectedVehicle, actionList);
        CentralizedPlan initialPlan = new CentralizedPlan();
        initialPlan.setVehicleActions(stateMap);
        return initialPlan;
    }

    public CentralizedPlan getBestPlan() {
        return this.bestPlan;
    }
}

