/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloDecVar;
import ilog.concert.IloException;
import ilog.concert.IloIntExpr;
import ilog.concert.model.IlcIntervalUnion;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDec;
import ilog.solver.IlcDecVar;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntVar;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.nm;
import ilog.solver.sv;
import ilog.solver.ys;

class ed
extends IlcConstraint {
    protected IlcDecVar _var;
    protected int[] _values;
    protected IlcIntVar _index;

    public ed(IloDecVar iloDecVar, IloIntExpr iloIntExpr) throws IloException {
        this._var = (IlcDecVar)iloDecVar;
        this._index = (IlcIntVar)iloIntExpr;
        if (!this._var.isIndexVarNull()) {
            throw new IloException("Internal error: index var should be null");
        }
        this._var.linkIndexVar(this._index);
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        nm nm2 = this._var.getPNumExp(ilcSolver);
        if (nm2 instanceof sv) {
            sv sv2 = (sv)nm2;
            ys ys2 = this._index.getPIntExp(ilcSolver);
            if (this._var.isEnumerated()) {
                return new fo(sv2, ys2);
            }
            double d2 = IlcDec.unscaledCastUp(this._var.getLB(), this._var.getScale());
            return new fo(sv2, ys2, d2);
        }
        throw new IloException("DecIndexCt is defined only for DecVar");
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("decIndexCt(");
        stringBuffer.append(this._var);
        stringBuffer.append(", ");
        stringBuffer.append(this._index);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloDecVar iloDecVar = (IloDecVar)iloCopyManager.getCopy(this._var);
        IloIntExpr iloIntExpr = (IloIntExpr)iloCopyManager.getCopy(this._index);
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.decIndex(iloDecVar, iloIntExpr);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var.needCopy(check);
        this._index.needCopy(check);
    }

    static final class fo
    extends IlcPPropagator {
        protected final sv _var;
        protected final IlcIntervalUnion _values;
        protected final ys _index;
        protected final double _unscaledInitialMin;

        public fo(sv sv2, ys ys2) {
            this._var = sv2;
            this._values = sv2.getIntervals();
            this._index = ys2;
            this._unscaledInitialMin = 0.0;
        }

        public fo(sv sv2, ys ys2, double d2) {
            this._var = sv2;
            this._values = null;
            this._index = ys2;
            this._unscaledInitialMin = d2;
        }

        public void post() {
            this._var.whenRange(new gu());
            this._index.whenRange(new js());
        }

        public void propagate() {
            this.qp();
            this.op();
        }

        private void op() {
            if (this._values != null) {
                double d2 = this._values.getLBs(this._index.getDomainMin());
                double d3 = this._values.getUBs(this._index.getDomainMax());
                this._var.setDomainRange(d2, d3);
            } else {
                double d4 = this._unscaledInitialMin + (double)this._index.getDomainMin();
                double d5 = this._unscaledInitialMin + (double)this._index.getDomainMax();
                this._var.setUnscaledDomainRange(d4, d5);
            }
        }

        private void qp() {
            if (this._values != null) {
                int n2 = this._values.getIndex(this._var.getDomainLB());
                int n3 = this._values.getIndex(this._var.getDomainUB());
                this._index.setDomainRange(n2, n3);
            } else {
                int n4 = (int)((double)this._var.getUnscaledDomainLB() - this._unscaledInitialMin);
                int n5 = (int)((double)this._var.getUnscaledDomainUB() - this._unscaledInitialMin);
                this._index.setDomainRange(n4, n5);
            }
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("decIndexCt(");
            stringBuffer.append(this._var);
            stringBuffer.append(", ");
            stringBuffer.append(this._index);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        class js
        extends IlcDemon {
            js() {
            }

            public void propagate() {
                fo.this.op();
            }
        }

        class gu
        extends IlcDemon {
            gu() {
            }

            public void propagate() {
                fo.this.qp();
            }
        }
    }
}

