/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import logist.LogistSettings;
import logist.agent.Agent;
import logist.behavior.AuctionBehavior;
import logist.config.Parsers;
import logist.plan.Action;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;

public class AuctionImproved
implements AuctionBehavior {
    private Topology topology;
    private TaskDistribution distribution;
    private Agent agent;
    private long timeout_setup;
    private long timeout_bid;
    private long timeout_plan;
    private Random random;
    private List<Task> wonTasks;
    private double opponentCostMultiplier = 1.0;
    private double opponentBidEstimate = 1000.0;

    public void setup(Topology topology, TaskDistribution distribution, Agent agent) {
        this.topology = topology;
        this.distribution = distribution;
        this.agent = agent;
        this.random = new Random(agent.id() * 12345);
        this.wonTasks = new ArrayList<Task>();
        LogistSettings ls = null;
        try {
            ls = Parsers.parseSettings((String)("config" + File.separator + "settings_auction.xml"));
        }
        catch (Exception e) {
            System.out.println("Error loading settings.");
        }
        long margin = 200L;
        this.timeout_setup = ls.get(LogistSettings.TimeoutKey.SETUP) - margin;
        this.timeout_bid = ls.get(LogistSettings.TimeoutKey.BID) - margin;
        this.timeout_plan = ls.get(LogistSettings.TimeoutKey.PLAN) - margin;
        System.out.println("[AuctionImproved.setup] done. timeouts: setup=" + this.timeout_setup + " bid=" + this.timeout_bid + " plan=" + this.timeout_plan);
    }

    public Long askPrice(Task task) {
        double oppEst;
        double bestCost = Double.POSITIVE_INFINITY;
        for (Vehicle v : this.agent.vehicles()) {
            double cost;
            if (v.capacity() < task.weight || !((cost = (v.getCurrentCity().distanceTo(task.pickupCity) + task.pickupCity.distanceTo(task.deliveryCity)) * (double)v.costPerKm()) < bestCost)) continue;
            bestCost = cost;
        }
        if (Double.isInfinite(bestCost)) {
            bestCost = 100000.0;
        }
        if ((oppEst = this.opponentCostMultiplier * bestCost) < 0.0) {
            oppEst = 0.0;
        }
        this.opponentBidEstimate = oppEst;
        double margin = 0.1;
        double bid = bestCost + margin * (oppEst - bestCost);
        if (bid < 0.0) {
            bid = 250 + this.random.nextInt(500);
        }
        return Math.round(bid);
    }

    public void auctionResult(Task previous, int winner, Long[] bids) {
        if (winner == this.agent.id()) {
            System.out.println("We won task: " + previous.id);
            this.wonTasks.add(previous);
        } else {
            System.out.println("Opponent won task: " + previous.id);
        }
        long oppBid = 0L;
        for (int i = 0; i < bids.length; ++i) {
            if (i == this.agent.id()) continue;
            oppBid = bids[i];
            break;
        }
        if (this.opponentBidEstimate > 0.0) {
            double ratio = (double)oppBid / this.opponentBidEstimate;
            this.opponentCostMultiplier = 0.2 * ratio + 0.8 * this.opponentCostMultiplier;
        }
    }

    public List<Plan> plan(List<Vehicle> vehicles, TaskSet tasks) {
        int i;
        long start = System.currentTimeMillis();
        Vehicle mainV = vehicles.get(0);
        Plan initialPlan = this.buildSimplePlan(mainV, this.wonTasks);
        double bestCost = this.planCost(vehicles, initialPlan, this.wonTasks);
        Plan bestPlan = initialPlan;
        int maxIterations = 1000;
        for (int iter = 0; iter < maxIterations && System.currentTimeMillis() - start <= this.timeout_plan; ++iter) {
            int j;
            if (this.wonTasks.size() <= 1 || (i = this.random.nextInt(this.wonTasks.size())) == (j = this.random.nextInt(this.wonTasks.size()))) continue;
            ArrayList<Task> newOrder = new ArrayList<Task>(this.wonTasks);
            Task tmp = (Task)newOrder.get(i);
            newOrder.set(i, (Task)newOrder.get(j));
            newOrder.set(j, tmp);
            Plan candidate = this.buildSimplePlan(mainV, newOrder);
            double candidateCost = this.planCost(vehicles, candidate, newOrder);
            if (!(candidateCost < bestCost)) continue;
            bestCost = candidateCost;
            bestPlan = candidate;
            this.wonTasks = newOrder;
        }
        ArrayList<Plan> plans = new ArrayList<Plan>();
        plans.add(bestPlan);
        for (i = 1; i < vehicles.size(); ++i) {
            plans.add(Plan.EMPTY);
        }
        return plans;
    }

    private Plan buildSimplePlan(Vehicle v, List<Task> tasks) {
        Plan p = new Plan(v.getCurrentCity(), new Action[0]);
        Topology.City current = v.getCurrentCity();
        for (Task t : tasks) {
            for (Topology.City city : current.pathTo(t.pickupCity)) {
                p.appendMove(city);
            }
            p.appendPickup(t);
            current = t.pickupCity;
            for (Topology.City city : current.pathTo(t.deliveryCity)) {
                p.appendMove(city);
            }
            p.appendDelivery(t);
            current = t.deliveryCity;
        }
        return p;
    }

    private double planCost(List<Vehicle> vehicles, Plan p, List<Task> tasks) {
        Vehicle v = vehicles.get(0);
        double dist = p.totalDistance();
        return dist * (double)v.costPerKm();
    }
}

