/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import logist.task.Task;
import template.Candidate;
import template.EncodedAction;
import template.PD_Action;
import template.Vehicle2;

public class EncodedCandidate {
    private List<Vehicle2> vehicles;
    private List<List<EncodedAction>> plans;
    private List<List<Integer>> taskLists;
    private Double cost;

    public EncodedCandidate(Candidate candidate) {
        this.vehicles = new ArrayList<Vehicle2>(candidate.vehicles);
        this.plans = new ArrayList<List<EncodedAction>>(this.vehicles.size());
        this.taskLists = new ArrayList<List<Integer>>(this.vehicles.size());
        this.cost = candidate.cost;
        for (List<PD_Action> list : candidate.plans) {
            ArrayList<EncodedAction> vehiclePlan = new ArrayList<EncodedAction>();
            for (PD_Action pD_Action : list) {
                EncodedAction encodedAction = new EncodedAction(pD_Action);
                vehiclePlan.add(encodedAction);
            }
            this.plans.add(vehiclePlan);
        }
        for (List<PD_Action> list : candidate.taskLists) {
            ArrayList<Integer> vehicleTasks = new ArrayList<Integer>();
            for (Task task : list) {
                vehicleTasks.add(task.id);
            }
            this.taskLists.add(vehicleTasks);
        }
    }

    public EncodedCandidate(EncodedCandidate candidate) {
        this.vehicles = new ArrayList<Vehicle2>(candidate.vehicles);
        this.taskLists = new ArrayList<List<Integer>>(this.vehicles.size());
        this.plans = new ArrayList<List<EncodedAction>>(this.vehicles.size());
        for (List<Integer> list : candidate.taskLists) {
            this.taskLists.add(list);
        }
        for (List<Object> list : candidate.plans) {
            this.plans.add(list);
        }
        this.cost = candidate.cost;
    }

    public List<Vehicle2> getVehicles() {
        return this.vehicles;
    }

    public List<List<EncodedAction>> getPlans() {
        return this.plans;
    }

    public List<List<Integer>> getTaskLists() {
        return this.taskLists;
    }

    public Double getCost() {
        return this.cost;
    }

    public Candidate getCandidate(Candidate candidate) {
        HashMap<Integer, Task> taskLookup = new HashMap<Integer, Task>();
        for (List<Task> taskList : candidate.taskLists) {
            for (Task task : taskList) {
                taskLookup.put(task.id, task);
            }
        }
        ArrayList<List<Task>> finalTaskLists = new ArrayList<List<Task>>();
        ArrayList<List<PD_Action>> finalPlanLists = new ArrayList<List<PD_Action>>();
        for (int i = 0; i < this.vehicles.size(); ++i) {
            ArrayList<Task> vehicleTaskList = new ArrayList<Task>();
            ArrayList<PD_Action> vehiclePlan = new ArrayList<PD_Action>();
            for (Integer taskId : this.taskLists.get(i)) {
                vehicleTaskList.add((Task)taskLookup.get(taskId));
            }
            for (EncodedAction encodedPlan : this.plans.get(i)) {
                PD_Action pd_action = new PD_Action(encodedPlan.getIsPickup(), (Task)taskLookup.get(encodedPlan.getTaskId()));
                vehiclePlan.add(pd_action);
            }
            finalTaskLists.add(vehicleTaskList);
            finalPlanLists.add(vehiclePlan);
        }
        return new Candidate(this.vehicles, finalPlanLists, finalTaskLists, this.cost);
    }
}

