/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import logist.Measures;
import logist.task.Task;
import logist.topology.Topology;
import template.PD_Action;
import template.Vehicle2;

public class Candidate {
    public Double cost;
    public List<Vehicle2> vehicles;
    public List<List<PD_Action>> plans;
    public List<List<Task>> taskLists;

    public Candidate(List<Vehicle2> vehicles, List<List<PD_Action>> plans, List<List<Task>> taskLists, Double cost) {
        this.vehicles = vehicles;
        this.plans = plans;
        this.taskLists = taskLists;
        this.cost = cost;
    }

    public Candidate(List<Vehicle2> vehicles) {
        ArrayList<List<PD_Action>> plans = new ArrayList<List<PD_Action>>();
        ArrayList<List<Task>> taskLists = new ArrayList<List<Task>>();
        for (int i = 0; i < vehicles.size(); ++i) {
            plans.add(new ArrayList());
            taskLists.add(new ArrayList());
        }
        this.vehicles = vehicles;
        this.plans = plans;
        this.taskLists = taskLists;
        this.cost = 0.0;
    }

    public Candidate(Candidate solution) {
        this.vehicles = solution.vehicles;
        this.cost = solution.cost;
        this.plans = new ArrayList<List<PD_Action>>();
        for (List<PD_Action> list : solution.plans) {
            this.plans.add(new ArrayList<PD_Action>(list));
        }
        this.taskLists = new ArrayList<List<Task>>();
        for (List<PD_Action> list : solution.taskLists) {
            this.taskLists.add(new ArrayList<PD_Action>(list));
        }
    }

    public List<Candidate> ChooseNeighbours(Random random) {
        int task_id;
        List<Task> vehicle_tasks;
        int vid_i;
        ArrayList<Candidate> neighs = new ArrayList<Candidate>();
        int num_vehicles = this.vehicles.size();
        for (vid_i = 0; vid_i < num_vehicles; ++vid_i) {
            vehicle_tasks = this.taskLists.get(vid_i);
            if (vehicle_tasks.size() == 0) continue;
            task_id = 0;
            double task_weight = vehicle_tasks.get((int)task_id).weight;
            int vid_j = random.nextInt(num_vehicles);
            while (vid_i == vid_j || (double)this.vehicles.get(vid_j).getVehicle().capacity() < task_weight) {
                vid_j = random.nextInt(num_vehicles);
            }
            neighs.add(this.ChangingVehicle(random, task_id, vid_i, vid_j));
        }
        for (vid_i = 0; vid_i < num_vehicles; ++vid_i) {
            vehicle_tasks = this.taskLists.get(vid_i);
            if (vehicle_tasks.size() < 2) continue;
            task_id = random.nextInt(vehicle_tasks.size());
            neighs.add(this.ChangingTaskOrder(random, task_id, vid_i));
        }
        return neighs;
    }

    public static Candidate SelectInitialSolution(Random random, List<Vehicle2> vehicles, List<Task> tasks) {
        int num_vehicles = vehicles.size();
        ArrayList<List<PD_Action>> plans = new ArrayList<List<PD_Action>>();
        ArrayList<List<Task>> taskLists = new ArrayList<List<Task>>();
        ArrayList<Task> allTasks = new ArrayList<Task>(tasks);
        for (int i = 0; i < num_vehicles; ++i) {
            plans.add(new ArrayList());
            taskLists.add(new ArrayList());
        }
        double[] vehicle_capacities = new double[num_vehicles];
        int largest_vehicle = Candidate.MaxIndex(vehicle_capacities);
        for (Task t : allTasks) {
            List plan = (List)plans.get(largest_vehicle);
            List tasks_vehicle = (List)taskLists.get(largest_vehicle);
            plan.add(new PD_Action(true, t));
            plan.add(new PD_Action(false, t));
            tasks_vehicle.add(t);
        }
        double initial_cost = 0.0;
        for (int i = 0; i < vehicles.size(); ++i) {
            initial_cost += Candidate.ComputeCost(vehicles.get(i), (List)plans.get(i));
        }
        return new Candidate(vehicles, plans, taskLists, initial_cost);
    }

    public static int MaxIndex(double[] array) {
        int max_ind = 0;
        for (int index = 0; index < array.length; ++index) {
            if (!(array[index] > array[max_ind])) continue;
            max_ind = index;
        }
        return max_ind;
    }

    public static boolean SatisfiesWeightConstraints(List<PD_Action> plan, int vehicle_capacity) {
        for (PD_Action act : plan) {
            vehicle_capacity = act.is_pickup ? (vehicle_capacity -= act.task.weight) : (vehicle_capacity += act.task.weight);
            if (vehicle_capacity >= 0) continue;
            return false;
        }
        return true;
    }

    private static double ComputeCost(Vehicle2 v, List<PD_Action> plan) {
        double cost = 0.0;
        Topology.City current_city = v.getCurrentCity();
        for (PD_Action act : plan) {
            if (act.is_pickup) {
                cost += Measures.unitsToKM((long)current_city.distanceUnitsTo(act.task.pickupCity)) * (double)v.getVehicle().costPerKm();
                current_city = act.task.pickupCity;
                continue;
            }
            cost += Measures.unitsToKM((long)current_city.distanceUnitsTo(act.task.deliveryCity)) * (double)v.getVehicle().costPerKm();
            current_city = act.task.deliveryCity;
        }
        return cost;
    }

    public Candidate ChangingVehicle(Random random, int task_id, int vid_i, int vid_j) {
        Vehicle2 v_i = this.vehicles.get(vid_i);
        Vehicle2 v_j = this.vehicles.get(vid_j);
        List<Task> i_tasks_old = this.taskLists.get(vid_i);
        List<Task> j_tasks_old = this.taskLists.get(vid_j);
        Task t = i_tasks_old.get(task_id);
        ArrayList<Task> i_tasks_new = new ArrayList<Task>(i_tasks_old);
        i_tasks_new.remove(task_id);
        ArrayList<Task> j_tasks_new = new ArrayList<Task>(j_tasks_old);
        j_tasks_new.add(t);
        ArrayList<List<Task>> updated_taskLists = new ArrayList<List<Task>>(this.taskLists);
        updated_taskLists.set(vid_i, i_tasks_new);
        updated_taskLists.set(vid_j, j_tasks_new);
        List<PD_Action> i_plan_old = this.plans.get(vid_i);
        List<PD_Action> j_plan_old = this.plans.get(vid_j);
        ArrayList<PD_Action> i_plan_new = new ArrayList<PD_Action>(i_plan_old);
        int act_ind = 0;
        while (act_ind < i_plan_new.size()) {
            PD_Action act = (PD_Action)i_plan_new.get(act_ind);
            if (act.task == t) {
                i_plan_new.remove(act_ind);
                continue;
            }
            ++act_ind;
        }
        ArrayList<PD_Action> j_plan_new = new ArrayList<PD_Action>(j_plan_old);
        j_plan_new.add(0, new PD_Action(false, t));
        j_plan_new.add(0, new PD_Action(true, t));
        ArrayList<List<PD_Action>> updated_plans = new ArrayList<List<PD_Action>>(this.plans);
        updated_plans.set(vid_i, i_plan_new);
        updated_plans.set(vid_j, j_plan_new);
        double i_cost_old = Candidate.ComputeCost(v_i, i_plan_old);
        double j_cost_old = Candidate.ComputeCost(v_j, j_plan_old);
        double i_cost_new = Candidate.ComputeCost(v_i, i_plan_new);
        double j_cost_new = Candidate.ComputeCost(v_j, j_plan_new);
        double updated_cost = this.cost - i_cost_old + i_cost_new - j_cost_old + j_cost_new;
        return new Candidate(this.vehicles, updated_plans, updated_taskLists, updated_cost);
    }

    public Candidate ChangingTaskOrder(Random random, int task_id, int vid_i) {
        Vehicle2 v_i = this.vehicles.get(vid_i);
        List<Task> vehicle_tasks = this.taskLists.get(vid_i);
        Task t = vehicle_tasks.get(task_id);
        List<PD_Action> i_plan_old = this.plans.get(vid_i);
        ArrayList<PD_Action> i_plan_new = new ArrayList<PD_Action>(i_plan_old);
        int act_ind = 0;
        while (act_ind < i_plan_new.size()) {
            PD_Action act = (PD_Action)i_plan_new.get(act_ind);
            if (act.task == t) {
                i_plan_new.remove(act_ind);
                continue;
            }
            ++act_ind;
        }
        int vehicle_capacity = v_i.getVehicle().capacity();
        int pickup_location = 0;
        ArrayList<PD_Action> candidate_plan_pickup = new ArrayList<PD_Action>(i_plan_new);
        boolean done = false;
        while (!done) {
            pickup_location = random.nextInt(i_plan_new.size());
            candidate_plan_pickup = new ArrayList<PD_Action>(i_plan_new);
            candidate_plan_pickup.add(pickup_location, new PD_Action(true, t));
            if (!Candidate.SatisfiesWeightConstraints(candidate_plan_pickup, vehicle_capacity)) continue;
            done = true;
        }
        ArrayList<PD_Action> candidate_plan_delivery = new ArrayList<PD_Action>(candidate_plan_pickup);
        done = false;
        while (!done) {
            int delivery_location_offset = random.nextInt(i_plan_new.size() - pickup_location);
            int delivery_location = pickup_location + 1 + delivery_location_offset;
            candidate_plan_delivery = new ArrayList<PD_Action>(candidate_plan_pickup);
            candidate_plan_delivery.add(delivery_location, new PD_Action(false, t));
            if (!Candidate.SatisfiesWeightConstraints(candidate_plan_delivery, vehicle_capacity)) continue;
            done = true;
        }
        i_plan_new = new ArrayList<PD_Action>(candidate_plan_delivery);
        ArrayList<List<PD_Action>> updated_plans = new ArrayList<List<PD_Action>>(this.plans);
        updated_plans.set(vid_i, i_plan_new);
        double i_cost_old = Candidate.ComputeCost(v_i, i_plan_old);
        double i_cost_new = Candidate.ComputeCost(v_i, i_plan_new);
        double updated_cost = this.cost - i_cost_old + i_cost_new;
        return new Candidate(this.vehicles, updated_plans, this.taskLists, updated_cost);
    }

    public void addTask(Task t) {
        double[] vehicle_capacities = new double[this.vehicles.size()];
        int largest_vehicle = Candidate.MaxIndex(vehicle_capacities);
        this.plans.get(largest_vehicle).add(new PD_Action(true, t));
        this.plans.get(largest_vehicle).add(new PD_Action(false, t));
        this.taskLists.get(largest_vehicle).add(t);
        double new_cost = 0.0;
        for (int i = 0; i < this.vehicles.size(); ++i) {
            new_cost += Candidate.ComputeCost(this.vehicles.get(i), this.plans.get(i));
        }
        this.cost = new_cost;
    }

    public void updateCost() {
        Double newCost = 0.0;
        for (int i = 0; i < this.vehicles.size(); ++i) {
            newCost = newCost + Candidate.ComputeCost(this.vehicles.get(i), this.plans.get(i));
        }
        this.cost = newCost;
    }
}

