/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.tools.dijkstra;

import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.tools.dijkstra.PairOfCities;
import epfl.lia.logist.tools.dijkstra.Path;
import epfl.lia.logist.tools.dijkstra.ShortestPath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DijkstraEngine {
    public static final int INFINITE_DISTANCE = Integer.MAX_VALUE;
    private final Comparator shortestDistanceComparator = new Comparator(){

        public int compare(Object left, Object right) {
            if (left instanceof City && right instanceof City) {
                return this.compare((City)((Object)left), (City)((Object)right));
            }
            throw new ClassCastException("Not comparable");
        }

        private int compare(City left, City right) {
            int result = DijkstraEngine.this.getShortestDistance(left) - DijkstraEngine.this.getShortestDistance(right);
            return result == 0 ? left.compareTo((Object)right) : result;
        }
    };
    private final Topology mTopology;
    private final SortedSet unsettledNodes = new TreeSet(this.shortestDistanceComparator);
    private final Set settledNodes = new HashSet();
    private final Map<City, Integer> shortestDistances = new HashMap<City, Integer>();
    private final Map<City, City> predecessors = new HashMap<City, City>();
    private ArrayList<PairOfCities> pairs;
    private ShortestPath result;

    public DijkstraEngine(Topology topo, ArrayList<PairOfCities> pairs, ShortestPath result) {
        this.mTopology = topo;
        this.pairs = pairs;
        this.result = result;
    }

    private void init(City start) {
        this.settledNodes.clear();
        this.unsettledNodes.clear();
        this.shortestDistances.clear();
        this.predecessors.clear();
        this.setShortestDistance(start, 0);
        this.unsettledNodes.add(start);
    }

    public void execute(City start) {
        City u;
        this.init(start);
        while ((u = this.extractMin()) != null) {
            this.markSettled(u);
            City current = u;
            City currentPred = null;
            Path path = new Path(u);
            while ((currentPred = this.getPredecessor(current)) != null) {
                int dist = this.mTopology.getDistance(current, currentPred);
                Path p = path.add(currentPred, dist);
                PairOfCities pair = new PairOfCities(u, currentPred);
                this.result.put(pair, p);
                this.pairs.remove(pair);
                current = currentPred;
            }
            this.relaxNeighbors(u);
        }
    }

    private City extractMin() {
        if (this.unsettledNodes.isEmpty()) {
            return null;
        }
        City min = (City)((Object)this.unsettledNodes.first());
        this.unsettledNodes.remove((Object)min);
        return min;
    }

    private void relaxNeighbors(City u) {
        for (City v : this.mTopology.getDestinations(u)) {
            if (this.isSettled(v) || this.getShortestDistance(v) <= this.getShortestDistance(u) + this.mTopology.getDistance(u, v)) continue;
            this.setShortestDistance(v, this.getShortestDistance(u) + this.mTopology.getDistance(u, v));
            this.setPredecessor(v, u);
        }
    }

    private void markSettled(City u) {
        this.settledNodes.add(u);
    }

    private boolean isSettled(City v) {
        return this.settledNodes.contains((Object)v);
    }

    public int getShortestDistance(City city) {
        Integer d = this.shortestDistances.get((Object)city);
        return d == null ? Integer.MAX_VALUE : d;
    }

    private void setShortestDistance(City city, int distance) {
        this.unsettledNodes.remove((Object)city);
        this.shortestDistances.put(city, new Integer(distance));
        this.unsettledNodes.add(city);
    }

    public City getPredecessor(City city) {
        return this.predecessors.get((Object)city);
    }

    private void setPredecessor(City a, City b) {
        this.predecessors.put(a, b);
    }
}

