/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.tools;

import epfl.lia.logist.agent.AgentProperties;
import epfl.lia.logist.agent.plan.GDeliverAction;
import epfl.lia.logist.agent.plan.GMoveAction;
import epfl.lia.logist.agent.plan.GPickupAction;
import epfl.lia.logist.agent.plan.Plan;
import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.task.Task;
import ilog.concert.IloException;
import ilog.concert.IloIntVar;
import ilog.concert.IloStorable;
import ilog.solver.IlcAddable;
import ilog.solver.IlcGoal;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcIntVar;
import ilog.solver.IlcSolution;
import ilog.solver.IlcSolver;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimalCooperativePlanner {
    private ArrayList<Task> mTaskList = null;
    private ArrayList<AgentProperties> mVehicleList = null;
    private Topology mTopology = null;
    private LogManager mLogMgr = null;
    private int[] mCapacityArray = null;
    private int[] mCostPerKmArray = null;
    private int[] mTaskWeightArray = null;
    private int[] mHomeArray;
    private HashMap<City, Integer> mCityToCodeMapping;
    private HashMap<Integer, City> mCodeToCityMapping;
    private int mNumOfCities = 0;
    private int mNumOfTasks = 0;
    private int mNumOfVehicles = 0;
    private int[] mPickupCityOf;
    private int[] mDeliveryCityOf;
    private int[][] mDistanceTable;
    private int NULL_CITY;

    public OptimalCooperativePlanner(ArrayList<Task> taskList, ArrayList<AgentProperties> vehicleList, Topology topology) {
        this.mTaskList = taskList;
        this.mVehicleList = vehicleList;
        this.mTopology = topology;
        this.mLogMgr = LogManager.getInstance();
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing the optimal cooperative planner...");
        this.mCityToCodeMapping = new HashMap();
        this.mCodeToCityMapping = new HashMap();
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Creating city<->integer mapping tables...");
        this.initCodingForCities();
        this.NULL_CITY = this.mNumOfCities = this.mCityToCodeMapping.size();
        this.mNumOfTasks = this.getNumOfTasks();
        this.mNumOfVehicles = this.getNumOfVehicles();
        this.mCapacityArray = this.getCapacityArray();
        this.mCostPerKmArray = this.getCostPerKmArray();
        this.mHomeArray = this.getHomeArray();
        this.mTaskWeightArray = this.getTaskWeightArray();
        this.mPickupCityOf = new int[this.mNumOfTasks + this.mNumOfVehicles];
        this.mDeliveryCityOf = new int[this.mNumOfTasks];
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing task tables...");
        this.initTaskCities();
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing distances...");
        this.mDistanceTable = new int[this.mNumOfCities][this.mNumOfCities + 1];
        this.initDistances();
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Optimal cooperative planner initialization is finished !");
    }

    private void initCodingForCities() {
        HashMap<String, City> mapOfCities = this.mTopology.getCities();
        int i = 0;
        for (City c : mapOfCities.values()) {
            Integer _i = new Integer(i);
            this.mCityToCodeMapping.put(c, _i);
            this.mCodeToCityMapping.put(_i, c);
            ++i;
        }
    }

    private void initTaskCities() {
        int i = 0;
        while (i < this.mTaskList.size()) {
            Task t = this.mTaskList.get(i);
            City p = this.mTopology.getCity(t.getPickupCity());
            City d = this.mTopology.getCity(t.getDeliveryCity());
            this.mPickupCityOf[i] = this.mCityToCodeMapping.get((Object)p);
            this.mDeliveryCityOf[i] = this.mCityToCodeMapping.get((Object)d);
            ++i;
        }
        int k = 0;
        while (k < this.mNumOfVehicles) {
            this.mPickupCityOf[this.mNumOfTasks + k] = this.NULL_CITY;
            ++k;
        }
    }

    private int getNumOfTasks() {
        return this.mTaskList.size();
    }

    private int getNumOfVehicles() {
        return this.mVehicleList.size();
    }

    private int[] getCapacityArray() {
        int[] capacityArray = new int[this.mVehicleList.size()];
        int i = 0;
        while (i < this.mVehicleList.size()) {
            capacityArray[i] = (int)this.mVehicleList.get((int)i).Capacity;
            ++i;
        }
        return capacityArray;
    }

    private int[] getCostPerKmArray() {
        int[] costPerKmArray = new int[this.mVehicleList.size()];
        int i = 0;
        while (i < this.mVehicleList.size()) {
            costPerKmArray[i] = (int)this.mVehicleList.get((int)i).CostPerKm;
            ++i;
        }
        return costPerKmArray;
    }

    private int[] getTaskWeightArray() {
        int[] taskWeightArray = new int[this.mTaskList.size()];
        int i = 0;
        while (i < this.mTaskList.size()) {
            taskWeightArray[i] = (int)this.mTaskList.get(i).getWeight();
            ++i;
        }
        return taskWeightArray;
    }

    private int[] getHomeArray() {
        int[] homeArray = new int[this.mVehicleList.size()];
        int i = 0;
        while (i < this.mVehicleList.size()) {
            City c = this.mTopology.getCity(this.mVehicleList.get((int)i).Home);
            homeArray[i] = this.mCityToCodeMapping.get((Object)c);
            ++i;
        }
        return homeArray;
    }

    private void initDistances() {
        int i = 0;
        while (i < this.mNumOfCities) {
            this.mDistanceTable[i][i] = 0;
            int j = i + 1;
            while (j < this.mNumOfCities) {
                City ci = this.mCodeToCityMapping.get(i);
                City cj = this.mCodeToCityMapping.get(j);
                this.mDistanceTable[i][j] = (int)this.mTopology.shortestDistanceBetween(ci, cj);
                ++j;
            }
            this.mDistanceTable[i][this.mNumOfCities] = 0;
            ++i;
        }
    }

    public HashMap<String, Plan> plan() {
        IlcSolution sol;
        IlcIntVar[] nextTask;
        HashMap<String, Plan> plans;
        long startTime;
        block27: {
            int j;
            int k;
            startTime = System.currentTimeMillis();
            plans = new HashMap<String, Plan>();
            IlcSolver s = new IlcSolver();
            nextTask = new IlcIntVar[this.mNumOfTasks + this.mNumOfVehicles];
            int i = 0;
            while (i < nextTask.length) {
                nextTask[i] = s.intVar(0, this.mNumOfTasks + this.mNumOfVehicles - 1, "nextTask[" + i + "]");
                ++i;
            }
            IlcIntVar[] vehicle = new IlcIntVar[this.mNumOfTasks + this.mNumOfVehicles];
            int i2 = 0;
            while (i2 < vehicle.length) {
                vehicle[i2] = s.intVar(0, this.mNumOfVehicles - 1, "vehicle[" + i2 + "]");
                ++i2;
            }
            IlcIntVar[] time = new IlcIntVar[this.mNumOfTasks + 2 * this.mNumOfVehicles];
            int i3 = 0;
            while (i3 < time.length) {
                time[i3] = s.intVar(0, this.mNumOfTasks + 1, "time[" + i3 + "]");
                ++i3;
            }
            i3 = 0;
            while (i3 < this.mNumOfTasks) {
                k = 0;
                while (k < this.mNumOfVehicles) {
                    if (this.mTaskWeightArray[i3] > this.mCapacityArray[k]) {
                        s.add((IlcAddable)s.neq((IlcIntExpr)vehicle[i3], k));
                    }
                    ++k;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < this.mNumOfTasks) {
                s.add((IlcAddable)s.neq((IlcIntExpr)nextTask[i3], i3));
                ++i3;
            }
            int k2 = 0;
            while (k2 < this.mNumOfVehicles) {
                j = 0;
                while (j < this.mNumOfVehicles) {
                    if (j != k2) {
                        s.add((IlcAddable)s.neq((IlcIntExpr)nextTask[this.mNumOfTasks + k2], this.mNumOfTasks + j));
                    }
                    ++j;
                }
                ++k2;
            }
            s.add((IlcAddable)s.allDiff((IlcIntExpr[])nextTask));
            i3 = 0;
            while (i3 < this.mNumOfTasks + this.mNumOfVehicles) {
                s.add((IlcAddable)s.eq((IlcIntExpr)vehicle[i3], s.element((IlcIntExpr[])vehicle, (IlcIntExpr)nextTask[i3])));
                ++i3;
            }
            k2 = 0;
            while (k2 < this.mNumOfVehicles) {
                s.add((IlcAddable)s.eq((IlcIntExpr)vehicle[this.mNumOfTasks + k2], k2));
                ++k2;
            }
            i3 = 0;
            while (i3 < this.mNumOfTasks + this.mNumOfVehicles) {
                j = 0;
                while (j < this.mNumOfTasks) {
                    s.add((IlcAddable)s.imply(s.eq((IlcIntExpr)nextTask[i3], j), s.eq((IlcIntExpr)time[j], s.sum((IlcIntExpr)time[i3], 1))));
                    ++j;
                }
                k = 0;
                while (k < this.mNumOfVehicles) {
                    s.add((IlcAddable)s.imply(s.eq((IlcIntExpr)nextTask[i3], this.mNumOfTasks + k), s.eq((IlcIntExpr)time[this.mNumOfTasks + this.mNumOfVehicles + k], s.sum((IlcIntExpr)time[i3], 1))));
                    ++k;
                }
                ++i3;
            }
            k2 = 0;
            while (k2 < this.mNumOfVehicles) {
                s.add((IlcAddable)s.eq((IlcIntExpr)time[this.mNumOfTasks + k2], 0));
                ++k2;
            }
            i3 = 0;
            while (i3 < this.mNumOfTasks) {
                IlcIntExpr stopInd = s.sum(this.mNumOfTasks + this.mNumOfVehicles, (IlcIntExpr)vehicle[i3]);
                s.add((IlcAddable)s.lt((IlcIntExpr)time[i3], s.element((IlcIntExpr[])time, stopInd)));
                ++i3;
            }
            IlcIntExpr totalDist = s.constant(0);
            int i4 = 0;
            while (i4 < this.mNumOfTasks) {
                totalDist = s.sum(totalDist, s.prod(s.element(this.mCostPerKmArray, (IlcIntExpr)vehicle[i4]), s.sum(this.mDistanceTable[this.mPickupCityOf[i4]][this.mDeliveryCityOf[i4]], s.element(this.mDistanceTable[this.mDeliveryCityOf[i4]], s.element(this.mPickupCityOf, (IlcIntExpr)nextTask[i4])))));
                ++i4;
            }
            i4 = 0;
            while (i4 < this.mNumOfVehicles) {
                totalDist = s.sum(totalDist, s.prod(this.mCostPerKmArray[i4], s.element(this.mDistanceTable[this.mHomeArray[i4]], s.element(this.mPickupCityOf, (IlcIntExpr)nextTask[this.mNumOfTasks + i4]))));
                ++i4;
            }
            s.add((IlcAddable)s.minimize(totalDist));
            sol = s.solution();
            sol.add((IloStorable[])nextTask);
            sol.add((IloStorable[])vehicle);
            IlcGoal g1 = s.generate((IlcIntExpr[])nextTask);
            IlcGoal g = s.and(g1, s.storeSolution(sol));
            s.newSearch(g);
            while (s.next()) {
            }
            s.restartSearch();
            boolean solFound = s.next();
            if (solFound) break block27;
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, "There exists no feasible plan !");
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Planning took " + (System.currentTimeMillis() - startTime) + " milliseconds !");
            return null;
        }
        try {
            int k = 0;
            while (k < this.mNumOfVehicles) {
                AgentProperties ap = this.mVehicleList.get(k);
                Plan plan = new Plan();
                City currentCity = this.mTopology.getCity(ap.Home);
                double distance = 0.0;
                int codeNextTask = this.mNumOfTasks + k;
                while ((codeNextTask = sol.getValue((IloIntVar)nextTask[codeNextTask])) < this.mNumOfTasks) {
                    City nextCity;
                    City nextDestination = this.mCodeToCityMapping.get(this.mPickupCityOf[codeNextTask]);
                    while (!currentCity.match(nextDestination)) {
                        nextCity = this.mTopology.moveOnShortestPath(currentCity, nextDestination);
                        distance = this.mTopology.shortestDistanceBetween(currentCity, nextCity);
                        plan.addAction(new GMoveAction(nextCity, distance));
                        currentCity = nextCity;
                    }
                    Task t = this.mTaskList.get(codeNextTask);
                    plan.addAction(new GPickupAction(t));
                    nextDestination = this.mCodeToCityMapping.get(this.mDeliveryCityOf[codeNextTask]);
                    while (!currentCity.match(nextDestination)) {
                        nextCity = this.mTopology.moveOnShortestPath(currentCity, nextDestination);
                        distance = this.mTopology.shortestDistanceBetween(currentCity, nextCity);
                        plan.addAction(new GMoveAction(nextCity, distance));
                        currentCity = nextCity;
                    }
                    plan.addAction(new GDeliverAction(t));
                }
                this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "[" + ap.Name + "] " + plan);
                plans.put(ap.Name, plan);
                ++k;
            }
        }
        catch (IloException error) {
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_ERROR, "CooperativePlanner: plan(): Error occured: " + (Object)((Object)error));
        }
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Planning took " + (System.currentTimeMillis() - startTime) + " milliseconds !");
        return plans;
    }
}

