/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.task.distribution;

import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.task.ProbabilityDistribution;
import epfl.lia.logist.task.Task;
import epfl.lia.logist.task.distribution.ITaskDistribution;
import epfl.lia.logist.tools.Pair;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteTaskDistribution
implements ITaskDistribution {
    private ArrayList<Task> mListOfTasks = null;
    private ArrayList<Task> mListOfDeletedTasks = null;
    private ProbabilityDistribution mProbDistribution = null;

    public DiscreteTaskDistribution(ArrayList<Task> al) {
        this.mListOfTasks = al;
        this.mListOfDeletedTasks = new ArrayList();
        this.initializeDistribution();
    }

    private void initializeDistribution() {
        Pair<City> pairOfCities;
        HashMap<Pair<City>, Double> mProbMap = new HashMap<Pair<City>, Double>();
        HashMap<Pair<City>, Double> mRewardMap = new HashMap<Pair<City>, Double>();
        Topology topology = Topology.getInstance();
        for (Task t : this.mListOfTasks) {
            City pickupCity = topology.getCity(t.getPickupCity());
            City deliveryCity = topology.getCity(t.getDeliveryCity());
            pairOfCities = new Pair<City>(pickupCity, deliveryCity);
            mProbMap.put(pairOfCities, 1.0);
            mRewardMap.put(pairOfCities, t.getRewardPerKm());
        }
        for (City cs : topology.getCities().values()) {
            for (City cd : topology.getCities().values()) {
                pairOfCities = new Pair<City>(cs, cd);
                if (mProbMap.containsKey(pairOfCities)) continue;
                mProbMap.put(pairOfCities, 0.0);
                mRewardMap.put(pairOfCities, 0.0);
            }
        }
        this.mProbDistribution = new ProbabilityDistribution(mProbMap, mRewardMap);
    }

    @Override
    public boolean hasMoreTasks() {
        return this.mListOfTasks.size() > 0;
    }

    @Override
    public Task next() {
        Task t = null;
        if (this.mListOfTasks.size() > 0) {
            int iIndex = (int)(Math.random() * (double)this.mListOfTasks.size());
            t = this.mListOfTasks.remove(iIndex);
            this.mListOfDeletedTasks.add(t);
        }
        return t;
    }

    @Override
    public void reset() {
        ArrayList<Task> temp = this.mListOfTasks;
        this.mListOfTasks = this.mListOfDeletedTasks;
        this.mListOfDeletedTasks = temp;
    }

    @Override
    public ProbabilityDistribution getProbabilityDistribution() {
        return this.mProbDistribution;
    }
}

