/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.task;

import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.task.Task;
import epfl.lia.logist.task.TaskDescriptor;
import epfl.lia.logist.task.TaskDistributionDescriptor;
import epfl.lia.logist.task.TaskgenDescriptor;
import epfl.lia.logist.task.distribution.DiscreteTaskDistribution;
import epfl.lia.logist.task.distribution.ITaskDistribution;
import epfl.lia.logist.task.distribution.ProbabilisticTaskDistribution;
import epfl.lia.logist.tools.Convert;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskGenerator {
    private ITaskDistribution mTaskDistribution = null;
    private int mBatchSize = 10;
    private int mMaxAllocatable = -1;
    private int mGeneratedTasks = 0;

    public TaskGenerator(TaskgenDescriptor td) throws Exception {
        this.createTaskDistribution(td.Distribution);
        this.mMaxAllocatable = Convert.toInt((String)td.Props.get("max-allocatable"), -1);
        this.mBatchSize = Convert.toInt((String)td.Props.get("batch-size"), 10);
        if (this.mMaxAllocatable <= 0) {
            this.mMaxAllocatable = -1;
        }
        if (this.mBatchSize <= 0) {
            this.mBatchSize = 1;
        }
        this.mGeneratedTasks = this.mMaxAllocatable;
    }

    private void createTaskDistribution(TaskDistributionDescriptor tdd) throws Exception {
        String lDistributionType = tdd.Type;
        if (lDistributionType.equals("discrete")) {
            this.createDiscreteDistribution(tdd);
        } else if (lDistributionType.equals("probabilistic")) {
            this.createProbabilisticDistribution(tdd);
        } else {
            throw new Exception("Distribution type '" + tdd.Type + "' is cannot be handled !!!");
        }
    }

    private void createDiscreteDistribution(TaskDistributionDescriptor tdd) throws Exception {
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Creating a discrete task distribution");
        if (tdd.TaskDescriptorList == null || tdd.TaskDescriptorList != null && tdd.TaskDescriptorList.size() <= 0) {
            throw new Exception("No task was defined for current configuration");
        }
        ArrayList<Task> lTasks = new ArrayList<Task>();
        for (TaskDescriptor td : tdd.TaskDescriptorList) {
            lTasks.add(new Task(td));
        }
        this.mTaskDistribution = new DiscreteTaskDistribution(lTasks);
    }

    private void createProbabilisticDistribution(TaskDistributionDescriptor tdd) throws Exception {
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Creating a probabilistic task distribution");
        this.mTaskDistribution = new ProbabilisticTaskDistribution(tdd);
    }

    public void reset() {
        if (this.mTaskDistribution != null) {
            this.mTaskDistribution.reset();
            this.mGeneratedTasks = this.mMaxAllocatable;
        }
    }

    public ArrayList<Task> generate() {
        ArrayList<Task> lTaskList = new ArrayList<Task>();
        int i = 0;
        while (i < this.mBatchSize && this.mGeneratedTasks != 0) {
            if (!this.mTaskDistribution.hasMoreTasks()) break;
            lTaskList.add(this.mTaskDistribution.next());
            ++i;
            --this.mGeneratedTasks;
        }
        return lTaskList;
    }

    public ITaskDistribution getDistribution() {
        return this.mTaskDistribution;
    }

    public int getMaxAllocatable() {
        return this.mMaxAllocatable;
    }

    public int getBatchSize() {
        return this.mBatchSize;
    }

    public boolean hasMoreTasks() {
        return this.mGeneratedTasks != 0 && this.mTaskDistribution.hasMoreTasks();
    }
}

