/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.core.entry;

import epfl.lia.logist.config.Configuration;
import epfl.lia.logist.config.ConfigurationManager;
import epfl.lia.logist.core.Simulation;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import java.io.File;
import java.io.FileNotFoundException;

public class SimulationEntry {
    private String[] mArgList = null;
    private String mConfigName = null;
    private String mConfigFile = null;

    public SimulationEntry(String[] args) {
        this.mArgList = args;
    }

    public void start() throws Exception {
        LogManager lLog = LogManager.getInstance();
        Configuration lConfig = null;
        lLog.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Platform started...");
        if (!this.parseArguments(this.mArgList)) {
            return;
        }
        if (this.mConfigFile == null) {
            throw new Exception("A configuration file must be defined !");
        }
        File lCfgFile = new File(this.mConfigFile);
        if (!lCfgFile.exists()) {
            throw new FileNotFoundException(this.mConfigFile);
        }
        lLog.log("main", LogSeverityEnum.LSV_INFO, "Reading the configuration file ...");
        ConfigurationManager lConfigMgr = new ConfigurationManager(lCfgFile);
        lConfig = this.mConfigName == null ? lConfigMgr.getConfigurationByDefault() : lConfigMgr.getConfigurationByName(this.mConfigName);
        if (lConfig == null) {
            throw new Exception("No suitable configuration could be found !");
        }
        Simulation lSimulation = new Simulation(lConfig);
        lSimulation.run();
    }

    private boolean parseArguments(String[] args) {
        if (args.length == 0) {
            this.displayUsage();
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--version")) {
                this.displayVersion();
                return false;
            }
            if (args[i].equals("--help")) {
                this.displayUsage();
                return false;
            }
            if (!args[i].startsWith("--")) {
                if (this.mConfigFile == null) {
                    this.mConfigFile = args[i];
                } else if (this.mConfigName == null) {
                    this.mConfigName = args[i];
                }
            }
            ++i;
        }
        return true;
    }

    private void displayVersion() {
        System.out.println("EPFL-LIA Logist Simulation Platform");
        System.out.println("Copyright(C) 2007 by EPFL-LIA");
        System.out.println("Version 1.0.67, running on " + System.getProperty("os.name") + " - " + System.getProperty("os.arch"));
    }

    private void displayUsage() {
        System.out.println("Usage: logist [-options] config default");
        System.out.println("\nwhere options include:");
        System.out.println("\t--version\n\t\tprint the current version of the platform");
        System.out.println("\t--help\n\t\tdisplay this message");
        System.out.println("\tconfig\n\t\tthe name of the configuration file");
        System.out.println("\tdefault\n\t\tthe name of the configuration");
    }
}

