/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent.state.auction;

import epfl.lia.logist.agent.AgentProfile;
import epfl.lia.logist.agent.AgentStateEnum;
import epfl.lia.logist.agent.state.AgentState;
import epfl.lia.logist.agent.state.CompanyAgentState;
import epfl.lia.logist.messaging.action.Action;
import epfl.lia.logist.messaging.action.ActionTypeEnum;
import epfl.lia.logist.messaging.action.BidAction;
import epfl.lia.logist.messaging.signal.AskBidSignal;
import epfl.lia.logist.messaging.signal.AuctionEndSignal;
import epfl.lia.logist.messaging.signal.AuctionLostSignal;
import epfl.lia.logist.messaging.signal.AuctionNotificationObject;
import epfl.lia.logist.messaging.signal.AuctionStartSignal;
import epfl.lia.logist.messaging.signal.AuctionWonSignal;
import epfl.lia.logist.messaging.signal.Signal;
import epfl.lia.logist.task.Task;
import epfl.lia.logist.task.TaskDescriptor;
import epfl.lia.logist.task.TaskManager;
import epfl.lia.logist.tools.AID;
import epfl.lia.logist.tools.TimeoutBarrier;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuctionCompanyState
extends CompanyAgentState {
    private HashMap<AID, Double> mAuctionBids = null;
    private long mStartTime = 0L;
    private ArrayList<Task> mListOfTasks = null;
    private TimeoutBarrier<AID> mBarrier = null;
    private int mRegisteredBids = 0;
    private TaskDescriptor mCurrentTaskDescriptor = null;
    private Task mCurrentTask = null;

    public AuctionCompanyState(AgentProfile ap, AgentState as) {
        super(ap, as);
    }

    @Override
    public void execute(Action<?> action) {
        switch (this.mState) {
            case AS_SETUP: {
                this.handleSetupState();
                break;
            }
            case AS_IDLE: {
                this.handleIdleState();
                break;
            }
            case AS_AUCTION_START: {
                this.handleAuctionStartState();
                break;
            }
            case AS_AUCTION_ITEM: {
                this.handleAuctionItemState(action);
                break;
            }
            case AS_AUCTION_END: {
                this.handleAuctionTerminateState();
                break;
            }
        }
    }

    private void handleSetupState() {
        this.info("[Auction] System is setting up....");
        if (this.mListOfTasks == null) {
            this.mListOfTasks = new ArrayList();
        }
        if (this.mAuctionBids == null) {
            this.mAuctionBids = new HashMap();
        }
        this.mState = AgentStateEnum.AS_IDLE;
    }

    private void handleIdleState() {
        this.info("[Auction] System is in idle state....");
        this.mState = AgentStateEnum.AS_AUCTION_START;
    }

    @Override
    public void notifyTaskBatchCreation() {
        System.out.println("->>>>>>> A new batch was created !!!!");
        if (this.mState == AgentStateEnum.AS_FINISHED) {
            this.mState = AgentStateEnum.AS_IDLE;
        }
    }

    private void handleAuctionStartState() {
        this.info("[Auction] Initializing the auction...");
        if (this.mBarrier == null) {
            this.mBarrier = new TimeoutBarrier();
        }
        this.mBarrier.reset();
        for (AgentProfile ap : this.mProfile.getChildren()) {
            this.info("Registering agent " + ap.getName() + "[" + ap.getID() + "] against barrier...");
            this.mBarrier.register(ap.getID());
        }
        TaskManager taskMgr = TaskManager.getInstance();
        ArrayList<Task> lTaskList = taskMgr.getTaskList(false);
        this.debug("[Auction] List of tasks to auction:");
        this.mListOfTasks.clear();
        for (Task t : lTaskList) {
            this.debug("\t" + t.toString());
            this.mListOfTasks.add(t);
        }
        this.mAuctionBids.clear();
        for (AgentProfile ap : this.mProfile.getChildren()) {
            this.mAuctionBids.put(ap.getID(), 0.0);
            AuctionStartSignal signal = new AuctionStartSignal(this.getObjectID(), ap.getAgent().getObjectID());
            ap.getState().notifySignal(signal);
            this.mDispatcher.post(signal);
        }
        this.displayAuctionList();
        this.mState = AgentStateEnum.AS_AUCTION_ITEM;
        this.mPhase = AgentStateEnum.AS_PHASE1;
    }

    private void handleAuctionItemState(Action<?> action) {
        switch (this.mPhase) {
            case AS_PHASE1: {
                this.info("-----------------------------------------------------");
                this.prepareNextItemToAuction();
                this.mBarrier.start(this.mProfile.getGlobals().AuctionTimeout);
                this.mPhase = AgentStateEnum.AS_PHASE2;
                break;
            }
            case AS_PHASE2: {
                if (action != null && action.getType() == ActionTypeEnum.AMT_BID) {
                    this.registerAuctionBid((BidAction)action);
                }
                if (!this.mBarrier.timeout() && this.mRegisteredBids != this.mAuctionBids.size()) break;
                this.info("mRegisteredBids==" + this.mAuctionBids.size());
                if (this.mRegisteredBids == this.mAuctionBids.size()) {
                    this.info("All agents finished bidding !!!");
                } else {
                    this.info("The barrier timed out...");
                }
                this.mPhase = AgentStateEnum.AS_PHASE3;
                break;
            }
            case AS_PHASE3: {
                this.displayAuctionList();
                if (this.mBarrier.blocked() && !this.mBarrier.timeout() && this.mRegisteredBids != this.mAuctionBids.size()) break;
                this.assignTaskWinnerAndLoosers();
            }
        }
    }

    private void handleAuctionTerminateState() {
        this.info("Auction has ended !!!");
        for (AgentProfile ap : this.mProfile.getChildren()) {
            AuctionEndSignal signal = new AuctionEndSignal(this.getObjectID(), ap.getAgent().getObjectID());
            ap.getState().notifySignal(signal);
            this.mDispatcher.post(signal);
        }
        this.mState = AgentStateEnum.AS_FINISHED;
    }

    private void prepareNextItemToAuction() {
        this.mCurrentTask = this.getNextItemToAuction();
        assert (this.mCurrentTask != null);
        this.mCurrentTaskDescriptor = this.mCurrentTask.getDescriptor();
        this.mRegisteredBids = 0;
        this.info("Auctionning task: <task from='" + this.mCurrentTaskDescriptor.PickupCity + "' to='" + this.mCurrentTaskDescriptor.DeliveryCity + "' />");
        this.postAskBidSignalToEveryOne(this.mCurrentTaskDescriptor);
    }

    private Task getNextItemToAuction() {
        if (this.mListOfTasks.isEmpty()) {
            return null;
        }
        int iRandomTaskIndex = (int)(Math.random() * (double)this.mListOfTasks.size());
        return this.mListOfTasks.remove(iRandomTaskIndex);
    }

    private void postAskBidSignalToEveryOne(TaskDescriptor tdd) {
        for (AgentProfile ap : this.mProfile.getChildren()) {
            AskBidSignal signal = new AskBidSignal(this.getObjectID(), ap.getAgent().getObjectID(), tdd);
            ap.getState().notifySignal(signal);
            this.mDispatcher.post(signal);
        }
    }

    private void displayAuctionList() {
        this.info("List of auction bids: ");
        String strResult = "B: ";
        for (AID aid : this.mAuctionBids.keySet()) {
            strResult = this.mAuctionBids.containsKey(aid) ? String.valueOf(strResult) + this.mAuctionBids.get(aid) + " " : String.valueOf(strResult) + "#inf ";
        }
        this.info(strResult);
    }

    private void assignTaskWinnerAndLoosers() {
        ArrayList<Double> arrayOfBids = new ArrayList<Double>();
        double dblMinValue = Double.MAX_VALUE;
        AgentProfile rfWinnerAgent = null;
        for (AgentProfile ap : this.mProfile.getChildren()) {
            Double dblBidValue = this.mAuctionBids.get(ap.getID());
            if (dblBidValue == null) {
                dblBidValue = 0.0;
            }
            if (dblBidValue < dblMinValue) {
                dblMinValue = dblBidValue;
                rfWinnerAgent = ap;
            }
            arrayOfBids.add(dblBidValue);
        }
        if (rfWinnerAgent != null) {
            this.info("[Auction] " + rfWinnerAgent.getName() + " is the winner " + "with a bid value of " + dblMinValue + "...");
        }
        this.mCurrentTask.setRewardPerKm(dblMinValue);
        this.info("[Auction] Assigning winners and loosers...");
        Signal signal = null;
        AuctionNotificationObject notificationObject = new AuctionNotificationObject();
        notificationObject.Bids = new Double[arrayOfBids.size()];
        arrayOfBids.toArray(notificationObject.Bids);
        notificationObject.Task = this.mCurrentTaskDescriptor;
        for (AgentProfile ap : this.mProfile.getChildren()) {
            if (ap == rfWinnerAgent) {
                this.info("[Auction] Dispatching notification to the winner !");
                signal = new AuctionWonSignal(this.getObjectID(), rfWinnerAgent.getAgent().getObjectID(), (AuctionNotificationObject)notificationObject.clone());
            } else {
                this.info("[Auction] Dispatching notification to the looser!");
                signal = new AuctionLostSignal(this.getObjectID(), ap.getAgent().getObjectID(), (AuctionNotificationObject)notificationObject.clone());
            }
            this.mDispatcher.post(signal);
            ap.getState().notifySignal(signal);
        }
        if (this.hasMoreTasksToAuction()) {
            this.mPhase = AgentStateEnum.AS_PHASE1;
        } else {
            this.mPhase = AgentStateEnum.AS_PHASE1;
            this.mState = AgentStateEnum.AS_AUCTION_END;
        }
    }

    private boolean hasMoreTasksToAuction() {
        return this.mListOfTasks.size() > 0;
    }

    private void registerAuctionBid(BidAction action) {
        AID bidderID = action.getSenderID();
        Double bidderValue = (Double)action.getMessage();
        this.info("Registering bid for agent " + action.getSenderID() + ": " + action.getMessage());
        if (bidderValue == null) {
            bidderValue = 0.0;
        }
        this.mAuctionBids.put(bidderID, bidderValue);
        ++this.mRegisteredBids;
    }
}

