/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent;

import epfl.lia.logist.agent.AgentDescriptor;
import epfl.lia.logist.agent.AgentProfile;
import epfl.lia.logist.agent.AgentTypeEnum;
import epfl.lia.logist.config.Configuration;
import epfl.lia.logist.core.IService;
import epfl.lia.logist.core.listeners.IAgentListener;
import epfl.lia.logist.exception.AgentCreationException;
import epfl.lia.logist.exception.AgentPopulationException;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.task.TaskManager;
import epfl.lia.logist.tools.AID;
import epfl.lia.logist.tools.LogistGlobals;
import epfl.lia.logist.tools.TimeoutBarrier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentManager
implements IService {
    private HashMap<AID, AgentProfile> mMapOfProfiles = null;
    private ArrayList<AID> mListOfKills = null;
    private static AgentManager msSingleton = null;
    private LogManager mLogMgr = null;
    private ArrayList<IAgentListener> mListeners = null;
    private TimeoutBarrier<AID> mBarrier = new TimeoutBarrier();
    private LogistGlobals mGlobals = null;
    private TaskManager mTaskMgr = null;

    public AgentManager() {
        if (msSingleton == null) {
            msSingleton = this;
        }
        this.mLogMgr = LogManager.getInstance();
        this.mMapOfProfiles = new HashMap();
        this.mListeners = new ArrayList();
        this.mListOfKills = new ArrayList();
    }

    @Override
    public void init() {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing the agent management service...");
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initialisation of the agent management is complete.");
    }

    @Override
    public void shutdown() {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Shutting the agent management service down...");
        this.killAllAgents();
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Agent management service is shutting down...");
    }

    @Override
    public void setup(Configuration cfg, LogistGlobals lg) throws Exception {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Beginning creation of the individual agents...");
        this.mGlobals = lg;
        this.createAgentProfile(cfg.Agents.RootAgent, null);
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "All agents were successfully created !");
        if (this.mMapOfProfiles.size() == 0) {
            throw new AgentPopulationException("There exist no agent in simulation.");
        }
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Agent creation and initialization is complete.");
        this.mTaskMgr = TaskManager.getInstance();
    }

    private void createAgentProfile(AgentDescriptor ad, AgentProfile parent) throws Exception {
        if (ad == null) {
            throw new AgentCreationException("No agent descriptor found.");
        }
        if (!ad.Active) {
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, "Agent '" + ad.Name + "' is not active. Not creating it !");
            return;
        }
        AgentProfile ap = new AgentProfile(this.mGlobals);
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "Spawning named agent '" + ad.Name + "'...");
        if (ap == null) {
            throw new AgentCreationException("No profile could be created. Please raise the VM memory amount!");
        }
        ap.create(ad, parent);
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "Spawning children agents for '" + ad.Name + "'...");
        if (ap.getType() == AgentTypeEnum.VEHICLE) {
            for (IAgentListener acl : this.mListeners) {
                acl.onAgentAddition(ap);
            }
        }
        if (ad.Children != null) {
            for (AgentDescriptor adc : ad.Children) {
                this.createAgentProfile(adc, ap);
            }
        }
        this.mMapOfProfiles.put(ap.getID(), ap);
    }

    @Override
    public void reset(int round) {
        this.resetAllAgents(round);
    }

    public void addListener(IAgentListener acl) {
        this.mListeners.add(acl);
    }

    public void initAllAgents() {
        this.mBarrier.reset();
        for (AgentProfile ap : this.mMapOfProfiles.values()) {
            ap.init();
            this.mBarrier.register(ap.getID());
        }
        this.mBarrier.start(this.mGlobals.InitTimeout);
    }

    public void notifyTaskBatchCreation() {
        for (AgentProfile ap : this.mMapOfProfiles.values()) {
            ap.getState().notifyTaskBatchCreation();
        }
    }

    public void killAllAgents() {
        this.mBarrier.reset();
        for (AgentProfile ap : this.mMapOfProfiles.values()) {
            ap.kill();
            this.mBarrier.register(ap.getID());
        }
        this.mBarrier.start(this.mGlobals.KillTimeout);
    }

    public void resetAllAgents(int round) {
        this.mBarrier.reset();
        for (AgentProfile ap : this.mMapOfProfiles.values()) {
            ap.reset(round);
            this.mBarrier.register(ap.getID());
        }
        this.mBarrier.start(this.mGlobals.ResetTimeout);
    }

    public void removeAgent(AgentProfile ap) {
        ap.kill();
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Agent '" + ap.getName() + "' was scheduled for killing !");
        this.mListOfKills.add(ap.getID());
    }

    public void verifyScheduledAgents() {
        if (this.mListOfKills.size() > 0) {
            for (AID aid : this.mListOfKills) {
                this.mMapOfProfiles.remove(aid);
                this.mTaskMgr.releaseTasks(aid);
                this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Agent scheduled to kill has been deleted !");
            }
            this.mListOfKills.clear();
        }
    }

    public static AgentManager getInstance() {
        return msSingleton;
    }

    public TimeoutBarrier<AID> getBarrier() {
        return this.mBarrier;
    }

    public AgentProfile getProfile(AID agentID) {
        return this.mMapOfProfiles.get(agentID);
    }

    public Collection<AgentProfile> getProfileList() {
        return this.mMapOfProfiles.values();
    }

    public int getAgentCount() {
        return this.mMapOfProfiles.size();
    }

    public String toString() {
        return "Agent management service";
    }
}

