/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.util.ArrayList;
import java.util.List;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.NetUtilities;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.RepastException;
import uchicago.src.sim.util.SimUtilities;

public class RolfeNet {
    Class nodeClass;
    Class edgeClass;
    int nNodes = -1;
    double density = -1.0;
    double clustring = -1.0;
    double reciProb = -1.0;
    int steps = -1;
    NetUtilities netUtil = new NetUtilities();

    public RolfeNet() {
    }

    public RolfeNet(Class clazz, Class clazz2) {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
    }

    public RolfeNet(Class clazz, Class clazz2, int n) {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
        this.nNodes = n;
    }

    public RolfeNet(Class clazz, Class clazz2, int n, double d, double d2, double d3, int n2) {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
        this.nNodes = n;
        this.density = d;
        this.clustring = d2;
        this.reciProb = d3;
        this.steps = n2;
    }

    public Class getNodeClass() {
        return this.nodeClass;
    }

    public void setNodeClass(Class clazz) {
        this.nodeClass = clazz;
    }

    public Class getEdgeClass() {
        return this.edgeClass;
    }

    public void setEdgeClass(Class clazz) {
        this.edgeClass = clazz;
    }

    public int getSize() {
        return this.nNodes;
    }

    public void setSize(int n) {
        this.nNodes = n;
    }

    public double getDensity() {
        return this.density;
    }

    public void setDensity(double d) {
        this.density = d;
    }

    public double getClustring() {
        return this.clustring;
    }

    public void setClustring(double d) {
        this.clustring = d;
    }

    public double getReciProb() {
        return this.reciProb;
    }

    public void setReciProb(double d) {
        this.reciProb = d;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int n) {
        this.steps = n;
    }

    public ArrayList createRolfeNet() throws IllegalAccessException, InstantiationException {
        int n;
        Object object;
        if (this.nodeClass == null || this.edgeClass == null) {
            object = "Unable to construct randomDensityNetwork: nodeClass or edgeClass was not set.";
            RepastException repastException = new RepastException((String)object);
            SimUtilities.showError((String)object, repastException);
        }
        object = new ArrayList(this.nNodes);
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.nNodes; ++n) {
            ((ArrayList)object).add((Node)this.nodeClass.newInstance());
        }
        for (n = 0; n < this.steps; ++n) {
            block8: {
                Edge edge;
                Object object2;
                Node node;
                Node node2;
                block7: {
                    node = node2 = (Node)((ArrayList)object).get(Random.uniform.nextIntFromTo(0, this.nNodes - 1));
                    while (node.equals(node2)) {
                        node = (Node)((ArrayList)object).get(Random.uniform.nextIntFromTo(0, this.nNodes - 1));
                    }
                    n3 = NetUtilities.getNumDirectTriads(node2, node);
                    n2 = NetUtilities.getIJTie(node, node2);
                    d = n3 <= 2 ? -0.1 : 0.1;
                    double d3 = 1.0 / (Math.pow(Math.E, NetUtilities.getOutDegree(node2) - 5) + 1.0);
                    d2 = (1.0 - (1.0 - this.density) * Math.pow(Math.E, -(this.clustring + d) * (double)n3 - this.reciProb * (double)n2)) * d3 + 0.5 * (double)NetUtilities.getIJTie(node2, node);
                    if (!(Random.uniform.nextDoubleFromTo(0.0, 1.0) < d2)) break block7;
                    if (NetUtilities.getIJTie(node2, node) < 1) {
                        object2 = (Edge)this.edgeClass.newInstance();
                        object2.setFrom(node2);
                        object2.setTo(node);
                        node2.addOutEdge((Edge)object2);
                        node.addInEdge((Edge)object2);
                    }
                    if (NetUtilities.getIJTie(node2, node) >= 1) break block8;
                    object2 = (Edge)this.edgeClass.newInstance();
                    object2.setFrom(node);
                    object2.setTo(node2);
                    node.addOutEdge((Edge)object2);
                    node2.addInEdge((Edge)object2);
                    break block8;
                }
                object2 = node2.getOutEdges().iterator();
                while (object2.hasNext()) {
                    edge = (Edge)object2.next();
                    if (!edge.getTo().equals(node)) continue;
                    node2.removeOutEdge(edge);
                    node.removeInEdge(edge);
                    break;
                }
                object2 = node.getOutEdges().iterator();
                while (object2.hasNext()) {
                    edge = (Edge)object2.next();
                    if (!edge.getTo().equals(node2)) continue;
                    node.removeOutEdge(edge);
                    node2.removeInEdge(edge);
                    break;
                }
            }
            if (n % 10000 != 0) continue;
            System.out.println("Step=" + n + " clust=" + NetUtilities.calcClustCoef((List)object) + " Dens=" + NetUtilities.calcDensity((List)object));
        }
        return object;
    }

    public ArrayList createRolfeNet(Class clazz, Class clazz2, int n, double d, double d2, double d3, int n2) throws IllegalAccessException, InstantiationException {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
        this.nNodes = n;
        this.density = d;
        this.clustring = d2;
        this.reciProb = d3;
        this.steps = n2;
        ArrayList arrayList = this.createRolfeNet();
        return arrayList;
    }
}

