/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.codegen;

import java.util.ArrayList;
import uchicago.src.codegen.CodeGenerator;
import uchicago.src.codegen.GeneratorUtilities;
import uchicago.src.codegen.IvarGenerator;
import uchicago.src.codegen.MethodGenerator;

public class ClassGenerator
implements CodeGenerator {
    private String name;
    private String ext;
    private String imp;
    private String scope;
    private ArrayList ivars = new ArrayList();
    private ArrayList methods = new ArrayList();
    private ArrayList innerClasses = new ArrayList();

    public ClassGenerator(String string, String string2, String string3, String string4) {
        this.name = string2;
        this.scope = string;
        this.ext = string3 != null ? (string3.length() == 0 ? "" : " extends " + string3) : "";
        this.imp = string4 != null ? (string4.length() == 0 ? "" : " implements " + string4) : "";
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setExtends(String string) {
        this.ext = string;
    }

    public void setImplements(String string) {
        this.imp = string;
    }

    public void addIvar(IvarGenerator ivarGenerator) {
        this.ivars.add(ivarGenerator);
    }

    public void addMethod(MethodGenerator methodGenerator) {
        this.methods.add(methodGenerator);
    }

    public void add(String string, Object object) {
        if (string.equals("IVAR")) {
            this.addIvar((IvarGenerator)object);
        } else if (string.equals("METHOD")) {
            this.addMethod((MethodGenerator)object);
        } else if (string.equals("CLASS_DEF")) {
            this.innerClasses.add((ClassGenerator)object);
        }
    }

    public String generate(int n) {
        CodeGenerator codeGenerator;
        int n2;
        StringBuffer stringBuffer = GeneratorUtilities.getBufferWithIndent(n);
        stringBuffer.append(this.scope);
        if (this.scope.length() == 0) {
            stringBuffer.append("class ");
        } else {
            stringBuffer.append(" class ");
        }
        stringBuffer.append(this.name);
        stringBuffer.append(this.ext);
        stringBuffer.append(this.imp);
        stringBuffer.append(" {\n\n");
        for (n2 = 0; n2 < this.ivars.size(); ++n2) {
            codeGenerator = (CodeGenerator)this.ivars.get(n2);
            stringBuffer.append(codeGenerator.generate(n + 1));
        }
        stringBuffer.append("\n");
        for (n2 = 0; n2 < this.innerClasses.size(); ++n2) {
            codeGenerator = (ClassGenerator)this.innerClasses.get(n2);
            stringBuffer.append(((ClassGenerator)codeGenerator).generate(n + 1));
        }
        if (this.innerClasses.size() > 0) {
            stringBuffer.append("\n");
        }
        for (n2 = 0; n2 < this.methods.size(); ++n2) {
            codeGenerator = (CodeGenerator)this.methods.get(n2);
            stringBuffer.append(codeGenerator.generate(n + 1));
            stringBuffer.append("\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

