/*
 * Decompiled with CFR 0.152.
 */
package anl.repast.gis.data;

import anl.repast.gis.GisAgent;
import anl.repast.gis.data.FeatureArrayList;
import anl.repast.gis.data.FieldNameAndType;
import com.vividsolutions.jts.geom.Envelope;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;

public class GeotoolsData {
    private static GeotoolsData instance = new GeotoolsData();
    static /* synthetic */ Class class$org$geotools$geometry$Geometry;

    public static GeotoolsData getInstance() {
        return instance;
    }

    public void readNeighborhoodInfo(String string, ArrayList arrayList) {
        try {
            Pattern pattern = Pattern.compile(" ");
            String string2 = new String();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            int n = 0;
            bufferedReader.readLine();
            while ((string2 = bufferedReader.readLine()) != null) {
                int[] nArray;
                String[] stringArray = pattern.split(string2);
                n = Integer.parseInt(stringArray[0]) - 1;
                if (Integer.parseInt(stringArray[1]) > 0) {
                    string2 = bufferedReader.readLine();
                    stringArray = pattern.split(string2);
                    nArray = new int[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        nArray[i] = Integer.parseInt(stringArray[i]) - 1;
                    }
                    ((GisAgent)arrayList.get(n)).setNeighbors(nArray);
                    continue;
                }
                string2 = bufferedReader.readLine();
                nArray = new int[]{};
                ((GisAgent)arrayList.get(n)).setNeighbors(nArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public ArrayList createAgents(Class clazz, String string) {
        ArrayList arrayList = new ArrayList();
        try {
            URL uRL = new File(string).toURL();
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(uRL);
            String string2 = shapefileDataStore.getTypeNames()[0];
            FeatureSource featureSource = shapefileDataStore.getFeatureSource(string2);
            FeatureResults featureResults = featureSource.getFeatures();
            FeatureType featureType = featureSource.getSchema();
            FeatureReader featureReader = featureResults.reader();
            while (featureReader.hasNext()) {
                featureReader.next();
                Object t = clazz.newInstance();
                arrayList.add(t);
            }
            featureReader.close();
            for (int i = 0; i < featureType.getAttributeCount(); ++i) {
                Method method;
                AttributeType attributeType;
                if ((class$org$geotools$geometry$Geometry == null ? GeotoolsData.class$("org.geotools.geometry.Geometry") : class$org$geotools$geometry$Geometry).isAssignableFrom((attributeType = featureType.getAttributeType(i)).getType()) || (method = this.getSetMethodForAttributeType(clazz, attributeType)) == null) continue;
                featureReader = featureResults.reader();
                int n = 0;
                while (featureReader.hasNext()) {
                    Feature feature = featureReader.next();
                    Object[] objectArray = new Object[]{feature.getAttribute(i)};
                    method.invoke(arrayList.get(n), objectArray);
                    ++n;
                }
                featureReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList updateAgentsFromShapefile(Class clazz, ArrayList arrayList, String string) {
        try {
            URL uRL = new File(string).toURL();
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(uRL);
            String string2 = shapefileDataStore.getTypeNames()[0];
            FeatureSource featureSource = shapefileDataStore.getFeatureSource(string2);
            FeatureResults featureResults = featureSource.getFeatures();
            FeatureType featureType = featureSource.getSchema();
            FeatureReader featureReader = featureResults.reader();
            for (int i = 0; i < featureType.getAttributeCount(); ++i) {
                Method method;
                AttributeType attributeType;
                if ((class$org$geotools$geometry$Geometry == null ? GeotoolsData.class$("org.geotools.geometry.Geometry") : class$org$geotools$geometry$Geometry).isAssignableFrom((attributeType = featureType.getAttributeType(i)).getType()) || (method = this.getSetMethodForAttributeType(clazz, attributeType)) == null) continue;
                featureReader = featureResults.reader();
                int n = 0;
                while (featureReader.hasNext()) {
                    Feature feature = featureReader.next();
                    Object[] objectArray = new Object[]{feature.getAttribute(i)};
                    method.invoke(arrayList.get(n), objectArray);
                    ++n;
                }
                featureReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public FieldNameAndType[] interrogate(String string) throws IOException {
        FieldNameAndType[] fieldNameAndTypeArray = null;
        try {
            URL uRL = new File(string).toURL();
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(uRL);
            String[] stringArray = shapefileDataStore.getTypeNames();
            for (int i = 0; i < stringArray.length; ++i) {
            }
            FeatureType featureType = shapefileDataStore.getSchema(stringArray[0]);
            AttributeType[] attributeTypeArray = featureType.getAttributeTypes();
            fieldNameAndTypeArray = new FieldNameAndType[attributeTypeArray.length];
            for (int i = 0; i < attributeTypeArray.length; ++i) {
                fieldNameAndTypeArray[i] = new FieldNameAndType(attributeTypeArray[i].getName(), attributeTypeArray[i].getType().getName());
            }
            return fieldNameAndTypeArray;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return fieldNameAndTypeArray;
        }
    }

    public void writeAgents(Collection collection, String string) {
        try {
            Object[] objectArray;
            AttributeType attributeType;
            Object object;
            Feature feature;
            Class<?> clazz = null;
            if (collection.size() > 0) {
                clazz = collection.iterator().next().getClass();
            }
            URL uRL = new File(string).toURL();
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(uRL);
            String string2 = shapefileDataStore.getTypeNames()[0];
            FeatureStore featureStore = (FeatureStore)shapefileDataStore.getFeatureSource(string2);
            FeatureResults featureResults = featureStore.getFeatures();
            FeatureArrayList featureArrayList = new FeatureArrayList();
            FeatureType featureType = featureStore.getSchema();
            FeatureReader featureReader = featureResults.reader();
            Transaction transaction = collection.iterator();
            while (transaction.hasNext()) {
                feature = featureReader.next();
                featureArrayList.add(feature);
                object = transaction.next();
                for (int i = 0; i < featureType.getAttributeCount(); ++i) {
                    if ((class$org$geotools$geometry$Geometry == null ? GeotoolsData.class$("org.geotools.geometry.Geometry") : class$org$geotools$geometry$Geometry).isAssignableFrom((attributeType = featureType.getAttributeType(i)).getType()) || (objectArray = this.getGetMethodForAttributeType(clazz, attributeType)) == null) continue;
                    feature.setAttribute(i, objectArray.invoke(object, null));
                }
            }
            featureReader.close();
            transaction = featureStore.getTransaction();
            feature = shapefileDataStore.getFeatureWriter(string2, Filter.NONE, transaction);
            if (feature == null) {
                System.out.println("Cannot write shapefile, FeatureWriter is null");
            }
            object = featureArrayList.iterator();
            while (object.hasNext()) {
                Feature feature2 = feature.next();
                attributeType = (Feature)object.next();
                objectArray = new Object[attributeType.getNumberOfAttributes()];
                attributeType.getAttributes(objectArray);
                feature2.setAttributes(objectArray);
                feature.write();
            }
            featureArrayList.clear();
            transaction.commit();
            transaction.close();
            feature.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeAgents(Collection collection, String string, String string2) {
        try {
            Object[] objectArray;
            AttributeType attributeType;
            Object object;
            Feature feature;
            Class<?> clazz = null;
            if (collection.size() > 0) {
                clazz = collection.iterator().next().getClass();
            }
            String string3 = string.substring(0, string.length() - 3);
            String string4 = string3 + "dbf";
            String string5 = string3 + "shx";
            String string6 = string2.substring(0, string2.length() - 3);
            String string7 = string6 + "dbf";
            String string8 = string6 + "shx";
            FileChannel fileChannel = new FileInputStream(string).getChannel();
            FileChannel fileChannel2 = new FileInputStream(string4).getChannel();
            FileChannel fileChannel3 = new FileInputStream(string5).getChannel();
            FileChannel fileChannel4 = new FileOutputStream(string2).getChannel();
            FileChannel fileChannel5 = new FileOutputStream(string7).getChannel();
            FileChannel fileChannel6 = new FileOutputStream(string8).getChannel();
            fileChannel4.transferFrom(fileChannel, 0L, fileChannel.size());
            fileChannel5.transferFrom(fileChannel2, 0L, fileChannel2.size());
            fileChannel6.transferFrom(fileChannel3, 0L, fileChannel3.size());
            fileChannel.close();
            fileChannel4.close();
            fileChannel2.close();
            fileChannel5.close();
            fileChannel3.close();
            fileChannel6.close();
            URL uRL = new File(string2).toURL();
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(uRL);
            String string9 = shapefileDataStore.getTypeNames()[0];
            FeatureStore featureStore = (FeatureStore)shapefileDataStore.getFeatureSource(string9);
            FeatureResults featureResults = featureStore.getFeatures();
            FeatureArrayList featureArrayList = new FeatureArrayList();
            FeatureType featureType = featureStore.getSchema();
            FeatureReader featureReader = featureResults.reader();
            Transaction transaction = collection.iterator();
            while (transaction.hasNext()) {
                feature = featureReader.next();
                featureArrayList.add(feature);
                object = transaction.next();
                for (int i = 0; i < featureType.getAttributeCount(); ++i) {
                    if ((class$org$geotools$geometry$Geometry == null ? GeotoolsData.class$("org.geotools.geometry.Geometry") : class$org$geotools$geometry$Geometry).isAssignableFrom((attributeType = featureType.getAttributeType(i)).getType()) || (objectArray = this.getGetMethodForAttributeType(clazz, attributeType)) == null) continue;
                    feature.setAttribute(i, objectArray.invoke(object, null));
                }
            }
            featureReader.close();
            transaction = featureStore.getTransaction();
            feature = shapefileDataStore.getFeatureWriter(string9, Filter.NONE, transaction);
            if (feature == null) {
                System.out.println("Cannot write shapefile, FeatureWriter is null");
            }
            object = featureArrayList.iterator();
            while (object.hasNext()) {
                Feature feature2 = feature.next();
                attributeType = (Feature)object.next();
                objectArray = new Object[attributeType.getNumberOfAttributes()];
                attributeType.getAttributes(objectArray);
                feature2.setAttributes(objectArray);
                feature.write();
            }
            featureArrayList.clear();
            transaction.commit();
            transaction.close();
            feature.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Collection sortGisAgentsByIndex(Collection collection) {
        Collections.sort((List)collection, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((GisAgent)object).getGisAgentIndex() < ((GisAgent)object2).getGisAgentIndex() ? -1 : (((GisAgent)object).getGisAgentIndex() == ((GisAgent)object2).getGisAgentIndex() ? 0 : 1);
            }
        });
        return collection;
    }

    public Envelope getEnvelope(String string) {
        try {
            URL uRL = new File(string).toURL();
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(uRL);
            String string2 = shapefileDataStore.getTypeNames()[0];
            FeatureSource featureSource = shapefileDataStore.getFeatureSource(string2);
            Envelope envelope = featureSource.getBounds();
            return envelope;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public double[] getCenter(Envelope envelope) {
        double[] dArray = new double[]{(envelope.getMinX() + envelope.getMaxX()) / 2.0, (envelope.getMinY() + envelope.getMaxY()) / 2.0};
        return dArray;
    }

    public Method getSetMethodForAttributeType(Class clazz, AttributeType attributeType) {
        Method method = null;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equalsIgnoreCase("set" + attributeType.getName())) continue;
            return methodArray[i];
        }
        return method;
    }

    public Method getGetMethodForAttributeType(Class clazz, AttributeType attributeType) {
        Method method = null;
        String string = attributeType.getName();
        try {
            method = clazz.getMethod("get" + string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            try {
                method = clazz.getMethod("get" + string2, null);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                // empty catch block
            }
        }
        return method;
    }

    public int getAttributePosition(String string, FeatureType featureType) {
        AttributeType[] attributeTypeArray = featureType.getAttributeTypes();
        for (int i = 0; i < attributeTypeArray.length; ++i) {
            if (!attributeTypeArray[i].getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }
}

