/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.tools.dijkstra;

import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.tools.dijkstra.DijkstraEngine;
import epfl.lia.logist.tools.dijkstra.PairOfCities;
import epfl.lia.logist.tools.dijkstra.Path;
import epfl.lia.logist.tools.dijkstra.ShortestPath;
import java.util.ArrayList;

public class DijkstraAlgorithm {
    public static ShortestPath computeShortestPath(Topology topo) {
        ShortestPath result = new ShortestPath();
        ArrayList<City> cities = new ArrayList<City>(topo.getCities().values());
        ArrayList<PairOfCities> pairs = new ArrayList<PairOfCities>();
        int i = 0;
        while (i < cities.size()) {
            int j = i + 1;
            while (j < cities.size()) {
                pairs.add(new PairOfCities(cities.get(i), cities.get(j)));
                ++j;
            }
            ++i;
        }
        while (!pairs.isEmpty()) {
            PairOfCities pair = (PairOfCities)pairs.get(0);
            DijkstraEngine engine = new DijkstraEngine(topo, pairs, result);
            engine.execute(pair.getCity1());
        }
        return result;
    }

    public static City moveOnShortestPathTowards(ShortestPath shortestPathMap, City presentLocation, City destination) {
        PairOfCities pc = new PairOfCities(presentLocation, destination);
        Path path = (Path)shortestPathMap.get(pc);
        City nextCity = path.getNextCityOnPath(presentLocation);
        return nextCity;
    }

    public static double getShortestDistanceBetween(ShortestPath shortestPathMap, City from, City to) {
        if (from.equals((Object)to)) {
            return 0.0;
        }
        if (from == null || to == null) {
            return Double.POSITIVE_INFINITY;
        }
        PairOfCities pc = new PairOfCities(from, to);
        Path path = (Path)shortestPathMap.get(pc);
        return path.getDistance();
    }
}

