/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.testing.messaging;

import epfl.lia.logist.agent.entity.VehicleAgent;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.messaging.MessageDispatcher;
import epfl.lia.logist.messaging.signal.SignalTypeEnum;
import epfl.lia.logist.testing.messaging.Agent1Behavior;
import epfl.lia.logist.testing.messaging.Agent2Behavior;
import epfl.lia.logist.testing.messaging.MessagingTestSender;

public class MessagingSystemTest {
    public static void main(String[] args) {
        boolean bActive = true;
        LogManager mgr = new LogManager();
        try {
            mgr.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MessageDispatcher mdisp = new MessageDispatcher();
        mdisp.init();
        LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "Starting the application...");
        MessagingTestSender testState = new MessagingTestSender();
        LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "Created the state handler");
        VehicleAgent agent1 = new VehicleAgent(testState.getObjectID());
        VehicleAgent agent2 = new VehicleAgent(testState.getObjectID());
        Agent1Behavior myBehavior1 = new Agent1Behavior();
        Agent2Behavior myBehavior2 = new Agent2Behavior();
        agent1.registerBehavior(SignalTypeEnum.SMT_INIT, myBehavior1);
        agent1.registerBehavior(SignalTypeEnum.SMT_TEXT, myBehavior1);
        agent1.registerBehavior(SignalTypeEnum.SMT_KILL, myBehavior1);
        agent2.registerBehavior(SignalTypeEnum.SMT_INIT, myBehavior2);
        agent2.registerBehavior(SignalTypeEnum.SMT_TEXT, myBehavior2);
        agent2.registerBehavior(SignalTypeEnum.SMT_KILL, myBehavior2);
        mdisp.register(agent1);
        mdisp.register(agent2);
        mdisp.register(testState);
        LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "Agents were successfully created !");
        testState.setAgent1(agent1.getObjectID());
        testState.setAgent2(agent2.getObjectID());
        LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "Started both agents");
        new Thread(agent1).start();
        new Thread(agent2).start();
        LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "Entering active loop...");
        testState.initAgents();
        while (bActive) {
            if (testState.hasSmthToDo()) {
                testState.step();
            }
            if (testState.isFinished()) {
                bActive = false;
            }
            Thread.yield();
        }
        LogManager.getInstance().log("stdout", LogSeverityEnum.LSV_INFO, "Application exiting successfull");
        mdisp.shutdown();
        mgr.shutdown();
    }
}

