/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.testing.logging;

import epfl.lia.logist.logging.LogDescriptor;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;

public class TestLogging1 {
    public static void main(String[] args) {
        new TestLogging1();
    }

    public TestLogging1() {
        try {
            LogManager lLogMgr = new LogManager();
            lLogMgr.init();
            this.createAllLogs();
            this.printToLogs(LogSeverityEnum.LSV_DEBUG, "This is a simple debug message !");
            this.printToLogs(LogSeverityEnum.LSV_INFO, "This is a simple piece of information !");
            this.printToLogs(LogSeverityEnum.LSV_WARNING, "This is a warning !");
            this.printToLogs(LogSeverityEnum.LSV_ERROR, "This is a serious error !");
            this.printToLogs(LogSeverityEnum.LSV_FATAL, "This is a fatal error ! Must QUIT !!!");
            lLogMgr.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createAllLogs() throws Exception {
        LogDescriptor lLog1Dsc = new LogDescriptor();
        lLog1Dsc.ID = "log1";
        lLog1Dsc.File = "logfile.log";
        lLog1Dsc.Format = "raw";
        lLog1Dsc.FormatClass = null;
        lLog1Dsc.DebugLevel = "debug";
        lLog1Dsc.MaxEntries = 0;
        lLog1Dsc.CacheSize = 5;
        LogManager.getInstance().createLog(lLog1Dsc);
        LogDescriptor lLog2Dsc = new LogDescriptor();
        lLog2Dsc.ID = "log2";
        lLog2Dsc.File = "logfile.rtf";
        lLog2Dsc.Format = "rtf";
        lLog2Dsc.FormatClass = null;
        lLog2Dsc.DebugLevel = "debug";
        lLog2Dsc.MaxEntries = 0;
        lLog2Dsc.CacheSize = 5;
        LogManager.getInstance().createLog(lLog2Dsc);
        LogDescriptor lLog3Dsc = new LogDescriptor();
        lLog3Dsc.ID = "log3";
        lLog3Dsc.File = "logfile.xml";
        lLog3Dsc.Format = "xml";
        lLog3Dsc.FormatClass = null;
        lLog3Dsc.DebugLevel = "debug";
        lLog3Dsc.MaxEntries = 0;
        lLog3Dsc.CacheSize = 5;
        LogManager.getInstance().createLog(lLog3Dsc);
    }

    public void printToLogs(LogSeverityEnum e, String msg) {
        LogManager.getInstance().log("log1", e, msg);
        LogManager.getInstance().log("log2", e, msg);
        LogManager.getInstance().log("log3", e, msg);
        LogManager.getInstance().log("stdout", e, msg);
    }
}

