/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.security;

import epfl.lia.logist.security.SecurityRule;
import epfl.lia.logist.security.SecurityRuleOpEnum;
import epfl.lia.logist.security.SecurityRuleRightsEnum;
import java.util.ArrayList;

public class SecurityPolicy {
    private ArrayList<SecurityRule> maListOfRules = null;

    public SecurityPolicy() {
        this.init();
    }

    public void init() {
        if (this.maListOfRules != null) {
            this.maListOfRules.clear();
        } else {
            this.maListOfRules = new ArrayList();
        }
    }

    public void shutdown() {
        if (this.maListOfRules != null) {
            this.maListOfRules.clear();
        }
        this.maListOfRules = null;
    }

    public void append(SecurityRule rule) {
        if (!this.maListOfRules.contains(rule)) {
            this.maListOfRules.add(rule);
        }
    }

    public void append(SecurityRuleOpEnum op, String ref, SecurityRuleRightsEnum rights) {
        this.append(new SecurityRule(op, ref, rights));
    }

    public void remove(int id) {
        this.maListOfRules.remove(id);
    }

    public void eval() throws SecurityException {
        for (SecurityRule sr : this.maListOfRules) {
            if (!sr.eval()) continue;
            return;
        }
    }
}

