/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.security;

import epfl.lia.logist.security.SecurityPolicy;

public class SecurityManager {
    private static SecurityManager msSingleton = null;
    private SecurityPolicy moPolicy = null;

    public SecurityManager() {
        if (msSingleton == null) {
            msSingleton = this;
        }
        this.init();
    }

    public void checkAccess() throws Exception {
        if (this.moPolicy != null) {
            this.moPolicy.eval();
        }
    }

    public void definePolicy(SecurityPolicy policy) {
        this.moPolicy = policy;
    }

    public static synchronized SecurityManager getInstance() {
        if (!Thread.currentThread().getThreadGroup().getName().equals("main")) {
            throw new SecurityException("Unauthorized access to Security Manager");
        }
        return msSingleton;
    }

    public void init() {
        this.moPolicy = null;
    }

    public void shutdown() {
        this.moPolicy = null;
    }
}

