/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.core.topology;

import epfl.lia.logist.core.topology.Route;
import epfl.lia.logist.task.TaskManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import uchicago.src.sim.gui.Drawable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.network.DefaultNode;
import uchicago.src.sim.network.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class City
extends DefaultNode
implements Drawable {
    private int x;
    private int y;

    public City(int newX, int newY, String label) {
        super(label);
        this.x = newX;
        this.y = newY;
    }

    public void draw(SimGraphics g) {
        Graphics2D g2 = g.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawRoutes(g);
        this.drawCity(g);
    }

    public ArrayList<Node> getDestinations() {
        return this.getOutNodes();
    }

    private void drawRoutes(SimGraphics g) {
        Iterator it = this.outEdges.iterator();
        int displayScaleWidth = g.getCellWidthScale();
        int displayScaleHeight = g.getCellHeightScale();
        Graphics2D g2 = g.getGraphics();
        while (it.hasNext()) {
            Route e = (Route)((Object)it.next());
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(3.0f));
            g.drawLink(Color.lightGray, displayScaleWidth * this.getX(), displayScaleWidth * ((City)e.getTo()).getX(), displayScaleHeight * this.getY(), displayScaleHeight * ((City)e.getTo()).getY());
            g2.setStroke(oldStroke);
        }
    }

    private void drawCity(SimGraphics g) {
        int yScale = g.getCellHeightScale();
        int xScale = g.getCellWidthScale();
        float curX = this.getX() * xScale;
        float curY = this.getY() * yScale;
        Font currentFont = g.getGraphics().getFont();
        Font font = new Font(currentFont.getName(), currentFont.getStyle(), 12);
        Graphics2D g2 = g.getGraphics();
        String name = this.getNodeLabel();
        FontRenderContext rContext = g2.getFontRenderContext();
        TextLayout layout = new TextLayout(name, font, rContext);
        Rectangle2D bounds = layout.getBounds();
        g2.setPaint(null);
        layout.draw(g2, curX - (float)(bounds.getWidth() / 2.0), curY - 24.0f);
        int ovalSizeX = 15;
        int ovalSizeY = 15;
        g2.setPaint(Color.red);
        g2.fillOval((int)curX - ovalSizeX / 2, (int)curY - ovalSizeY / 2, ovalSizeX, ovalSizeY);
        g2.setPaint(Color.white);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(3.0f));
        g2.drawOval((int)curX - ovalSizeX / 2, (int)curY - ovalSizeY / 2, ovalSizeX, ovalSizeY);
        g2.setStroke(oldStroke);
        int xp = this.x + 10;
        int yp = this.y + 10;
        g2.setPaint(Color.decode("#a02000"));
        g2.fillRect(xp, yp, 8, 8);
        g2.setPaint(Color.orange);
        g2.drawRect(xp, yp, 8, 8);
        g2.drawLine(xp, yp, xp + 8, yp + 8);
        g2.drawLine(xp + 8, yp, xp, yp + 8);
        g2.setPaint(Color.decode("#a02088"));
        g2.fillRect(this.x + 10, this.y + 20, 8, 8);
        g2.setPaint(Color.orange);
        g2.drawRect(this.x + 10, this.y + 20, 8, 8);
        g2.drawLine(xp, yp + 10, xp + 8, yp + 18);
        g2.drawLine(xp + 8, yp + 10, xp, yp + 18);
        int iTasks = TaskManager.getInstance().getPickupTaskCount(this.label);
        g2.drawString("x" + iTasks, this.x + 20, this.y + 17);
        iTasks = TaskManager.getInstance().getDeliveredTaskCount(this.label);
        g2.drawString("x" + iTasks, this.x + 20, this.y + 27);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int newX) {
        this.x = newX;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int newY) {
        this.y = newY;
    }

    public void setXY(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    public int compareTo(Object o) {
        City c = (City)((Object)o);
        return this.getX() - c.getX();
    }

    public boolean equals(Object city) {
        if (city == null) {
            return false;
        }
        return this.getX() == ((City)((Object)city)).getX() && this.getY() == ((City)((Object)city)).getY();
    }

    public boolean match(City city) {
        return this.getNodeLabel().equals(city.getNodeLabel());
    }

    public int hashCode() {
        return new Integer(this.getX()).hashCode() + new Integer(this.getY()).hashCode();
    }

    public String toString() {
        return "city<" + this.getNodeLabel() + "," + this.x + "," + this.y + ">";
    }

    public Route getRouteTo(City destination) {
        if (this.hasEdgeTo((Node)destination)) {
            HashSet h = this.getEdgesTo((Node)destination);
            return (Route)((Object)h.iterator().next());
        }
        return null;
    }
}

