/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent.state.reactive;

import epfl.lia.logist.agent.AgentProfile;
import epfl.lia.logist.agent.AgentStateEnum;
import epfl.lia.logist.agent.state.AgentState;
import epfl.lia.logist.agent.state.VehicleAgentState;
import epfl.lia.logist.messaging.action.Action;
import epfl.lia.logist.messaging.action.ActionTypeEnum;
import epfl.lia.logist.messaging.signal.InCityObject;
import epfl.lia.logist.task.ProbabilityDistribution;
import epfl.lia.logist.task.TaskGenerator;
import epfl.lia.logist.task.TaskManager;
import epfl.lia.logist.task.distribution.ITaskDistribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactiveVehicleState
extends VehicleAgentState {
    private long mStartTime = 0L;

    public ReactiveVehicleState(AgentProfile ap, AgentState as) {
        super(ap, as);
    }

    @Override
    protected void execute(Action<?> action) {
        switch (this.mState) {
            case AS_SETUP: {
                TaskManager lTaskMgr = TaskManager.getInstance();
                TaskGenerator lTaskGen = lTaskMgr.getGenerator();
                ITaskDistribution lTaskDistr = lTaskGen.getDistribution();
                ProbabilityDistribution lProbDistr = lTaskDistr.getProbabilityDistribution();
                this.postSetupSignal(lProbDistr);
                this.mLastState = AgentStateEnum.AS_SETUP;
                this.mState = AgentStateEnum.AS_THREADED_WAIT;
                this.mStartTime = System.currentTimeMillis();
                break;
            }
            case AS_THREADED_WAIT: {
                if (action != null && action.getType() == ActionTypeEnum.AMT_READY) {
                    this.mState = AgentStateEnum.AS_IDLE;
                    break;
                }
                if (System.currentTimeMillis() - this.mStartTime < this.mProfile.getSetupTimeout()) break;
                this.warning("The agent has passed the setup time !");
                this.mAgentMgr.removeAgent(this.mProfile);
                break;
            }
            case AS_IDLE: {
                InCityObject lObject = this.createInCityObject(true);
                this.postInCitySignal(lObject);
                this.mLastState = AgentStateEnum.AS_IDLE;
                this.mState = AgentStateEnum.AS_WAIT;
            }
        }
    }
}

