/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent.plan;

import epfl.lia.logist.agent.AgentProfile;
import epfl.lia.logist.agent.AgentProperties;
import epfl.lia.logist.agent.plan.GDeliverAction;
import epfl.lia.logist.agent.plan.GMoveAction;
import epfl.lia.logist.agent.plan.GPickupAction;
import epfl.lia.logist.agent.plan.IGenericAction;
import epfl.lia.logist.agent.plan.Plan;
import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.task.Task;
import java.util.ArrayList;
import java.util.HashMap;

public class PlanVerifier {
    public static boolean isValid(Plan p, AgentProfile ap) {
        LogManager log = LogManager.getInstance();
        if (p == null) {
            return false;
        }
        if (!ap.getState().planMeetsConditions(p)) {
            return false;
        }
        Plan plan = (Plan)p.clone();
        ArrayList<Task> pickedTasks = new ArrayList<Task>();
        HashMap<City, Integer> cityCount = new HashMap<City, Integer>();
        AgentProperties properties = ap.getProperties();
        double currentLoad = properties.Load;
        while (plan.hasMoreElements()) {
            IGenericAction ga = plan.nextElement();
            switch (ga.getType()) {
                case PICKUP: {
                    Task t = ((GPickupAction)ga).getTask();
                    if (t == null) {
                        log.warning("Plan " + plan + " is invalid !");
                        log.warning("Found an empty task in plan ");
                        return false;
                    }
                    if (pickedTasks.contains(t)) {
                        return false;
                    }
                    if ((currentLoad += t.getWeight()) > properties.Capacity) {
                        log.warning("Plan " + plan + " is invalid !");
                        log.warning("The capacity is not sufficient to  store all tasks.");
                        log.warning("The current load is " + currentLoad);
                        log.warning("The initial load was " + properties.Load);
                        log.warning("The vehicle capacity is " + properties.Capacity);
                        return false;
                    }
                    pickedTasks.add(t);
                    break;
                }
                case MOVE: {
                    City c = ((GMoveAction)ga).getTarget();
                    if (c == null) {
                        log.warning("Plan " + plan + " is invalid !");
                        log.warning("The target city is null !");
                        return false;
                    }
                    if (!cityCount.containsKey((Object)c)) {
                        cityCount.put(c, new Integer(1));
                        break;
                    }
                    Integer count = (Integer)cityCount.get((Object)c);
                    count = count + 1;
                    cityCount.put(c, count);
                    break;
                }
                case DELIVER: {
                    Task t = ((GDeliverAction)ga).getTask();
                    if (t == null) {
                        log.warning("Plan " + plan + " is invalid !");
                        log.warning("Delivering a null task !");
                        return false;
                    }
                    currentLoad -= t.getWeight();
                    pickedTasks.remove(t);
                }
            }
        }
        if (pickedTasks.size() > 0) {
            log.warning("Plan " + plan + " is invalid !");
            log.warning("Some tasks were not delivered. Still remaining to be delivered are:");
            for (Task t : pickedTasks) {
                log.warning("" + t);
            }
            return false;
        }
        if (cityCount.size() == 0) {
            log.warning("Plan " + plan + " is invalid !");
            log.warning("There are no actions in the plan !");
            return false;
        }
        return true;
    }
}

