/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent.entity;

import epfl.lia.logist.agent.behavior.Behavior;
import epfl.lia.logist.agent.behavior.response.BehaviorResponseTypeEnum;
import epfl.lia.logist.agent.behavior.response.BidBehaviorResponse;
import epfl.lia.logist.agent.behavior.response.IBehaviorResponse;
import epfl.lia.logist.agent.behavior.response.MoveBehaviorResponse;
import epfl.lia.logist.agent.behavior.response.PickupBehaviorResponse;
import epfl.lia.logist.agent.behavior.response.PlanBehaviorResponse;
import epfl.lia.logist.agent.behavior.response.StrategyBehaviorResponse;
import epfl.lia.logist.exception.BehaviorExecutionError;
import epfl.lia.logist.exception.BehaviorNotImplementedError;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.messaging.Message;
import epfl.lia.logist.messaging.MessageDispatcher;
import epfl.lia.logist.messaging.MessageHandler;
import epfl.lia.logist.messaging.MessageTypeEnum;
import epfl.lia.logist.messaging.action.Action;
import epfl.lia.logist.messaging.action.BidAction;
import epfl.lia.logist.messaging.action.MoveAction;
import epfl.lia.logist.messaging.action.PickupAction;
import epfl.lia.logist.messaging.action.PlanAction;
import epfl.lia.logist.messaging.action.ReadyAction;
import epfl.lia.logist.messaging.action.StrategyAction;
import epfl.lia.logist.messaging.signal.Signal;
import epfl.lia.logist.messaging.signal.SignalTypeEnum;
import epfl.lia.logist.tools.AID;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent
extends MessageHandler
implements Runnable {
    private HashMap<SignalTypeEnum, Behavior> mMapOfBehaviors = null;
    private MessageDispatcher mDispatcher = null;
    private boolean mbActive = true;
    private AID mStateID = null;
    private Thread mThread = null;

    public Agent(AID stateID) {
        this.mStateID = stateID;
        this.mDispatcher = MessageDispatcher.getInstance();
        this.mMapOfBehaviors = new HashMap();
        this.mDispatcher.register(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                while (this.mbActive) {
                    Message<?> msg;
                    if (this.mDispatcher == null) {
                        return;
                    }
                    if (this.mDispatcher.check(this) && (msg = this.mDispatcher.retrieve(this)) != null && msg.getMsgType() == MessageTypeEnum.MGT_SIGNAL) {
                        Signal signal = (Signal)msg;
                        this.dispatchSignal(signal);
                        if (signal.getType() == SignalTypeEnum.SMT_KILL) {
                            this.mbActive = false;
                        }
                    }
                    Thread.yield();
                }
                return;
            }
            catch (Exception e2) {
                LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Agent exception: " + e2.getMessage());
                e2.printStackTrace();
                return;
            }
        }
        finally {
            LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Thread has been killed !!!");
        }
    }

    public boolean isActive() {
        return this.mbActive;
    }

    public void start(String name) {
        this.mThread = new Thread((Runnable)this, name);
        this.mThread.start();
    }

    private void dispatchSignal(Signal m) {
        Behavior behavior = this.mMapOfBehaviors.get((Object)m.getType());
        if (behavior != null) {
            try {
                IBehaviorResponse br = behavior.execute(m);
                if (br.getType() != BehaviorResponseTypeEnum.BRT_EMPTY) {
                    this.handleResponse(br);
                }
            }
            catch (BehaviorNotImplementedError err1) {
                System.err.println("Err1: " + err1);
            }
            catch (BehaviorExecutionError err2) {
                System.err.println("Err2: " + err2);
            }
        }
    }

    private void handleResponse(IBehaviorResponse br) {
        switch (br.getType()) {
            case BRT_READY: {
                this.postMessage(new ReadyAction(this.mObjectID, this.mStateID));
                break;
            }
            case BRT_PICKUP: {
                this.postMessage(new PickupAction(this.mObjectID, this.mStateID, new Integer(((PickupBehaviorResponse)br).getTaskID())));
                break;
            }
            case BRT_MOVETO: {
                this.postMessage(new MoveAction(this.mObjectID, this.mStateID, ((MoveBehaviorResponse)br).getDestination()));
                break;
            }
            case BRT_PLAN: {
                this.postMessage(new PlanAction(this.mObjectID, this.mStateID, ((PlanBehaviorResponse)br).getPlan()));
                break;
            }
            case BRT_BID: {
                this.postMessage(new BidAction(this.mObjectID, this.mStateID, ((BidBehaviorResponse)br).getBid()));
                break;
            }
            case BRT_STRATEGY: {
                this.postMessage(new StrategyAction(this.mObjectID, this.mStateID, ((StrategyBehaviorResponse)br).getPlans()));
            }
        }
    }

    private void postMessage(Action<?> action) {
        MessageDispatcher.getInstance().post(action);
    }

    public void registerBehavior(SignalTypeEnum st, Behavior b) {
        this.mMapOfBehaviors.put(st, b);
    }

    public void unregisterBehavior(SignalTypeEnum st) {
        if (this.mMapOfBehaviors.containsKey((Object)st)) {
            this.mMapOfBehaviors.remove((Object)st);
        }
    }
}

